/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.common.preprocess;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.docx4j.TraversalUtil;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.utils.TraversalUtilVisitor;
import org.docx4j.wml.CTSimpleField;
import org.docx4j.wml.FldChar;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.docx4j.wml.STFldCharType;
import org.docx4j.wml.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldsCombiner {
    private static Logger log = LoggerFactory.getLogger(FieldsCombiner.class);
    protected static final CombineVisitor COMBINE_VISITOR = new CombineVisitor();

    public static void process(WordprocessingMLPackage wmlPackage) {
        log.info("starting");
        TraversalUtil.visit(wmlPackage, false, COMBINE_VISITOR);
        if (log.isDebugEnabled()) {
            log.debug(XmlUtils.marshaltoString(wmlPackage.getMainDocumentPart().getJaxbElement(), true, true));
        }
    }

    protected static class CombineVisitor
    extends TraversalUtilVisitor<P> {
        private static final QName _RInstrText_QNAME = new QName("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "instrText");
        private static final int STATE_NONE = 0;
        private static final int STATE_EXPECT_BEGIN = 1;
        private static final int STATE_EXPECT_INSTR = 2;
        private static final int STATE_EXPECT_RESULT = 4;

        protected CombineVisitor() {
        }

        @Override
        public void apply(P element) {
            this.processContent(element.getContent());
        }

        protected void processContent(List<Object> pContent) {
            ArrayList<Object> pResult = null;
            boolean haveChanges = false;
            boolean inField = false;
            Object item = null;
            STFldCharType fldCharType = null;
            int level = 0;
            int state = 1;
            int markIdx = 0;
            ArrayList<Object> resultList = new ArrayList<Object>(2);
            StringBuilder instrTextBuffer = new StringBuilder(128);
            String tmpInstrText = null;
            if (pContent != null && !pContent.isEmpty()) {
                pResult = new ArrayList<Object>(pContent.size());
                for (int i = 0; i < pContent.size(); ++i) {
                    item = pContent.get(i);
                    if (item instanceof R) {
                        fldCharType = this.getFldCharType((R)item);
                        if (fldCharType != null) {
                            if (STFldCharType.BEGIN.equals((Object)fldCharType)) {
                                ++level;
                                state = 2;
                                if (markIdx < i) {
                                    this.copyItems(pContent, markIdx, i, pResult);
                                    instrTextBuffer.setLength(0);
                                    resultList.clear();
                                }
                                markIdx = i;
                                continue;
                            }
                            if (STFldCharType.SEPARATE.equals((Object)fldCharType)) {
                                state = 4;
                                continue;
                            }
                            if (!STFldCharType.END.equals((Object)fldCharType) || level <= 0) continue;
                            state = 1;
                            if (!resultList.isEmpty() && instrTextBuffer.length() > 0) {
                                pResult.add(this.createFldSimple(instrTextBuffer.toString(), resultList));
                                haveChanges = true;
                                markIdx = i + 1;
                            }
                            instrTextBuffer.setLength(0);
                            resultList.clear();
                            --level;
                            continue;
                        }
                        switch (state) {
                            case 2: {
                                tmpInstrText = this.getInstrText((R)item);
                                if (tmpInstrText == null) break;
                                instrTextBuffer.append(tmpInstrText);
                                break;
                            }
                            case 4: {
                                resultList.add(item);
                            }
                        }
                        continue;
                    }
                    if (item instanceof JAXBElement && ((JAXBElement)item).getValue() instanceof CTSimpleField) {
                        if (markIdx < i) {
                            this.copyItems(pContent, markIdx, i, pResult);
                        }
                        pResult.add(item);
                        instrTextBuffer.setLength(0);
                        resultList.clear();
                        markIdx = i + 1;
                        state = 1;
                        continue;
                    }
                    if (!(item instanceof JAXBElement) || !(((JAXBElement)item).getValue() instanceof P.Hyperlink)) continue;
                    this.processContent(((P.Hyperlink)((JAXBElement)item).getValue()).getContent());
                }
                if (haveChanges) {
                    if (markIdx < pContent.size()) {
                        this.copyItems(pContent, markIdx, pContent.size(), pResult);
                    }
                    pContent.clear();
                    pContent.addAll(pResult);
                }
            }
        }

        private String getInstrText(R run) {
            List rContent = run.getContent();
            Object item = null;
            Text text = null;
            for (int i = 0; i < rContent.size(); ++i) {
                item = rContent.get(i);
                if (!(item instanceof JAXBElement) || !((JAXBElement)item).getName().equals(_RInstrText_QNAME)) continue;
                text = (Text)((JAXBElement)item).getValue();
                break;
            }
            return text != null ? text.getValue() : null;
        }

        private Object createFldSimple(String instrText, List<Object> resultList) {
            CTSimpleField fldSimple = Context.getWmlObjectFactory().createCTSimpleField();
            fldSimple.setInstr(instrText);
            if (resultList != null && !resultList.isEmpty()) {
                fldSimple.getContent().addAll(resultList);
            }
            return fldSimple;
        }

        private void copyItems(List<Object> source, int startIdx, int endIdx, List<Object> destination) {
            for (int i = startIdx; i < endIdx; ++i) {
                destination.add(source.get(i));
            }
        }

        private STFldCharType getFldCharType(R r) {
            STFldCharType ret = null;
            List rContent = r.getContent();
            Object item = null;
            if (rContent != null && !rContent.isEmpty()) {
                for (int i = 0; i < rContent.size(); ++i) {
                    item = XmlUtils.unwrap(rContent.get(i));
                    if (!(item instanceof FldChar)) continue;
                    ret = ((FldChar)item).getFldCharType();
                    break;
                }
            }
            return ret;
        }
    }
}

