/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.transform.poi;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.jxls.common.CellRef;
import org.jxls.common.RowData;
import org.jxls.transform.Transformer;
import org.jxls.transform.poi.PoiCellData;
import org.jxls.transform.poi.PoiTransformer;

public class PoiRowData
extends RowData {
    Row row;

    public static RowData createRowData(Row row, PoiTransformer transformer) {
        if (row == null) {
            return null;
        }
        PoiRowData rowData = new PoiRowData();
        rowData.setTransformer((Transformer)transformer);
        rowData.row = row;
        rowData.height = row.getHeight();
        int numberOfCells = row.getLastCellNum();
        for (int cellIndex = 0; cellIndex < numberOfCells; ++cellIndex) {
            Cell cell = row.getCell(cellIndex);
            if (cell != null) {
                PoiCellData cellData = PoiCellData.createCellData(new CellRef(row.getSheet().getSheetName(), row.getRowNum(), cellIndex), cell);
                cellData.setTransformer((Transformer)transformer);
                rowData.addCellData(cellData);
                continue;
            }
            rowData.addCellData(null);
        }
        return rowData;
    }

    public Row getRow() {
        return this.row;
    }
}

