/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.jdbc.connections;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.grails.datastore.gorm.jdbc.DataSourceBuilder;
import org.grails.datastore.gorm.jdbc.connections.DataSourceConnectionSource;
import org.grails.datastore.gorm.jdbc.connections.DataSourceSettings;
import org.grails.datastore.gorm.jdbc.connections.DataSourceSettingsBuilder;
import org.grails.datastore.mapping.core.connections.AbstractConnectionSourceFactory;
import org.grails.datastore.mapping.core.connections.ConnectionSource;
import org.grails.datastore.mapping.core.connections.ConnectionSourceSettings;
import org.grails.datastore.mapping.core.connections.DefaultConnectionSource;
import org.grails.datastore.mapping.core.exceptions.ConfigurationException;
import org.springframework.core.env.PropertyResolver;
import org.springframework.jdbc.datasource.LazyConnectionDataSourceProxy;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.jndi.JndiObjectFactoryBean;

public class DataSourceConnectionSourceFactory
extends AbstractConnectionSourceFactory<DataSource, DataSourceSettings> {
    protected <F extends ConnectionSourceSettings> DataSourceSettings buildSettings(String name, PropertyResolver configuration, F fallbackSettings, boolean isDefaultDataSource) {
        String qualified;
        Map config;
        String configurationPrefix;
        String string = configurationPrefix = isDefaultDataSource ? "dataSource" : "dataSources." + name;
        DataSourceSettingsBuilder builder = isDefaultDataSource ? (!(config = (Map)configuration.getProperty(qualified = "dataSources.dataSource", Map.class, Collections.emptyMap())).isEmpty() ? new DataSourceSettingsBuilder(configuration, qualified) : new DataSourceSettingsBuilder(configuration, configurationPrefix)) : new DataSourceSettingsBuilder(configuration, configurationPrefix);
        DataSourceSettings settings = (DataSourceSettings)builder.build();
        return settings;
    }

    public ConnectionSource<DataSource, DataSourceSettings> create(String name, DataSourceSettings settings) {
        if (settings.getJndiName() != null) {
            JndiObjectFactoryBean jndiObjectFactoryBean = new JndiObjectFactoryBean();
            jndiObjectFactoryBean.setExpectedType(DataSource.class);
            jndiObjectFactoryBean.setJndiName(settings.getJndiName());
            try {
                jndiObjectFactoryBean.afterPropertiesSet();
            }
            catch (NamingException e) {
                throw new ConfigurationException("Unable to configure JNDI data source: " + e.getMessage(), (Throwable)e);
            }
            DataSource dataSource = (DataSource)jndiObjectFactoryBean.getObject();
            dataSource = this.proxy(dataSource, settings);
            return new DefaultConnectionSource(name, (Object)dataSource, (ConnectionSourceSettings)settings);
        }
        DataSourceBuilder dataSourceBuilder = new DataSourceBuilder(((Object)((Object)this)).getClass().getClassLoader());
        dataSourceBuilder.setPooled(settings.isPooled());
        dataSourceBuilder.setReadOnly(settings.isReadOnly());
        String driverClassName = settings.getDriverClassName();
        String username = settings.getUsername();
        String password = settings.getPassword();
        Map properties = settings.getProperties();
        String url = settings.getUrl();
        Class<? extends DataSource> type = settings.getType();
        if (properties != null && !properties.isEmpty()) {
            dataSourceBuilder.properties(settings.toProperties());
        }
        dataSourceBuilder.url(url);
        if (driverClassName != null) {
            dataSourceBuilder.driverClassName(driverClassName);
        }
        if (username != null && password != null) {
            dataSourceBuilder.username(username);
            dataSourceBuilder.password(password);
        }
        if (type != null) {
            dataSourceBuilder.type(type);
        }
        DataSource dataSource = dataSourceBuilder.build();
        dataSource = this.proxy(dataSource, settings);
        return new DataSourceConnectionSource(name, dataSource, settings);
    }

    protected DataSource proxy(DataSource dataSource, DataSourceSettings settings) {
        if (settings.isLazy()) {
            dataSource = new LazyConnectionDataSourceProxy(dataSource);
        }
        if (settings.isTransactionAware()) {
            dataSource = new TransactionAwareDataSourceProxy(dataSource);
        }
        return dataSource;
    }

    public Serializable getConnectionSourcesConfigurationKey() {
        return "dataSources";
    }
}

