/*
 * Decompiled with CFR 0.152.
 */
package asset.pipeline.fs;

import asset.pipeline.AssetFile;
import asset.pipeline.AssetHelper;
import asset.pipeline.GenericAssetFile;
import asset.pipeline.fs.AbstractAssetResolver;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.IntRange;
import groovy.lang.MetaClass;
import groovy.lang.Range;
import groovy.lang.Reference;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemAssetResolver
extends AbstractAssetResolver<File> {
    private static String QUOTED_FILE_SEPARATOR;
    private static String DIRECTIVE_FILE_SEPARATOR;
    private File baseDirectory;
    private List<String> scanDirectories;
    private List<FileSystemAssetResolver> resolvers;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public FileSystemAssetResolver(String name, String basePath, boolean flattenSubDirectories) {
        MetaClass metaClass;
        List list;
        List list2;
        CallSite[] callSiteArray = FileSystemAssetResolver.$getCallSiteArray();
        super(name);
        this.scanDirectories = list2 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.resolvers = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Object object = callSiteArray[0].callConstructor(File.class, (Object)basePath);
        this.baseDirectory = (File)ScriptBytecodeAdapter.castToType((Object)object, File.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[1].call((Object)this.baseDirectory))) {
            if (flattenSubDirectories) {
                Object scopedDirectories = callSiteArray[2].call((Object)this.baseDirectory);
                if (!BytecodeInterface8.isOrigZ() || BytecodeInterface8.disabledStandardMetaClass()) {
                    Object scopedDirectory = null;
                    Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[3].call(scopedDirectories), Iterator.class);
                    while (iterator.hasNext()) {
                        scopedDirectory = iterator.next();
                        if (!(DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[4].call(scopedDirectory)) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[5].call(callSiteArray[6].call(scopedDirectory), (Object)".")) && ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[7].call(scopedDirectory), (Object)"WEB-INF") && ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[8].call(scopedDirectory), (Object)"META-INF"))) continue;
                        callSiteArray[9].call(this.resolvers, callSiteArray[10].callConstructor(FileSystemAssetResolver.class, (Object)name, callSiteArray[11].callGetProperty(scopedDirectory), (Object)false));
                    }
                } else {
                    Object scopedDirectory = null;
                    Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[12].call(scopedDirectories), Iterator.class);
                    while (iterator.hasNext()) {
                        scopedDirectory = iterator.next();
                        if (!(DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[13].call(scopedDirectory)) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[14].call(callSiteArray[15].call(scopedDirectory), (Object)".")) && ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[16].call(scopedDirectory), (Object)"WEB-INF") && ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[17].call(scopedDirectory), (Object)"META-INF"))) continue;
                        callSiteArray[18].call(this.resolvers, callSiteArray[19].callConstructor(FileSystemAssetResolver.class, (Object)name, callSiteArray[20].callGetProperty(scopedDirectory), (Object)false));
                    }
                }
            } else {
                callSiteArray[21].call(this.scanDirectories, callSiteArray[22].callGetProperty((Object)this.baseDirectory));
            }
        }
        Object object2 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[23].call((Object)log)) ? callSiteArray[24].call((Object)log, (Object)new GStringImpl(new Object[]{this.scanDirectories}, new String[]{"Asset Pipeline FSResolver Initialized with Scan Directories: ", ""})) : null;
    }

    public FileSystemAssetResolver(String name, String basePath) {
        CallSite[] callSiteArray = FileSystemAssetResolver.$getCallSiteArray();
        this(name, basePath, true);
    }

    @Override
    public AssetFile getAsset(String relativePath, String contentType, String extension, AssetFile baseFile) {
        Reference extension2 = new Reference((Object)extension);
        CallSite[] callSiteArray = FileSystemAssetResolver.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)relativePath)) {
            return (AssetFile)ScriptBytecodeAdapter.castToType(null, AssetFile.class);
        }
        Object object = callSiteArray[25].call((Object)relativePath, (Object)QUOTED_FILE_SEPARATOR, (Object)DIRECTIVE_FILE_SEPARATOR);
        relativePath = ShortTypeHandling.castToString((Object)object);
        Object specs = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)contentType)) {
            Object object2;
            specs = object2 = callSiteArray[26].call(AssetHelper.class, (Object)contentType);
        } else {
            Object object3;
            if (!DefaultTypeTransformation.booleanUnbox((Object)((String)extension2.get()))) {
                Object object4 = callSiteArray[27].call(AssetHelper.class, (Object)relativePath);
                extension2.set((Object)ShortTypeHandling.castToString((Object)object4));
            }
            public class _getAsset_closure1
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference extension;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _getAsset_closure1(Object _outerInstance, Object _thisObject, Reference extension) {
                    Reference reference;
                    CallSite[] callSiteArray = _getAsset_closure1.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.extension = reference = extension;
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _getAsset_closure1.$getCallSiteArray();
                    return callSiteArray[0].call(callSiteArray[1].callGetProperty(it), this.extension.get());
                }

                public String getExtension() {
                    CallSite[] callSiteArray = _getAsset_closure1.$getCallSiteArray();
                    return ShortTypeHandling.castToString((Object)this.extension.get());
                }

                public Object doCall() {
                    CallSite[] callSiteArray = _getAsset_closure1.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getAsset_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "contains";
                    stringArray[1] = "extensions";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[2];
                    _getAsset_closure1.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_getAsset_closure1.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _getAsset_closure1.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            specs = object3 = callSiteArray[28].call(callSiteArray[29].call(AssetHelper.class), (Object)new _getAsset_closure1(this, this, extension2));
        }
        Object directoryPath = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[30].call(this.scanDirectories), Iterator.class);
        while (iterator.hasNext()) {
            directoryPath = iterator.next();
            AssetFile assetFile = (AssetFile)ScriptBytecodeAdapter.castToType((Object)callSiteArray[31].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)specs, directoryPath, (Object)relativePath, (Object)baseFile, (Object)((String)extension2.get()))), AssetFile.class);
            if (!DefaultTypeTransformation.booleanUnbox((Object)assetFile)) continue;
            return assetFile;
        }
        Object resolver = null;
        Iterator iterator2 = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[32].call(this.resolvers), Iterator.class);
        while (iterator2.hasNext()) {
            resolver = iterator2.next();
            AssetFile assetFile = (AssetFile)ScriptBytecodeAdapter.castToType((Object)callSiteArray[33].call(resolver, (Object)relativePath, (Object)contentType, (Object)((String)extension2.get()), (Object)baseFile), AssetFile.class);
            if (!DefaultTypeTransformation.booleanUnbox((Object)assetFile)) continue;
            return assetFile;
        }
        return (AssetFile)ScriptBytecodeAdapter.castToType(null, AssetFile.class);
    }

    @Override
    protected File getRelativeFile(String relativePath, String name) {
        CallSite[] callSiteArray = FileSystemAssetResolver.$getCallSiteArray();
        return (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[34].callConstructor(File.class, (Object)relativePath, (Object)name), File.class);
    }

    @Override
    protected Closure<InputStream> createInputStreamClosure(File file) {
        Reference file2 = new Reference((Object)file);
        CallSite[] callSiteArray = FileSystemAssetResolver.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[35].call((Object)((File)file2.get()))) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[36].call((Object)((File)file2.get())))) {
            public class _createInputStreamClosure_closure2
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference file;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _createInputStreamClosure_closure2(Object _outerInstance, Object _thisObject, Reference file) {
                    Reference reference;
                    CallSite[] callSiteArray = _createInputStreamClosure_closure2.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.file = reference = file;
                }

                public Object doCall() {
                    CallSite[] callSiteArray = _createInputStreamClosure_closure2.$getCallSiteArray();
                    return callSiteArray[0].call(this.file.get());
                }

                public File getFile() {
                    CallSite[] callSiteArray = _createInputStreamClosure_closure2.$getCallSiteArray();
                    return (File)ScriptBytecodeAdapter.castToType((Object)this.file.get(), File.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _createInputStreamClosure_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[1];
                    stringArray[0] = "newInputStream";
                    return new CallSiteArray(_createInputStreamClosure_closure2.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _createInputStreamClosure_closure2.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            return new _createInputStreamClosure_closure2(this, this, file2);
        }
        return (Closure)ScriptBytecodeAdapter.castToType(null, Closure.class);
    }

    @Override
    public List<AssetFile> getAssets(String basePath, String contentType, String extension, Boolean recursive, AssetFile relativeFile, AssetFile baseFile) {
        List fileList = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        String translatedBasePath = basePath;
        if (!basePath.startsWith("/") && relativeFile != null) {
            String string;
            ArrayList pathArgs = DefaultTypeTransformation.booleanUnbox((Object)relativeFile.getParentPath()) ? DefaultGroovyMethods.toList((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)relativeFile.getParentPath().split(DIRECTIVE_FILE_SEPARATOR), Object[].class))) : new ArrayList();
            String[] basePathArgs = basePath.split(DIRECTIVE_FILE_SEPARATOR);
            List parentPathArgs = DefaultTypeTransformation.booleanUnbox(pathArgs) ? DefaultGroovyMethods.getAt(pathArgs, (Range)new IntRange(true, 0, pathArgs.size() - 1)) : ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            parentPathArgs.addAll(DefaultGroovyMethods.toList((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)basePathArgs, Object[].class))));
            translatedBasePath = string = DefaultGroovyMethods.join((Iterable)parentPathArgs, (String)File.separator);
        }
        String directoryPath = null;
        Iterator<String> iterator = this.scanDirectories.iterator();
        while (iterator.hasNext()) {
            directoryPath = ShortTypeHandling.castToString((Object)iterator.next());
            File file = new File(directoryPath, translatedBasePath);
            if (!(file.exists() && file.isDirectory())) continue;
            this.recursiveTreeAppend(file, fileList, contentType, baseFile, DefaultTypeTransformation.booleanUnbox((Object)recursive), directoryPath);
        }
        FileSystemAssetResolver resolver = null;
        Iterator<FileSystemAssetResolver> iterator2 = this.resolvers.iterator();
        while (iterator2.hasNext()) {
            List list;
            resolver = (FileSystemAssetResolver)ScriptBytecodeAdapter.castToType((Object)iterator2.next(), FileSystemAssetResolver.class);
            fileList = list = DefaultGroovyMethods.plus((List)fileList, resolver.getAssets(basePath, contentType, extension, recursive, relativeFile, baseFile));
        }
        return fileList;
    }

    protected void recursiveTreeAppend(File directory, List<AssetFile> tree, String contentType, AssetFile baseFile, boolean recursive, String sourceDirectory) {
        List list;
        List files = DefaultGroovyMethods.toList((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)directory.listFiles(), Object[].class)));
        List list2 = files;
        public class _recursiveTreeAppend_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _recursiveTreeAppend_closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(File a, File b) {
                return a.getName().compareTo(b.getName());
            }

            public Object call(File a, File b) {
                return this.doCall(a, b);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _recursiveTreeAppend_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        files = list = list2 != null ? DefaultGroovyMethods.sort((Iterable)list2, (Closure)new _recursiveTreeAppend_closure3(this, this)) : null;
        File file = null;
        Iterator iterator = files.iterator();
        while (iterator.hasNext()) {
            file = (File)ScriptBytecodeAdapter.castToType(iterator.next(), File.class);
            String[] mimeType = (String[])ScriptBytecodeAdapter.castToType(AssetHelper.assetMimeTypeForURI(file.getAbsolutePath()), String[].class);
            if (file.isDirectory() && recursive) {
                this.recursiveTreeAppend(file, tree, contentType, baseFile, recursive, sourceDirectory);
                continue;
            }
            if (!(!file.isDirectory() && DefaultTypeTransformation.booleanUnbox((Object)mimeType) && DefaultTypeTransformation.booleanUnbox((Object)(mimeType == null ? Boolean.valueOf(contentType == null) : Boolean.valueOf(DefaultGroovyMethods.isCase((Object)mimeType, (Object)contentType)))))) continue;
            DefaultGroovyMethods.leftShift(tree, (Object)this.assetForFile(file, contentType, baseFile, sourceDirectory));
        }
    }

    @Override
    protected String getFileName(File file) {
        return file.getName();
    }

    @Override
    protected String relativePathToResolver(File file, String scanDirectoryPath) {
        String filePath = null;
        try {
            String string;
            filePath = string = file.toPath().toRealPath(LinkOption.NOFOLLOW_LINKS).toString();
        }
        catch (Exception ex2) {
            String string;
            filePath = string = file.getCanonicalPath();
        }
        if (filePath.startsWith(scanDirectoryPath)) {
            return filePath.substring(StringGroovyMethods.size((String)scanDirectoryPath) + 1).replace(File.separator, DIRECTIVE_FILE_SEPARATOR);
        }
        String scanDir = null;
        Iterator<String> iterator = this.scanDirectories.iterator();
        while (iterator.hasNext()) {
            scanDir = ShortTypeHandling.castToString((Object)iterator.next());
            if (!filePath.startsWith(scanDir)) continue;
            return filePath.substring(StringGroovyMethods.size((String)scanDir) + 1).replace(File.separator, DIRECTIVE_FILE_SEPARATOR);
        }
        throw (Throwable)new RuntimeException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{filePath, scanDirectoryPath}, new String[]{"File was not sourced from the same ScanDirectory ", " scanDir: ", ""})));
    }

    @Override
    public Collection<AssetFile> scanForFiles(List<String> excludePatterns, List<String> includePatterns) {
        List fileList = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        ArrayList<String> excludedPatternRegex = DefaultTypeTransformation.booleanUnbox(excludePatterns) ? excludePatterns : new ArrayList<String>();
        ArrayList<String> includedPatternRegex = DefaultTypeTransformation.booleanUnbox(includePatterns) ? includePatterns : new ArrayList<String>();
        String scanDirectory = null;
        Iterator<String> iterator = this.scanDirectories.iterator();
        while (iterator.hasNext()) {
            scanDirectory = ShortTypeHandling.castToString((Object)iterator.next());
            File scanPath = new File(scanDirectory);
            this.iterateOverFileSystem(scanPath, excludedPatternRegex, includedPatternRegex, fileList, scanDirectory);
        }
        FileSystemAssetResolver resolver = null;
        Iterator<FileSystemAssetResolver> iterator2 = this.resolvers.iterator();
        while (iterator2.hasNext()) {
            List list;
            resolver = (FileSystemAssetResolver)ScriptBytecodeAdapter.castToType((Object)iterator2.next(), FileSystemAssetResolver.class);
            fileList = list = DefaultGroovyMethods.plus((List)fileList, resolver.scanForFiles(excludePatterns, includePatterns));
        }
        public class _scanForFiles_closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _scanForFiles_closure4(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(AssetFile a, AssetFile b) {
                return a.getPath() == b.getPath() ? 0 : (a.getPath() == null ? -1 : (b.getPath() == null ? 1 : a.getPath().compareTo(b.getPath())));
            }

            public Object call(AssetFile a, AssetFile b) {
                return this.doCall(a, b);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _scanForFiles_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.unique((List)fileList, (Closure)new _scanForFiles_closure4(this, this));
        return fileList;
    }

    /*
     * WARNING - void declaration
     */
    protected Object iterateOverFileSystem(File dir, List<String> excludePatterns, List<String> includePatterns, List<AssetFile> fileList, String sourcePath) {
        void var3_3;
        Reference excludePatterns2 = new Reference(excludePatterns);
        Reference includePatterns2 = new Reference((Object)var3_3);
        Reference fileList2 = new Reference(fileList);
        Reference sourcePath2 = new Reference((Object)sourcePath);
        File[] fileArray = dir.listFiles();
        public class _iterateOverFileSystem_closure5
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference sourcePath;
            private /* synthetic */ Reference excludePatterns;
            private /* synthetic */ Reference includePatterns;
            private /* synthetic */ Reference fileList;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _iterateOverFileSystem_closure5(Object _outerInstance, Object _thisObject, Reference sourcePath, Reference excludePatterns, Reference includePatterns, Reference fileList) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                this.sourcePath = reference4 = sourcePath;
                this.excludePatterns = reference3 = excludePatterns;
                this.includePatterns = reference2 = includePatterns;
                this.fileList = reference = fileList;
            }

            public Object doCall(File file) {
                Reference file2 = new Reference((Object)file);
                String relativePath = ShortTypeHandling.castToString((Object)InvokerHelper.invokeMethodSafe((Object)((FileSystemAssetResolver)this.getThisObject()), (String)"relativePathToResolver", (Object)new Object[]{(File)file2.get(), this.sourcePath.get()}));
                if (((File)file2.get()).isDirectory()) {
                    return InvokerHelper.invokeMethodSafe((Object)((FileSystemAssetResolver)this.getThisObject()), (String)"iterateOverFileSystem", (Object)new Object[]{(File)file2.get(), this.excludePatterns.get(), this.includePatterns.get(), this.fileList.get(), this.sourcePath.get()});
                }
                if (!DefaultTypeTransformation.booleanUnbox((Object)InvokerHelper.invokeMethodSafe((Object)((FileSystemAssetResolver)this.getThisObject()), (String)"isFileMatchingPatterns", (Object)new Object[]{relativePath, this.excludePatterns.get()})) || DefaultTypeTransformation.booleanUnbox((Object)InvokerHelper.invokeMethodSafe((Object)((FileSystemAssetResolver)this.getThisObject()), (String)"isFileMatchingPatterns", (Object)new Object[]{relativePath, this.includePatterns.get()}))) {
                    if (!((File)file2.get()).isDirectory()) {
                        Class<AssetFile> assetFileClass = AssetHelper.assetForFileName(relativePath);
                        if (assetFileClass != null) {
                            public class _closure6
                            extends Closure
                            implements GeneratedClosure {
                                private /* synthetic */ Reference file;
                                private static /* synthetic */ ClassInfo $staticClassInfo;
                                public static transient /* synthetic */ boolean __$stMC;

                                public _closure6(Object _outerInstance, Object _thisObject, Reference file) {
                                    super(_outerInstance, _thisObject);
                                    Reference reference;
                                    this.file = reference = file;
                                }

                                public Object doCall(Object it) {
                                    return new BufferedInputStream(ResourceGroovyMethods.newInputStream((File)((File)ScriptBytecodeAdapter.castToType((Object)this.file.get(), File.class))), 512);
                                }

                                public File getFile() {
                                    return (File)ScriptBytecodeAdapter.castToType((Object)this.file.get(), File.class);
                                }

                                public Object call(Object args) {
                                    return this.doCall(args);
                                }

                                public Object call() {
                                    return this.doCall(null);
                                }

                                public Object doCall() {
                                    return this.doCall(null);
                                }

                                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                    if (((Object)((Object)this)).getClass() != _closure6.class) {
                                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                    }
                                    ClassInfo classInfo = $staticClassInfo;
                                    if (classInfo == null) {
                                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                    }
                                    return classInfo.getMetaClass();
                                }
                            }
                            return ((List)this.fileList.get()).add((AssetFile)DefaultGroovyMethods.newInstance(assetFileClass, (Object[])new Object[]{ScriptBytecodeAdapter.createMap((Object[])new Object[]{"inputStreamSource", new _closure6((Object)this, this.getThisObject(), file2), "baseFile", null, "path", relativePath, "sourceResolver", (FileSystemAssetResolver)this.getThisObject()})}));
                        }
                        List list = (List)this.fileList.get();
                        GenericAssetFile genericAssetFile = new GenericAssetFile();
                        public class _closure7
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference file;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure7(Object _outerInstance, Object _thisObject, Reference file) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                this.file = reference = file;
                            }

                            public Object doCall(Object it) {
                                return new BufferedInputStream(ResourceGroovyMethods.newInputStream((File)((File)ScriptBytecodeAdapter.castToType((Object)this.file.get(), File.class))), 512);
                            }

                            public File getFile() {
                                return (File)ScriptBytecodeAdapter.castToType((Object)this.file.get(), File.class);
                            }

                            public Object call(Object args) {
                                return this.doCall(args);
                            }

                            public Object call() {
                                return this.doCall(null);
                            }

                            public Object doCall() {
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure7.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }
                        }
                        _closure7 _closure72 = new _closure7((Object)this, this.getThisObject(), file2);
                        genericAssetFile.setInputStreamSource(_closure72);
                        String string = relativePath;
                        genericAssetFile.setPath(string);
                        return list.add(genericAssetFile);
                    }
                    return null;
                }
                return null;
            }

            public Object call(File file) {
                Reference file2 = new Reference((Object)file);
                return this.doCall((File)file2.get());
            }

            public String getSourcePath() {
                return ShortTypeHandling.castToString((Object)this.sourcePath.get());
            }

            public List getExcludePatterns() {
                return (List)ScriptBytecodeAdapter.castToType((Object)this.excludePatterns.get(), List.class);
            }

            public List getIncludePatterns() {
                return (List)ScriptBytecodeAdapter.castToType((Object)this.includePatterns.get(), List.class);
            }

            public List getFileList() {
                return (List)ScriptBytecodeAdapter.castToType((Object)this.fileList.get(), List.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _iterateOverFileSystem_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return fileArray != null ? DefaultGroovyMethods.each((Object)fileArray, (Closure)new _iterateOverFileSystem_closure5(this, this, sourcePath2, excludePatterns2, includePatterns2, fileList2)) : null;
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != FileSystemAssetResolver.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public AssetFile getAsset(String relativePath, String contentType, String extension) {
        Reference extension2 = new Reference((Object)extension);
        CallSite[] callSiteArray = FileSystemAssetResolver.$getCallSiteArray();
        return this.getAsset(relativePath, contentType, (String)extension2.get(), null);
    }

    @Override
    public AssetFile getAsset(String relativePath, String contentType) {
        CallSite[] callSiteArray = FileSystemAssetResolver.$getCallSiteArray();
        return this.getAsset(relativePath, contentType, null, null);
    }

    @Override
    public AssetFile getAsset(String relativePath) {
        CallSite[] callSiteArray = FileSystemAssetResolver.$getCallSiteArray();
        return this.getAsset(relativePath, null, null, null);
    }

    public List<AssetFile> getAssets(String basePath, String contentType, String extension, Boolean recursive, AssetFile relativeFile) {
        CallSite[] callSiteArray = FileSystemAssetResolver.$getCallSiteArray();
        return this.getAssets(basePath, contentType, extension, recursive, relativeFile, null);
    }

    public List<AssetFile> getAssets(String basePath, String contentType, String extension, Boolean recursive) {
        CallSite[] callSiteArray = FileSystemAssetResolver.$getCallSiteArray();
        return this.getAssets(basePath, contentType, extension, recursive, null, null);
    }

    @Override
    public List<AssetFile> getAssets(String basePath, String contentType, String extension) {
        CallSite[] callSiteArray = FileSystemAssetResolver.$getCallSiteArray();
        return this.getAssets(basePath, contentType, extension, true, null, null);
    }

    @Override
    public List<AssetFile> getAssets(String basePath, String contentType) {
        CallSite[] callSiteArray = FileSystemAssetResolver.$getCallSiteArray();
        return this.getAssets(basePath, contentType, null, true, null, null);
    }

    @Override
    public List<AssetFile> getAssets(String basePath) {
        CallSite[] callSiteArray = FileSystemAssetResolver.$getCallSiteArray();
        return this.getAssets(basePath, null, null, true, null, null);
    }

    protected void recursiveTreeAppend(File directory, List<AssetFile> tree, String contentType, AssetFile baseFile, String sourceDirectory) {
        CallSite[] callSiteArray = FileSystemAssetResolver.$getCallSiteArray();
        this.recursiveTreeAppend(directory, tree, contentType, baseFile, true, sourceDirectory);
    }

    protected void recursiveTreeAppend(File directory, List<AssetFile> tree, AssetFile baseFile, String sourceDirectory) {
        CallSite[] callSiteArray = FileSystemAssetResolver.$getCallSiteArray();
        this.recursiveTreeAppend(directory, tree, null, baseFile, true, sourceDirectory);
    }

    static {
        String string;
        DIRECTIVE_FILE_SEPARATOR = string = "/";
        Object object = FileSystemAssetResolver.$getCallSiteArray()[37].call(Pattern.class, FileSystemAssetResolver.$getCallSiteArray()[38].callGetProperty(File.class));
        QUOTED_FILE_SEPARATOR = ShortTypeHandling.castToString((Object)object);
        Object object2 = FileSystemAssetResolver.$getCallSiteArray()[39].call(LoggerFactory.class, (Object)"asset.pipeline.fs.FileSystemAssetResolver");
        log = (Logger)ScriptBytecodeAdapter.castToType((Object)object2, Logger.class);
    }

    public static String getQUOTED_FILE_SEPARATOR() {
        return QUOTED_FILE_SEPARATOR;
    }

    public static void setQUOTED_FILE_SEPARATOR(String string) {
        QUOTED_FILE_SEPARATOR = string;
    }

    public static String getDIRECTIVE_FILE_SEPARATOR() {
        return DIRECTIVE_FILE_SEPARATOR;
    }

    public static void setDIRECTIVE_FILE_SEPARATOR(String string) {
        DIRECTIVE_FILE_SEPARATOR = string;
    }

    public File getBaseDirectory() {
        return this.baseDirectory;
    }

    public void setBaseDirectory(File file) {
        this.baseDirectory = file;
    }

    public List<String> getScanDirectories() {
        return this.scanDirectories;
    }

    public void setScanDirectories(List<String> list) {
        this.scanDirectories = list;
    }

    public List<FileSystemAssetResolver> getResolvers() {
        return this.resolvers;
    }

    public void setResolvers(List<FileSystemAssetResolver> list) {
        this.resolvers = list;
    }

    public /* synthetic */ MetaClass super$2$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "<$constructor$>";
        stringArray[1] = "exists";
        stringArray[2] = "listFiles";
        stringArray[3] = "iterator";
        stringArray[4] = "isDirectory";
        stringArray[5] = "startsWith";
        stringArray[6] = "getName";
        stringArray[7] = "getName";
        stringArray[8] = "getName";
        stringArray[9] = "leftShift";
        stringArray[10] = "<$constructor$>";
        stringArray[11] = "canonicalPath";
        stringArray[12] = "iterator";
        stringArray[13] = "isDirectory";
        stringArray[14] = "startsWith";
        stringArray[15] = "getName";
        stringArray[16] = "getName";
        stringArray[17] = "getName";
        stringArray[18] = "leftShift";
        stringArray[19] = "<$constructor$>";
        stringArray[20] = "canonicalPath";
        stringArray[21] = "leftShift";
        stringArray[22] = "canonicalPath";
        stringArray[23] = "isDebugEnabled";
        stringArray[24] = "debug";
        stringArray[25] = "replaceAll";
        stringArray[26] = "getPossibleFileSpecs";
        stringArray[27] = "extensionFromURI";
        stringArray[28] = "findAll";
        stringArray[29] = "assetFileClasses";
        stringArray[30] = "iterator";
        stringArray[31] = "resolveAsset";
        stringArray[32] = "iterator";
        stringArray[33] = "getAsset";
        stringArray[34] = "<$constructor$>";
        stringArray[35] = "exists";
        stringArray[36] = "isDirectory";
        stringArray[37] = "quote";
        stringArray[38] = "separator";
        stringArray[39] = "getLogger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[40];
        FileSystemAssetResolver.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(FileSystemAssetResolver.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = FileSystemAssetResolver.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

