/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.preprocessor.sax;

import fr.opensagres.xdocreport.core.XDocReportException;
import fr.opensagres.xdocreport.core.io.IOUtils;
import fr.opensagres.xdocreport.core.io.XDocArchive;
import fr.opensagres.xdocreport.document.preprocessor.AbstractXDocPreprocessor;
import fr.opensagres.xdocreport.document.preprocessor.sax.BufferedDocumentContentHandler;
import fr.opensagres.xdocreport.document.preprocessor.sax.BufferedElement;
import fr.opensagres.xdocreport.template.formatter.FieldsMetadata;
import fr.opensagres.xdocreport.template.formatter.IDocumentFormatter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Map;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public abstract class SAXXDocPreprocessor
extends AbstractXDocPreprocessor<InputStream> {
    @Override
    public boolean preprocess(String entryName, InputStream reader, Writer writer, FieldsMetadata fieldsMetadata, IDocumentFormatter formatter, Map<String, Object> sharedContext) throws XDocReportException, IOException {
        try {
            XMLReader xmlReader = XMLReaderFactory.createXMLReader();
            xmlReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            xmlReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            xmlReader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            BufferedDocumentContentHandler<?> contentHandler = this.createBufferedDocumentContentHandler(entryName, fieldsMetadata, formatter, sharedContext);
            xmlReader.setContentHandler(contentHandler);
            xmlReader.parse(new InputSource(reader));
            Object document = contentHandler.getBufferedDocument();
            if (document != null) {
                ((BufferedElement)document).save(writer);
                return true;
            }
            return false;
        }
        catch (SAXException e) {
            throw new XDocReportException((Throwable)e);
        }
    }

    @Override
    protected InputStream getSource(XDocArchive documentArchive, String entryName) {
        return documentArchive.getEntryInputStream(entryName);
    }

    @Override
    protected void closeSource(InputStream reader) {
        if (reader != null) {
            IOUtils.closeQuietly((InputStream)reader);
        }
    }

    protected abstract BufferedDocumentContentHandler<?> createBufferedDocumentContentHandler(String var1, FieldsMetadata var2, IDocumentFormatter var3, Map<String, Object> var4);
}

