/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.dateandtime.shared.spi;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.type.Type;
import org.hibernate.usertype.CompositeUserType;
import org.jadira.usertype.dateandtime.shared.reflectionutils.ArrayUtils;
import org.jadira.usertype.dateandtime.shared.reflectionutils.TypeHelper;
import org.jadira.usertype.dateandtime.shared.spi.AbstractUserType;
import org.jadira.usertype.dateandtime.shared.spi.ColumnMapper;

public abstract class AbstractMultiColumnUserType<T>
extends AbstractUserType
implements CompositeUserType,
Serializable {
    private static final long serialVersionUID = -8258683760413283329L;
    private final int[] sqlTypes = new int[this.getColumnMappers().length];
    private final Type[] hibernateTypes;

    public AbstractMultiColumnUserType() {
        int i;
        for (i = 0; i < this.sqlTypes.length; ++i) {
            this.sqlTypes[i] = this.getColumnMappers()[i].getSqlType();
        }
        this.hibernateTypes = new Type[this.getColumnMappers().length];
        for (i = 0; i < this.hibernateTypes.length; ++i) {
            this.hibernateTypes[i] = this.getColumnMappers()[i].getHibernateType();
        }
    }

    public int[] sqlTypes() {
        return ArrayUtils.copyOf(this.sqlTypes);
    }

    public Class<T> returnedClass() {
        return TypeHelper.getTypeArguments(AbstractMultiColumnUserType.class, this.getClass()).get(0);
    }

    protected abstract ColumnMapper<?, ?>[] getColumnMappers();

    public T nullSafeGet(ResultSet resultSet, String[] strings, SessionImplementor session, Object object) throws SQLException {
        Object[] convertedColumns = new Object[this.getColumnMappers().length];
        for (int getIndex = 0; getIndex < this.getColumnMappers().length; ++getIndex) {
            ColumnMapper<?, ?> nextMapper = this.getColumnMappers()[getIndex];
            Object converted = nextMapper.getHibernateType().nullSafeGet(resultSet, strings[getIndex], session, object);
            if (converted == null) continue;
            convertedColumns[getIndex] = nextMapper.fromNonNullValue(converted);
        }
        for (int i = 0; i < convertedColumns.length; ++i) {
            if (convertedColumns[i] == null) continue;
            return this.fromConvertedColumns(convertedColumns);
        }
        return null;
    }

    protected abstract T fromConvertedColumns(Object[] var1);

    protected abstract Object[] toConvertedColumns(T var1);

    public void nullSafeSet(PreparedStatement preparedStatement, Object value, int index, SessionImplementor session) throws SQLException {
        Object[] valuesToSet = new Object[this.getColumnMappers().length];
        if (value != null) {
            Object myValue = value;
            Object[] convertedColumns = this.toConvertedColumns(myValue);
            for (int cIdx = 0; cIdx < valuesToSet.length; ++cIdx) {
                ColumnMapper<?, ?> nextMapper = this.getColumnMappers()[cIdx];
                valuesToSet[cIdx] = nextMapper.toNonNullValue(convertedColumns[cIdx]);
            }
        }
        for (int setIndex = 0; setIndex < valuesToSet.length; ++setIndex) {
            ColumnMapper<?, ?> nextMapper = this.getColumnMappers()[setIndex];
            nextMapper.getHibernateType().nullSafeSet(preparedStatement, valuesToSet[setIndex], index + setIndex, session);
        }
    }

    public abstract String[] getPropertyNames();

    public Type[] getPropertyTypes() {
        return ArrayUtils.copyOf(this.hibernateTypes);
    }

    public Object getPropertyValue(Object component, int property) throws HibernateException {
        if (!this.returnedClass().isAssignableFrom(component.getClass())) {
            throw new HibernateException("getPropertyValue called with incorrect class: {" + component.getClass() + "}");
        }
        Object[] cols = this.toConvertedColumns(component);
        return cols[property];
    }

    public void setPropertyValue(Object component, int property, Object value) throws HibernateException {
        throw new HibernateException("Called setPropertyValue on an immutable type {" + component.getClass() + "}");
    }

    public Serializable disassemble(Object value, SessionImplementor session) throws HibernateException {
        return super.disassemble(value);
    }

    public Object assemble(Serializable cached, SessionImplementor session, Object owner) throws HibernateException {
        return super.assemble(cached, owner);
    }

    public Object replace(Object original, Object target, SessionImplementor session, Object owner) throws HibernateException {
        return super.replace(original, target, owner);
    }
}

