/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.fonts.fop.fonts;

import java.net.URI;
import java.util.List;
import org.docx4j.fonts.fop.apps.FOPException;
import org.docx4j.fonts.fop.apps.io.InternalResourceResolver;
import org.docx4j.fonts.fop.fonts.EmbedFontInfo;
import org.docx4j.fonts.fop.fonts.FontAdder;
import org.docx4j.fonts.fop.fonts.FontCache;
import org.docx4j.fonts.fop.fonts.FontCacheManager;
import org.docx4j.fonts.fop.fonts.FontCacheManagerFactory;
import org.docx4j.fonts.fop.fonts.FontCollection;
import org.docx4j.fonts.fop.fonts.FontDetector;
import org.docx4j.fonts.fop.fonts.FontEventListener;
import org.docx4j.fonts.fop.fonts.FontInfo;
import org.docx4j.fonts.fop.fonts.FontTriplet;
import org.docx4j.fonts.fop.fonts.substitute.FontSubstitutions;

public class FontManager {
    private InternalResourceResolver resourceResolver;
    private final FontDetector fontDetector;
    private FontCacheManager fontCacheManager;
    private FontSubstitutions fontSubstitutions;
    private boolean enableBase14Kerning;
    private FontTriplet.Matcher referencedFontsMatcher;

    public FontManager(InternalResourceResolver resourceResolver, FontDetector fontDetector, FontCacheManager fontCacheManager) {
        this.resourceResolver = resourceResolver;
        this.fontDetector = fontDetector;
        this.fontCacheManager = fontCacheManager;
    }

    public void setResourceResolver(InternalResourceResolver resourceResolver) {
        this.resourceResolver = resourceResolver;
    }

    public InternalResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    public boolean isBase14KerningEnabled() {
        return this.enableBase14Kerning;
    }

    public void setBase14KerningEnabled(boolean value) {
        this.enableBase14Kerning = value;
    }

    public void setFontSubstitutions(FontSubstitutions substitutions) {
        this.fontSubstitutions = substitutions;
    }

    protected FontSubstitutions getFontSubstitutions() {
        if (this.fontSubstitutions == null) {
            this.fontSubstitutions = new FontSubstitutions();
        }
        return this.fontSubstitutions;
    }

    public void setCacheFile(URI cacheFileURI) {
        this.fontCacheManager.setCacheFile(this.resourceResolver.resolveFromBase(cacheFileURI));
    }

    public void disableFontCache() {
        this.fontCacheManager = FontCacheManagerFactory.createDisabled();
    }

    public FontCache getFontCache() {
        return this.fontCacheManager.load();
    }

    public void saveCache() throws FOPException {
        this.fontCacheManager.save();
    }

    public void deleteCache() throws FOPException {
        this.fontCacheManager.delete();
    }

    public void setup(FontInfo fontInfo, FontCollection[] fontCollections) {
        int startNum = 1;
        for (FontCollection fontCollection : fontCollections) {
            startNum = fontCollection.setup(startNum, fontInfo);
        }
        this.getFontSubstitutions().adjustFontInfo(fontInfo);
    }

    public void setReferencedFontsMatcher(FontTriplet.Matcher matcher) {
        this.referencedFontsMatcher = matcher;
    }

    public FontTriplet.Matcher getReferencedFontsMatcher() {
        return this.referencedFontsMatcher;
    }

    public void updateReferencedFonts(List<EmbedFontInfo> fontInfoList) {
        FontTriplet.Matcher matcher = this.getReferencedFontsMatcher();
        this.updateReferencedFonts(fontInfoList, matcher);
    }

    public void updateReferencedFonts(List<EmbedFontInfo> fontInfoList, FontTriplet.Matcher matcher) {
        if (matcher == null) {
            return;
        }
        block0: for (EmbedFontInfo fontInfo : fontInfoList) {
            for (FontTriplet triplet : fontInfo.getFontTriplets()) {
                if (!matcher.matches(triplet)) continue;
                fontInfo.setEmbedded(false);
                continue block0;
            }
        }
    }

    public void autoDetectFonts(boolean autoDetectFonts, FontAdder fontAdder, boolean strict, FontEventListener listener, List<EmbedFontInfo> fontInfoList) throws FOPException {
        if (autoDetectFonts) {
            this.fontDetector.detect(this, fontAdder, strict, listener, fontInfoList);
        }
    }
}

