/*
 * Decompiled with CFR 0.152.
 */
package asset.pipeline.fs;

import asset.pipeline.AssetFile;
import asset.pipeline.AssetHelper;
import asset.pipeline.GenericAssetFile;
import asset.pipeline.fs.AbstractAssetResolver;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.IntRange;
import groovy.lang.MetaClass;
import groovy.lang.Range;
import groovy.lang.Reference;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathAssetResolver
extends AbstractAssetResolver<URL> {
    private static String NATIVE_FILE_SEPARATOR;
    private static String DIRECTIVE_FILE_SEPARATOR;
    private ClassLoader classLoader;
    private String prefixPath;
    private String assetListPath;
    private Collection<String> assetList;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public ClasspathAssetResolver(String name, String basePath, String assetListPath, ClassLoader classLoader) {
        MetaClass metaClass;
        List list;
        CallSite[] callSiteArray = ClasspathAssetResolver.$getCallSiteArray();
        super(name);
        this.assetList = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        ClassLoader classLoader2 = classLoader;
        this.classLoader = (ClassLoader)ScriptBytecodeAdapter.castToType((Object)classLoader2, ClassLoader.class);
        String string = basePath;
        this.prefixPath = ShortTypeHandling.castToString((Object)string);
        String string2 = assetListPath;
        this.assetListPath = ShortTypeHandling.castToString((Object)string2);
        if (BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[0].callCurrent((GroovyObject)this);
        } else {
            this.loadAssetList();
        }
    }

    public ClasspathAssetResolver(String name, String basePath, String assetListPath) {
        CallSite[] callSiteArray = ClasspathAssetResolver.$getCallSiteArray();
        this(name, basePath, assetListPath, (ClassLoader)ScriptBytecodeAdapter.castToType((Object)callSiteArray[1].callGetProperty(callSiteArray[2].call(Thread.class)), ClassLoader.class));
    }

    public ClasspathAssetResolver(String name, String basePath) {
        CallSite[] callSiteArray = ClasspathAssetResolver.$getCallSiteArray();
        this(name, basePath, null, (ClassLoader)ScriptBytecodeAdapter.castToType((Object)callSiteArray[3].callGetProperty(callSiteArray[4].call(Thread.class)), ClassLoader.class));
    }

    private Object loadAssetList() {
        CallSite[] callSiteArray = ClasspathAssetResolver.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)this.assetListPath)) {
            return null;
        }
        Object resources = callSiteArray[5].call((Object)this.classLoader, (Object)this.assetListPath);
        public class _loadAssetList_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _loadAssetList_closure1(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _loadAssetList_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(URL res) {
                Object object;
                CallSite[] callSiteArray = _loadAssetList_closure1.$getCallSiteArray();
                Object object2 = callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), DefaultTypeTransformation.booleanUnbox((Object)(object = callSiteArray[2].callSafe(callSiteArray[3].callGetPropertySafe((Object)res), (Object)"\n"))) ? object : ScriptBytecodeAdapter.createList((Object[])new Object[0]));
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object2, _loadAssetList_closure1.class, (GroovyObject)this, (String)"assetList");
                return object2;
            }

            public Object call(URL res) {
                CallSite[] callSiteArray = _loadAssetList_closure1.$getCallSiteArray();
                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return callSiteArray[4].callCurrent((GroovyObject)this, (Object)res);
                }
                return this.doCall(res);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _loadAssetList_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "plus";
                stringArray[1] = "assetList";
                stringArray[2] = "tokenize";
                stringArray[3] = "text";
                stringArray[4] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[5];
                _loadAssetList_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_loadAssetList_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _loadAssetList_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return callSiteArray[6].call(resources, (Object)new _loadAssetList_closure1(this, this));
    }

    @Override
    public AssetFile getAsset(String relativePath, String contentType, String extension, AssetFile baseFile) {
        Reference extension2 = new Reference((Object)extension);
        CallSite[] callSiteArray = ClasspathAssetResolver.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)relativePath)) {
            return (AssetFile)ScriptBytecodeAdapter.castToType(null, AssetFile.class);
        }
        Object normalizedPath = callSiteArray[7].call(AssetHelper.class, callSiteArray[8].call((Object)relativePath, (Object)NATIVE_FILE_SEPARATOR, (Object)DIRECTIVE_FILE_SEPARATOR));
        if (!DefaultTypeTransformation.booleanUnbox((Object)normalizedPath)) {
            return (AssetFile)ScriptBytecodeAdapter.castToType(null, AssetFile.class);
        }
        Object specs = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)contentType)) {
            Object object;
            specs = object = callSiteArray[9].call(AssetHelper.class, (Object)contentType);
        } else {
            Object object;
            if (!DefaultTypeTransformation.booleanUnbox((Object)((String)extension2.get()))) {
                Object object2 = callSiteArray[10].call(AssetHelper.class, (Object)relativePath);
                extension2.set((Object)ShortTypeHandling.castToString((Object)object2));
            }
            public class _getAsset_closure2
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference extension;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _getAsset_closure2(Object _outerInstance, Object _thisObject, Reference extension) {
                    Reference reference;
                    CallSite[] callSiteArray = _getAsset_closure2.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.extension = reference = extension;
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _getAsset_closure2.$getCallSiteArray();
                    return callSiteArray[0].call(callSiteArray[1].callGetProperty(it), this.extension.get());
                }

                public String getExtension() {
                    CallSite[] callSiteArray = _getAsset_closure2.$getCallSiteArray();
                    return ShortTypeHandling.castToString((Object)this.extension.get());
                }

                public Object doCall() {
                    CallSite[] callSiteArray = _getAsset_closure2.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getAsset_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "contains";
                    stringArray[1] = "extensions";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[2];
                    _getAsset_closure2.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_getAsset_closure2.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _getAsset_closure2.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            specs = object = callSiteArray[11].call(callSiteArray[12].call(AssetHelper.class), (Object)new _getAsset_closure2(this, this, extension2));
        }
        AssetFile assetFile = (AssetFile)ScriptBytecodeAdapter.castToType((Object)callSiteArray[13].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)specs, (Object)this.prefixPath, (Object)normalizedPath, (Object)baseFile, (Object)((String)extension2.get()))), AssetFile.class);
        return assetFile;
    }

    @Override
    protected Closure<InputStream> createInputStreamClosure(URL file) {
        Reference file2 = new Reference((Object)file);
        CallSite[] callSiteArray = ClasspathAssetResolver.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)((URL)file2.get()))) {
            public class _createInputStreamClosure_closure3
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference file;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _createInputStreamClosure_closure3(Object _outerInstance, Object _thisObject, Reference file) {
                    Reference reference;
                    CallSite[] callSiteArray = _createInputStreamClosure_closure3.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.file = reference = file;
                }

                public Object doCall() {
                    CallSite[] callSiteArray = _createInputStreamClosure_closure3.$getCallSiteArray();
                    return callSiteArray[0].callConstructor(BufferedInputStream.class, callSiteArray[1].call(this.file.get()), (Object)512);
                }

                public URL getFile() {
                    CallSite[] callSiteArray = _createInputStreamClosure_closure3.$getCallSiteArray();
                    return (URL)ScriptBytecodeAdapter.castToType((Object)this.file.get(), URL.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _createInputStreamClosure_closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "<$constructor$>";
                    stringArray[1] = "openStream";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[2];
                    _createInputStreamClosure_closure3.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_createInputStreamClosure_closure3.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _createInputStreamClosure_closure3.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            return new _createInputStreamClosure_closure3(this, this, file2);
        }
        return (Closure)ScriptBytecodeAdapter.castToType(null, Closure.class);
    }

    @Override
    public String relativePathToResolver(URL file, String scanDirectoryPath) {
        CallSite[] callSiteArray = ClasspathAssetResolver.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)file)) {
            return ShortTypeHandling.castToString(null);
        }
        Object filePath = callSiteArray[14].callGetProperty((Object)file);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[15].call(filePath, (Object)scanDirectoryPath))) {
            Object i = callSiteArray[16].call(filePath, (Object)scanDirectoryPath);
            return ShortTypeHandling.castToString((Object)callSiteArray[17].call(filePath, callSiteArray[18].call(callSiteArray[19].call(i, callSiteArray[20].call((Object)scanDirectoryPath)), (Object)1)));
        }
        throw (Throwable)callSiteArray[21].callConstructor(RuntimeException.class, (Object)new GStringImpl(new Object[]{filePath}, new String[]{"File was not sourced from the same ScanDirectory ", ""}));
    }

    @Override
    public URL getRelativeFile(String relativePath, String name) {
        if (name.startsWith("/")) {
            String string;
            name = string = name.substring(1);
        }
        URL file = this.classLoader.getResource(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{relativePath, name}, new String[]{"", "/", ""})));
        URL uRL = file;
        String string = uRL != null ? uRL.getProtocol() : null;
        Boolean bl = string != null ? Boolean.valueOf(string.equals("file")) : null;
        if (bl == null ? false : bl) {
            if (new File(file.getPath()).isDirectory()) {
                return (URL)ScriptBytecodeAdapter.castToType(null, URL.class);
            }
        } else {
            URL uRL2 = file;
            String string2 = uRL2 != null ? uRL2.getPath() : null;
            Boolean bl2 = string2 != null ? Boolean.valueOf(string2.endsWith("/")) : null;
            if (bl2 == null ? false : bl2) {
                return (URL)ScriptBytecodeAdapter.castToType(null, URL.class);
            }
        }
        return file;
    }

    @Override
    protected String getFileName(URL url) {
        String path = url.getPath();
        String name = path;
        if (path.lastIndexOf("/") != 0) {
            String string;
            name = string = path.substring(path.lastIndexOf("/"));
        }
        return name;
    }

    @Override
    public List<AssetFile> getAssets(String basePath, String contentType, String extension, Boolean recursive, AssetFile relativeFile, AssetFile baseFile) {
        Collection<Class<AssetFile>> specs = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)contentType)) {
            Collection<Class<AssetFile>> collection;
            specs = collection = AssetHelper.getPossibleFileSpecs(contentType);
        }
        if (!DefaultTypeTransformation.booleanUnbox(this.assetList)) {
            return ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        }
        List extensions = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        if (DefaultTypeTransformation.booleanUnbox((Object)extension)) {
            DefaultGroovyMethods.leftShift((List)extensions, (Object)extension);
        } else if (DefaultTypeTransformation.booleanUnbox(specs)) {
            Class spec = null;
            Iterator<Class<AssetFile>> iterator = specs.iterator();
            while (iterator.hasNext()) {
                spec = ShortTypeHandling.castToClass(iterator.next());
                if (!DefaultTypeTransformation.booleanUnbox(AssetFile.extensions)) continue;
                extensions.addAll(AssetFile.extensions);
            }
        }
        String translatedBasePath = basePath;
        if (!basePath.startsWith("/") && relativeFile != null) {
            String string;
            String string2;
            ArrayList pathArgs = DefaultTypeTransformation.booleanUnbox((Object)relativeFile.getParentPath()) ? DefaultGroovyMethods.toList((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)relativeFile.getParentPath().split(DIRECTIVE_FILE_SEPARATOR), Object[].class))) : new ArrayList();
            String[] basePathArgs = basePath.split(DIRECTIVE_FILE_SEPARATOR);
            List parentPathArgs = DefaultTypeTransformation.booleanUnbox(pathArgs) ? DefaultGroovyMethods.getAt(pathArgs, (Range)new IntRange(true, 0, pathArgs.size() - 1)) : ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            parentPathArgs.addAll(DefaultGroovyMethods.toList((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)basePathArgs, Object[].class))));
            translatedBasePath = string2 = DefaultGroovyMethods.join((Iterable)parentPathArgs, (String)DIRECTIVE_FILE_SEPARATOR);
            translatedBasePath = string = AssetHelper.normalizePath(translatedBasePath);
            String string3 = DefaultTypeTransformation.booleanUnbox((Object)translatedBasePath) ? StringGroovyMethods.plus((String)translatedBasePath, (CharSequence)"/") : null;
            translatedBasePath = ShortTypeHandling.castToString((Object)string3);
        }
        List tree = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        String filePath = null;
        Iterator<String> iterator = this.assetList.iterator();
        while (iterator.hasNext()) {
            filePath = ShortTypeHandling.castToString((Object)iterator.next());
            if (!(!DefaultTypeTransformation.booleanUnbox((Object)translatedBasePath) || filePath.startsWith(translatedBasePath))) continue;
            String[] mimeType = (String[])ScriptBytecodeAdapter.castToType(AssetHelper.assetMimeTypeForURI(filePath), String[].class);
            URL url = this.classLoader.getResource(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.prefixPath, filePath}, new String[]{"", "/", ""})));
            if (!(DefaultTypeTransformation.booleanUnbox((Object)url) && DefaultTypeTransformation.booleanUnbox((Object)mimeType) && DefaultTypeTransformation.booleanUnbox((Object)(mimeType == null ? Boolean.valueOf(contentType == null) : Boolean.valueOf(DefaultGroovyMethods.isCase((Object)mimeType, (Object)contentType)))))) continue;
            DefaultGroovyMethods.leftShift((List)tree, (Object)this.assetForFile(url, contentType, baseFile, this.prefixPath));
        }
        return tree;
    }

    @Override
    public Collection<AssetFile> scanForFiles(List<String> excludePatterns, List<String> includePatterns) {
        CallSite[] callSiteArray = ClasspathAssetResolver.$getCallSiteArray();
        List fileList = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        List excludedPatternList = DefaultTypeTransformation.booleanUnbox(excludePatterns) ? excludePatterns : (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[22].callConstructor(ArrayList.class), List.class);
        List includedPatternList = DefaultTypeTransformation.booleanUnbox(includePatterns) ? includePatterns : (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[23].callConstructor(ArrayList.class), List.class);
        String relativePath = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[24].call(this.assetList), Iterator.class);
        while (iterator.hasNext()) {
            relativePath = ShortTypeHandling.castToString(iterator.next());
            Object entry = callSiteArray[25].call((Object)this.classLoader, (Object)new GStringImpl(new Object[]{this.prefixPath, relativePath}, new String[]{"", "/", ""}));
            if (!(DefaultTypeTransformation.booleanUnbox((Object)entry) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[26].callCurrent((GroovyObject)this, (Object)relativePath, (Object)excludedPatternList)) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[27].callCurrent((GroovyObject)this, (Object)relativePath, (Object)includedPatternList)))) continue;
            Object assetFileClass = callSiteArray[28].call(AssetHelper.class, (Object)relativePath);
            if (DefaultTypeTransformation.booleanUnbox((Object)assetFileClass)) {
                callSiteArray[29].call((Object)fileList, callSiteArray[30].call(assetFileClass, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"inputStreamSource", callSiteArray[31].callCurrent((GroovyObject)this, entry), "path", relativePath, "sourceResolver", this})));
                continue;
            }
            callSiteArray[32].call((Object)fileList, callSiteArray[33].callConstructor(GenericAssetFile.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"inputStreamSource", callSiteArray[34].callCurrent((GroovyObject)this, entry), "path", relativePath})));
        }
        public class _scanForFiles_closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _scanForFiles_closure4(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _scanForFiles_closure4.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(AssetFile a, AssetFile b) {
                CallSite[] callSiteArray = _scanForFiles_closure4.$getCallSiteArray();
                return ScriptBytecodeAdapter.compareTo((Object)callSiteArray[0].callGetProperty((Object)a), (Object)callSiteArray[1].callGetProperty((Object)b));
            }

            public Object call(AssetFile a, AssetFile b) {
                CallSite[] callSiteArray = _scanForFiles_closure4.$getCallSiteArray();
                return callSiteArray[2].callCurrent((GroovyObject)this, (Object)a, (Object)b);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _scanForFiles_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "path";
                stringArray[1] = "path";
                stringArray[2] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _scanForFiles_closure4.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_scanForFiles_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _scanForFiles_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (Collection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[35].call((Object)fileList, (Object)new _scanForFiles_closure4(this, this)), Collection.class);
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ClasspathAssetResolver.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public AssetFile getAsset(String relativePath, String contentType, String extension) {
        Reference extension2 = new Reference((Object)extension);
        CallSite[] callSiteArray = ClasspathAssetResolver.$getCallSiteArray();
        return this.getAsset(relativePath, contentType, (String)extension2.get(), null);
    }

    @Override
    public AssetFile getAsset(String relativePath, String contentType) {
        CallSite[] callSiteArray = ClasspathAssetResolver.$getCallSiteArray();
        return this.getAsset(relativePath, contentType, null, null);
    }

    @Override
    public AssetFile getAsset(String relativePath) {
        CallSite[] callSiteArray = ClasspathAssetResolver.$getCallSiteArray();
        return this.getAsset(relativePath, null, null, null);
    }

    public List<AssetFile> getAssets(String basePath, String contentType, String extension, Boolean recursive, AssetFile relativeFile) {
        CallSite[] callSiteArray = ClasspathAssetResolver.$getCallSiteArray();
        return this.getAssets(basePath, contentType, extension, recursive, relativeFile, null);
    }

    public List<AssetFile> getAssets(String basePath, String contentType, String extension, Boolean recursive) {
        CallSite[] callSiteArray = ClasspathAssetResolver.$getCallSiteArray();
        return this.getAssets(basePath, contentType, extension, recursive, null, null);
    }

    @Override
    public List<AssetFile> getAssets(String basePath, String contentType, String extension) {
        CallSite[] callSiteArray = ClasspathAssetResolver.$getCallSiteArray();
        return this.getAssets(basePath, contentType, extension, true, null, null);
    }

    @Override
    public List<AssetFile> getAssets(String basePath, String contentType) {
        CallSite[] callSiteArray = ClasspathAssetResolver.$getCallSiteArray();
        return this.getAssets(basePath, contentType, null, true, null, null);
    }

    @Override
    public List<AssetFile> getAssets(String basePath) {
        CallSite[] callSiteArray = ClasspathAssetResolver.$getCallSiteArray();
        return this.getAssets(basePath, null, null, true, null, null);
    }

    static {
        String string;
        DIRECTIVE_FILE_SEPARATOR = string = "/";
        Object object = ClasspathAssetResolver.$getCallSiteArray()[36].callGetProperty(File.class);
        NATIVE_FILE_SEPARATOR = ShortTypeHandling.castToString((Object)object);
        Object object2 = ClasspathAssetResolver.$getCallSiteArray()[37].call(LoggerFactory.class, (Object)"asset.pipeline.fs.ClasspathAssetResolver");
        log = (Logger)ScriptBytecodeAdapter.castToType((Object)object2, Logger.class);
    }

    public static String getNATIVE_FILE_SEPARATOR() {
        return NATIVE_FILE_SEPARATOR;
    }

    public static void setNATIVE_FILE_SEPARATOR(String string) {
        NATIVE_FILE_SEPARATOR = string;
    }

    public static String getDIRECTIVE_FILE_SEPARATOR() {
        return DIRECTIVE_FILE_SEPARATOR;
    }

    public static void setDIRECTIVE_FILE_SEPARATOR(String string) {
        DIRECTIVE_FILE_SEPARATOR = string;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public String getPrefixPath() {
        return this.prefixPath;
    }

    public void setPrefixPath(String string) {
        this.prefixPath = string;
    }

    public String getAssetListPath() {
        return this.assetListPath;
    }

    public void setAssetListPath(String string) {
        this.assetListPath = string;
    }

    public Collection<String> getAssetList() {
        return this.assetList;
    }

    public void setAssetList(Collection<String> collection) {
        this.assetList = collection;
    }

    public /* synthetic */ MetaClass super$2$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "loadAssetList";
        stringArray[1] = "contextClassLoader";
        stringArray[2] = "currentThread";
        stringArray[3] = "contextClassLoader";
        stringArray[4] = "currentThread";
        stringArray[5] = "getResources";
        stringArray[6] = "each";
        stringArray[7] = "normalizePath";
        stringArray[8] = "replace";
        stringArray[9] = "getPossibleFileSpecs";
        stringArray[10] = "extensionFromURI";
        stringArray[11] = "findAll";
        stringArray[12] = "assetFileClasses";
        stringArray[13] = "resolveAsset";
        stringArray[14] = "path";
        stringArray[15] = "contains";
        stringArray[16] = "indexOf";
        stringArray[17] = "substring";
        stringArray[18] = "plus";
        stringArray[19] = "plus";
        stringArray[20] = "size";
        stringArray[21] = "<$constructor$>";
        stringArray[22] = "<$constructor$>";
        stringArray[23] = "<$constructor$>";
        stringArray[24] = "iterator";
        stringArray[25] = "getResource";
        stringArray[26] = "isFileMatchingPatterns";
        stringArray[27] = "isFileMatchingPatterns";
        stringArray[28] = "assetForFileName";
        stringArray[29] = "leftShift";
        stringArray[30] = "newInstance";
        stringArray[31] = "createInputStreamClosure";
        stringArray[32] = "leftShift";
        stringArray[33] = "<$constructor$>";
        stringArray[34] = "createInputStreamClosure";
        stringArray[35] = "unique";
        stringArray[36] = "separator";
        stringArray[37] = "getLogger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[38];
        ClasspathAssetResolver.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(ClasspathAssetResolver.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = ClasspathAssetResolver.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

