/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.textstyling.html;

import fr.opensagres.xdocreport.document.textstyling.properties.Color;

public class HTMLColorParser {
    public static Color parse(String colorString) {
        if (colorString == null || colorString.isEmpty()) {
            return null;
        }
        if (colorString.startsWith("rgb")) {
            return HTMLColorParser.parseRgb(colorString);
        }
        if (colorString.startsWith("#") && colorString.length() == 7) {
            return HTMLColorParser.parseHexadecimalValues(colorString);
        }
        return null;
    }

    private static Color parseRgb(String colorString) {
        String color = colorString.replaceAll("[^\\d,]*", "");
        String[] rgbColor = color.split(",");
        if (rgbColor.length == 3) {
            try {
                return new Color(Integer.parseInt(rgbColor[0]), Integer.parseInt(rgbColor[1]), Integer.parseInt(rgbColor[2]));
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    private static Color parseHexadecimalValues(String colorString) {
        String red = colorString.substring(1, 3);
        String green = colorString.substring(3, 5);
        String blue = colorString.substring(5, 7);
        try {
            return new Color(Integer.parseInt(red, 16), Integer.parseInt(green, 16), Integer.parseInt(blue, 16));
        }
        catch (Exception e) {
            return null;
        }
    }
}

