/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.ICollector;
import io.sentry.ITransaction;
import io.sentry.PerformanceCollectionData;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.TransactionPerformanceCollector;
import io.sentry.util.Objects;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class DefaultTransactionPerformanceCollector
implements TransactionPerformanceCollector {
    private static final long TRANSACTION_COLLECTION_INTERVAL_MILLIS = 100L;
    private static final long TRANSACTION_COLLECTION_TIMEOUT_MILLIS = 30000L;
    @NotNull
    private final Object timerLock = new Object();
    @Nullable
    private volatile Timer timer = null;
    @NotNull
    private final Map<String, List<PerformanceCollectionData>> performanceDataMap = new ConcurrentHashMap<String, List<PerformanceCollectionData>>();
    @NotNull
    private final List<ICollector> collectors;
    @NotNull
    private final SentryOptions options;
    @NotNull
    private final AtomicBoolean isStarted = new AtomicBoolean(false);

    public DefaultTransactionPerformanceCollector(@NotNull SentryOptions options) {
        this.options = Objects.requireNonNull(options, "The options object is required.");
        this.collectors = options.getCollectors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(@NotNull ITransaction transaction) {
        if (this.collectors.isEmpty()) {
            this.options.getLogger().log(SentryLevel.INFO, "No collector found. Performance stats will not be captured during transactions.", new Object[0]);
            return;
        }
        if (!this.performanceDataMap.containsKey(transaction.getEventId().toString())) {
            this.performanceDataMap.put(transaction.getEventId().toString(), new ArrayList());
            try {
                this.options.getExecutorService().schedule(() -> this.stop(transaction), 30000L);
            }
            catch (RejectedExecutionException e) {
                this.options.getLogger().log(SentryLevel.ERROR, "Failed to call the executor. Performance collector will not be automatically finished. Did you call Sentry.close()?", e);
            }
        }
        if (!this.isStarted.getAndSet(true)) {
            Object object = this.timerLock;
            synchronized (object) {
                if (this.timer == null) {
                    this.timer = new Timer(true);
                }
                this.timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        for (ICollector collector : DefaultTransactionPerformanceCollector.this.collectors) {
                            collector.setup();
                        }
                    }
                }, 0L);
                TimerTask timerTask = new TimerTask(){

                    @Override
                    public void run() {
                        @NotNull PerformanceCollectionData tempData = new PerformanceCollectionData();
                        for (ICollector collector : DefaultTransactionPerformanceCollector.this.collectors) {
                            collector.collect(tempData);
                        }
                        for (List data : DefaultTransactionPerformanceCollector.this.performanceDataMap.values()) {
                            data.add(tempData);
                        }
                    }
                };
                this.timer.scheduleAtFixedRate(timerTask, 100L, 100L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public List<PerformanceCollectionData> stop(@NotNull ITransaction transaction) {
        List<PerformanceCollectionData> data = this.performanceDataMap.remove(transaction.getEventId().toString());
        this.options.getLogger().log(SentryLevel.DEBUG, "stop collecting performance info for transactions %s (%s)", transaction.getName(), transaction.getSpanContext().getTraceId().toString());
        if (this.performanceDataMap.isEmpty() && this.isStarted.getAndSet(false)) {
            Object object = this.timerLock;
            synchronized (object) {
                if (this.timer != null) {
                    this.timer.cancel();
                    this.timer = null;
                }
            }
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.performanceDataMap.clear();
        this.options.getLogger().log(SentryLevel.DEBUG, "stop collecting all performance info for transactions", new Object[0]);
        if (this.isStarted.getAndSet(false)) {
            Object object = this.timerLock;
            synchronized (object) {
                if (this.timer != null) {
                    this.timer.cancel();
                    this.timer = null;
                }
            }
        }
    }
}

