/*
 * Decompiled with CFR 0.152.
 */
package grails.plugin.cache.ehcache;

import grails.plugin.cache.CacheException;
import grails.plugin.cache.ehcache.EhcacheConfiguration;
import grails.plugin.cache.ehcache.GrailsEhcacheCache;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.ehcache.Status;
import org.ehcache.config.Builder;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.Configuration;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.grails.plugin.cache.GrailsCacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class GrailsEhcacheCacheManager
implements GrailsCacheManager,
InitializingBean,
DisposableBean,
GroovyObject {
    protected CacheManager cacheManager;
    protected final ConcurrentMap<String, org.springframework.cache.Cache> cacheMap;
    protected Set<String> cacheNames;
    protected Configuration configuration;
    private final Lock lock;
    private Long lockTimeout;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public GrailsEhcacheCacheManager() {
        MetaClass metaClass;
        ConcurrentHashMap<String, org.springframework.cache.Cache> concurrentHashMap = new ConcurrentHashMap<String, org.springframework.cache.Cache>();
        this.cacheMap = concurrentHashMap;
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        this.cacheNames = linkedHashSet;
        ReentrantLock reentrantLock = new ReentrantLock();
        this.lock = reentrantLock;
        int n = 200;
        this.lockTimeout = (Long)ScriptBytecodeAdapter.castToType((Object)n, Long.class);
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public org.springframework.cache.Cache getCache(String name) {
        org.springframework.cache.Cache cache = (org.springframework.cache.Cache)ScriptBytecodeAdapter.castToType(this.cacheMap.get(name), org.springframework.cache.Cache.class);
        if (cache == null) {
            try {
                org.springframework.cache.Cache cache2;
                cache = cache2 = this.getOrCreateCache(name);
            }
            catch (InterruptedException e) {
                throw (Throwable)new CacheException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"Failed to get lock for ", " cache creation"})));
            }
        }
        return cache;
    }

    protected org.springframework.cache.Cache getOrCreateCache(String name) throws InterruptedException {
        if (!this.lock.tryLock(this.lockTimeout, TimeUnit.MILLISECONDS)) {
            throw (Throwable)new CacheException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"Failed to get lock for ", " cache creation"})));
        }
        try {
            Map configurations = this.cacheManager.getRuntimeConfiguration().getCacheConfigurations();
            Cache cache = null;
            if (configurations.containsKey(name)) {
                Cache cache2;
                CacheConfiguration configuration = (CacheConfiguration)ScriptBytecodeAdapter.castToType(configurations.get(name), CacheConfiguration.class);
                cache = cache2 = this.cacheManager.getCache(name, configuration.getKeyType(), configuration.getValueType());
            } else {
                Cache cache3;
                cache = cache3 = this.createDefaultCache(name);
            }
            GrailsEhcacheCache grailsCache = new GrailsEhcacheCache(name, cache);
            this.addCache((org.springframework.cache.Cache)grailsCache);
            GrailsEhcacheCache grailsEhcacheCache = grailsCache;
            return grailsEhcacheCache;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected Cache createDefaultCache(String name) {
        return this.cacheManager.createCache(name, (Builder)CacheConfigurationBuilder.newCacheConfigurationBuilder(Object.class, Object.class, (Builder)ResourcePoolsBuilder.heap((long)10)));
    }

    protected CacheManager createDefaultManager() {
        return CacheManagerBuilder.newCacheManagerBuilder().build();
    }

    public void setConfiguration(EhcacheConfiguration configuration) {
        Configuration configuration2;
        this.configuration = configuration2 = configuration.getConfiguration();
    }

    public boolean cacheExists(String name) {
        return this.getCacheNames().contains(name);
    }

    public boolean destroyCache(String name) {
        this.cacheManager.removeCache(name);
        this.cacheMap.remove(name);
        this.cacheNames.remove(name);
        return true;
    }

    public Collection<String> getCacheNames() {
        return Collections.unmodifiableSet(this.cacheNames);
    }

    protected GrailsEhcacheCache buildCache(String name, CacheConfiguration configuration) {
        return new GrailsEhcacheCache(name, this.cacheManager.getCache(name, configuration.getKeyType(), configuration.getValueType()));
    }

    protected Collection<org.springframework.cache.Cache> loadCaches() {
        Assert.notNull((Object)this.cacheManager, (String)"A backing EhCache CacheManager is required");
        Status status = this.cacheManager.getStatus();
        Assert.isTrue((boolean)ScriptBytecodeAdapter.compareEqual((Object)Status.AVAILABLE, (Object)status), (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{status}, new String[]{"An 'available' EhCache CacheManager is required - current cache is ", ""})));
        Map configurations = this.cacheManager.getRuntimeConfiguration().getCacheConfigurations();
        Set names = configurations.keySet();
        LinkedHashSet<org.springframework.cache.Cache> caches = new LinkedHashSet<org.springframework.cache.Cache>(names.size());
        String name = null;
        Iterator iterator = names.iterator();
        while (iterator.hasNext()) {
            name = ShortTypeHandling.castToString(iterator.next());
            CacheConfiguration configuration = (CacheConfiguration)ScriptBytecodeAdapter.castToType(configurations.get(name), CacheConfiguration.class);
            caches.add((org.springframework.cache.Cache)this.buildCache(name, configuration));
        }
        return caches;
    }

    protected void addCache(org.springframework.cache.Cache cache) {
        this.cacheMap.put(cache.getName(), cache);
        this.cacheNames.add(cache.getName());
    }

    public CacheManager getUnderlyingCacheManager() {
        return this.cacheManager;
    }

    public void afterPropertiesSet() {
        Object v0;
        if (this.configuration != null) {
            CacheManager cacheManager;
            log.debug("Using provided configuration");
            this.cacheManager = cacheManager = CacheManagerBuilder.newCacheManager((Configuration)this.configuration);
        } else {
            CacheManager cacheManager;
            log.debug("Using default configuration");
            this.cacheManager = cacheManager = this.createDefaultManager();
        }
        this.cacheManager.init();
        if (ScriptBytecodeAdapter.compareNotEqual((Object)Status.AVAILABLE, (Object)this.cacheManager.getStatus())) {
            return;
        }
        Collection<org.springframework.cache.Cache> caches = this.loadCaches();
        org.springframework.cache.Cache cache = null;
        Iterator<org.springframework.cache.Cache> iterator = caches.iterator();
        while (iterator.hasNext()) {
            cache = (org.springframework.cache.Cache)ScriptBytecodeAdapter.castToType((Object)iterator.next(), org.springframework.cache.Cache.class);
            this.addCache(cache);
        }
        if (log.isDebugEnabled()) {
            log.debug("Cache names: {}", this.getCacheNames());
            v0 = null;
        } else {
            v0 = null;
        }
    }

    public void destroy() throws Exception {
        this.cacheManager.close();
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != GrailsEhcacheCacheManager.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"grails.plugin.cache.ehcache.GrailsEhcacheCacheManager");
    }

    public Long getLockTimeout() {
        return this.lockTimeout;
    }

    public void setLockTimeout(Long l) {
        this.lockTimeout = l;
    }
}

