/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.layout.ByteBufferDestination;
import org.apache.logging.log4j.status.StatusLogger;

public abstract class AbstractLayout<T extends Serializable>
implements Layout<T> {
    protected static final Logger LOGGER = StatusLogger.getLogger();
    protected final Configuration configuration;
    protected long eventCount;
    protected final byte[] footer;
    protected final byte[] header;

    @Deprecated
    public AbstractLayout(byte[] header, byte[] footer) {
        this(null, header, footer);
    }

    public AbstractLayout(Configuration configuration, byte[] header, byte[] footer) {
        this.configuration = configuration;
        this.header = header;
        this.footer = footer;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public Map<String, String> getContentFormat() {
        return new HashMap<String, String>();
    }

    @Override
    public byte[] getFooter() {
        return this.footer;
    }

    @Override
    public byte[] getHeader() {
        return this.header;
    }

    protected void markEvent() {
        ++this.eventCount;
    }

    @Override
    public void encode(LogEvent event, ByteBufferDestination destination) {
        byte[] data = this.toByteArray(event);
        AbstractLayout.writeTo(data, 0, data.length, destination);
    }

    public static void writeTo(byte[] data, int offset, int length, ByteBufferDestination destination) {
        int chunk = 0;
        ByteBuffer buffer = destination.getByteBuffer();
        do {
            if (length > buffer.remaining()) {
                buffer = destination.drain(buffer);
            }
            chunk = Math.min(length, buffer.remaining());
            buffer.put(data, offset, chunk);
            offset += chunk;
        } while ((length -= chunk) > 0);
    }
}

