/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.poi.xwpf.converter.core.utils;

import fr.opensagres.poi.xwpf.converter.core.utils.XWPFUtils;
import java.math.BigInteger;
import org.openxmlformats.schemas.officeDocument.x2006.sharedTypes.STTwipsMeasure;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STSignedTwipsMeasure;

public class DxaUtil {
    public static float dxa2mm(float dxa) {
        return (float)((double)DxaUtil.dxa2inch(dxa) * 25.4);
    }

    public static float dxa2mm(BigInteger dxa) {
        return (float)((double)DxaUtil.dxa2inch(dxa) * 25.4);
    }

    public static float emu2points(long emu) {
        return DxaUtil.dxa2points(emu) / 635.0f;
    }

    public static float dxa2points(float dxa) {
        return dxa / 20.0f;
    }

    public static int dxa2points(int dxa) {
        return dxa / 20;
    }

    public static float dxa2points(BigInteger dxa) {
        return (float)(dxa.doubleValue() / 20.0);
    }

    public static float dxa2points(STTwipsMeasure dxa) {
        return DxaUtil.dxa2points(XWPFUtils.floatValue(dxa));
    }

    public static float dxa2points(STSignedTwipsMeasure dxa) {
        return DxaUtil.dxa2points(XWPFUtils.floatValue(dxa));
    }

    public static float dxa2inch(float dxa) {
        return DxaUtil.dxa2points(dxa) / 72.0f;
    }

    public static float dxa2inch(BigInteger dxa) {
        return DxaUtil.dxa2points(dxa) / 72.0f;
    }
}

