/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.fo;

import java.util.Map;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.FORenderer;
import org.docx4j.convert.out.FOSettings;
import org.docx4j.convert.out.common.AbstractConversionContext;
import org.docx4j.convert.out.common.AbstractWmlConversionContext;
import org.docx4j.convert.out.common.ConversionSectionWrapper;
import org.docx4j.convert.out.fo.FOPictWriterAbstract;
import org.docx4j.model.structure.PageDimensions;
import org.docx4j.vml.VmlShapeElements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class FOPictWriterNoWrapImpl
extends FOPictWriterAbstract {
    protected static Logger log = LoggerFactory.getLogger(FOPictWriterNoWrapImpl.class);

    @Override
    public Node handleVTextBoxNoWrap(AbstractWmlConversionContext context, Node modelContent, Document doc, VmlShapeElements shape, Map<String, String> props) {
        String mso_position_vertical_relative = props.get("mso-position-vertical-relative");
        String mso_position_vertical = props.get("mso-position-vertical");
        String position = props.get("position");
        ConversionSectionWrapper csw = context.getSections().getCurrentSection();
        PageDimensions pageDimensions = csw.getPageDimensions();
        int writableWidthTwips = pageDimensions.getWritableWidthTwips();
        float writableWidthPts = writableWidthTwips / 20;
        int writableHeightTwips = pageDimensions.getWritableHeightTwips();
        float writableHeightPts = writableHeightTwips / 20;
        FORenderer foRenderer = ((FOSettings)context.getConversionSettings()).getCustomFoRenderer();
        log.debug(foRenderer.getClass().getName());
        log.debug("textbox - over/behind docx text");
        Element ret = doc.createElementNS(XSL_FO, "block-container");
        XmlUtils.treeCopy((NodeList)modelContent.getChildNodes(), (Node)ret);
        this.setBorders(ret);
        String mso_position_horizontal_relative = props.get("mso-position-horizontal-relative");
        String mso_position_horizontal = props.get("mso-position-horizontal");
        if (mso_position_horizontal_relative == null) {
            log.warn("No support for mso_position_horizontal_relative==null");
        } else if (!mso_position_horizontal_relative.equals("text")) {
            log.warn("No support for mso_position_horizontal_relative==" + mso_position_horizontal_relative.equals("text"));
        } else {
            int marginLeft;
            float boxWidth = this.parsePtsVal(props.get("width"));
            ret.setAttribute("width", props.get("width"));
            ret.setAttribute("height", props.get("height"));
            if (mso_position_horizontal == null) {
                log.warn("No support for mso_position_horizontal==null");
            } else if (mso_position_horizontal.equals("left")) {
                ret.setAttribute("left", "0pt");
            } else if (mso_position_horizontal.equals("center")) {
                marginLeft = Math.round((writableWidthPts - boxWidth) / 2.0f);
                ret.setAttribute("left", marginLeft + "pt");
            } else if (mso_position_horizontal.equals("right")) {
                marginLeft = Math.round(writableWidthPts - boxWidth);
                ret.setAttribute("left", marginLeft + "pt");
            } else if (mso_position_horizontal.equals("absolute")) {
                ret.setAttribute("margin-left", props.get("margin-left"));
            }
        }
        ret.setAttribute("z-index", props.get("z-index"));
        String margin_top = props.get("margin-top");
        if (position != null && position.equals("absolute") || mso_position_vertical_relative != null && mso_position_vertical_relative.equals("text")) {
            ret.setAttribute("position", "absolute");
            if (margin_top != null) {
                ret.setAttribute("top", margin_top);
            }
            log.debug(XmlUtils.w3CDomNodeToString((Node)ret));
            return ret;
        }
        if (mso_position_vertical_relative == null) {
            if (log.isWarnEnabled()) {
                log.warn(XmlUtils.marshaltoString((Object)shape));
            }
            return context.getMessageWriter().message((AbstractConversionContext)context, "mso_position_vertical_relative==null.  What to do?");
        }
        if (mso_position_vertical_relative.equals("page") || mso_position_vertical_relative.equals("top-margin-area") || mso_position_vertical_relative.equals("bottom-margin-area")) {
            int top;
            ret.setAttribute("position", "fixed");
            if (mso_position_vertical_relative.equals("page")) {
                if (mso_position_vertical.equals("top")) {
                    if (margin_top != null) {
                        ret.setAttribute("top", margin_top);
                    }
                } else if (mso_position_vertical.equals("bottom")) {
                    top = Math.round(writableHeightPts);
                    ret.setAttribute("top", top + "pt");
                } else {
                    log.warn("No support for mso_position_vertical==" + mso_position_vertical);
                }
                log.debug(XmlUtils.w3CDomNodeToString((Node)ret));
                return ret;
            }
            if (mso_position_vertical_relative.equals("top-margin-area")) {
                if (margin_top != null) {
                    ret.setAttribute("top", margin_top);
                }
                log.debug(XmlUtils.w3CDomNodeToString((Node)ret));
                return ret;
            }
            if (mso_position_vertical_relative.equals("bottom-margin-area")) {
                top = Math.round(writableHeightPts);
                ret.setAttribute("top", top + "pt");
                log.debug(XmlUtils.w3CDomNodeToString((Node)ret));
                return ret;
            }
            return context.getMessageWriter().message((AbstractConversionContext)context, "TODO (how did we get here?) mso-position-vertical-relative=" + mso_position_vertical_relative);
        }
        return context.getMessageWriter().message((AbstractConversionContext)context, "TODO support no-wrap + mso-position-vertical-relative=" + mso_position_vertical_relative);
    }
}

