/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts.WordprocessingML;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.JAXBException;
import org.docx4j.fonts.Mapper;
import org.docx4j.fonts.PhysicalFont;
import org.docx4j.openpackaging.contenttype.ContentType;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.TrueTypeFontPart;
import org.docx4j.openpackaging.parts.WordprocessingML.ObfuscatedFontPart;
import org.docx4j.utils.ResourceUtils;
import org.docx4j.wml.FontRel;
import org.docx4j.wml.Fonts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FontTablePart
extends JaxbXmlPart<Fonts> {
    private static Logger log = LoggerFactory.getLogger(FontTablePart.class);
    private String filenamePrefix = null;

    public FontTablePart(PartName partName) throws InvalidFormatException {
        super(partName);
        this.init();
    }

    public FontTablePart() throws InvalidFormatException {
        super(new PartName("/word/fontTable.xml"));
        this.init();
    }

    public void init() {
        this.setContentType(new ContentType("application/vnd.openxmlformats-officedocument.wordprocessingml.fontTable+xml"));
        this.setRelationshipType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/fontTable");
    }

    public Object unmarshalDefaultFonts() throws JAXBException {
        InputStream is = null;
        try {
            is = ResourceUtils.getResourceViaProperty("docx4j.openpackaging.parts.WordprocessingML.FontTablePart.DefaultFonts", "org/docx4j/openpackaging/parts/WordprocessingML/fontTable.xml");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.unmarshal(is);
    }

    public void processEmbeddings() {
        this.processEmbeddings(null);
    }

    public void processEmbeddings(Mapper fontMapper) {
        Fonts fonts = (Fonts)this.getJaxbElement();
        if (fonts == null) {
            log.warn("No content in font table part");
            return;
        }
        this.filenamePrefix = "" + System.currentTimeMillis();
        log.info("Writing temp embedded fonts " + this.filenamePrefix);
        for (Fonts.Font font : fonts.getFont()) {
            String fontName = font.getName();
            FontRel embedRegular = font.getEmbedRegular();
            FontRel embedBold = font.getEmbedBold();
            FontRel embedBoldItalic = font.getEmbedBoldItalic();
            FontRel embedItalic = font.getEmbedItalic();
            PhysicalFont pfRegular = this.getFontFromRelationship(fontName, fontName, embedRegular);
            PhysicalFont pfBold = this.getFontFromRelationship(fontName, fontName + "-bold", embedBold);
            PhysicalFont pfItalic = this.getFontFromRelationship(fontName, fontName + "-italic", embedItalic);
            PhysicalFont pfBoldItalic = this.getFontFromRelationship(fontName, fontName + "-bold-italic", embedBoldItalic);
            if (fontMapper == null) continue;
            fontMapper.registerRegularForm(fontName, pfRegular);
            fontMapper.registerBoldForm(fontName, pfBold);
            fontMapper.registerItalicForm(fontName, pfItalic);
            fontMapper.registerBoldItalicForm(fontName, pfBoldItalic);
        }
    }

    private PhysicalFont getFontFromRelationship(String fontNameAsInFontTablePart, String fontFileName, FontRel fontRel) {
        if (fontRel == null) {
            return null;
        }
        String id = fontRel.getId();
        String fontKey = fontRel.getFontKey();
        Part p = this.getRelationshipsPart().getPart(id);
        if (p instanceof ObfuscatedFontPart) {
            ObfuscatedFontPart obfuscatedFont = (ObfuscatedFontPart)this.getRelationshipsPart().getPart(id);
            if (obfuscatedFont != null) {
                return obfuscatedFont.extract(fontNameAsInFontTablePart, fontFileName, fontKey, this.filenamePrefix);
            }
            log.error("Couldn't find ObfuscatedFontPart with id: " + id);
        } else {
            TrueTypeFontPart truetypeFont = (TrueTypeFontPart)this.getRelationshipsPart().getPart(id);
            if (truetypeFont != null) {
                return truetypeFont.extract(fontNameAsInFontTablePart, fontFileName, fontKey, this.filenamePrefix);
            }
            log.error("Couldn't find TrueTypeFontPart with id: " + id);
        }
        return null;
    }

    public void deleteEmbeddedFontTempFiles() {
        if (this.filenamePrefix != null) {
            log.debug("Deleting temp embedded fonts " + this.filenamePrefix);
            ObfuscatedFontPart.deleteEmbeddedFontTempFiles(this.filenamePrefix);
        }
    }

    public static void main(String[] args) throws Exception {
        String filepath = System.getProperty("user.dir") + "/sample-docs/word/FontEmbedded.docx";
        WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.load(new File(filepath));
        wordMLPackage.getMainDocumentPart().getFontTablePart().processEmbeddings();
    }
}

