/*
 * Decompiled with CFR 0.152.
 */
package org.grails.core.io;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;

public class StaticResourceLoader
implements ResourceLoader {
    private static final Logger LOG = LoggerFactory.getLogger(StaticResourceLoader.class);
    private Resource baseResource;

    public void setBaseResource(Resource baseResource) {
        this.baseResource = baseResource;
    }

    public Resource getResource(String location) {
        Assert.state((this.baseResource != null ? 1 : 0) != 0, (String)"Property [baseResource] not set!");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loading resource for path {} from base resource {}", (Object)location, (Object)this.baseResource);
        }
        try {
            Resource resource = this.baseResource.createRelative(location);
            if (LOG.isDebugEnabled() && resource.exists()) {
                LOG.debug("Found resource for path {} from base resource {}", (Object)location, (Object)this.baseResource);
            }
            return resource;
        }
        catch (IOException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Error loading resource for path: " + location, (Throwable)e);
            }
            return null;
        }
    }

    public ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }
}

