/*
 * Decompiled with CFR 0.152.
 */
package liquibase.pro.packaged;

import java.math.BigDecimal;
import java.util.ArrayList;
import liquibase.pro.packaged.az;
import liquibase.pro.packaged.be;
import liquibase.pro.packaged.bg;

public final class bs {
    static final char[] NO_CHARS = new char[0];
    static final int MIN_SEGMENT_LEN = 1000;
    static final int MAX_SEGMENT_LEN = 262144;
    private final be _allocator;
    private char[] _inputBuffer;
    private int _inputStart;
    private int _inputLen;
    private ArrayList<char[]> _segments;
    private boolean _hasSegments = false;
    private int _segmentSize;
    private char[] _currentSegment;
    private int _currentSize;
    private String _resultString;
    private char[] _resultArray;

    public bs(be be2) {
        this._allocator = be2;
    }

    public final void releaseBuffers() {
        if (this._allocator == null) {
            this.resetWithEmpty();
            return;
        }
        if (this._currentSegment != null) {
            this.resetWithEmpty();
            char[] cArray = this._currentSegment;
            this._currentSegment = null;
            this._allocator.releaseCharBuffer(bg.TEXT_BUFFER, cArray);
        }
    }

    public final void resetWithEmpty() {
        this._inputStart = -1;
        this._currentSize = 0;
        this._inputLen = 0;
        this._inputBuffer = null;
        this._resultString = null;
        this._resultArray = null;
        if (this._hasSegments) {
            this.clearSegments();
        }
    }

    public final void resetWithShared(char[] cArray, int n2, int n3) {
        this._resultString = null;
        this._resultArray = null;
        this._inputBuffer = cArray;
        this._inputStart = n2;
        this._inputLen = n3;
        if (this._hasSegments) {
            this.clearSegments();
        }
    }

    public final void resetWithCopy(char[] cArray, int n2, int n3) {
        this._inputBuffer = null;
        this._inputStart = -1;
        this._inputLen = 0;
        this._resultString = null;
        this._resultArray = null;
        if (this._hasSegments) {
            this.clearSegments();
        } else if (this._currentSegment == null) {
            this._currentSegment = this.findBuffer(n3);
        }
        bs bs2 = this;
        bs2._segmentSize = 0;
        bs2._currentSize = 0;
        this.append(cArray, n2, n3);
    }

    public final void resetWithString(String string) {
        this._inputBuffer = null;
        this._inputStart = -1;
        this._inputLen = 0;
        this._resultString = string;
        this._resultArray = null;
        if (this._hasSegments) {
            this.clearSegments();
        }
        this._currentSize = 0;
    }

    private char[] findBuffer(int n2) {
        if (this._allocator != null) {
            return this._allocator.allocCharBuffer(bg.TEXT_BUFFER, n2);
        }
        return new char[Math.max(n2, 1000)];
    }

    private void clearSegments() {
        this._hasSegments = false;
        this._segments.clear();
        bs bs2 = this;
        bs2._segmentSize = 0;
        bs2._currentSize = 0;
    }

    public final int size() {
        if (this._inputStart >= 0) {
            return this._inputLen;
        }
        if (this._resultArray != null) {
            return this._resultArray.length;
        }
        if (this._resultString != null) {
            return this._resultString.length();
        }
        return this._segmentSize + this._currentSize;
    }

    public final int getTextOffset() {
        if (this._inputStart >= 0) {
            return this._inputStart;
        }
        return 0;
    }

    public final boolean hasTextAsCharacters() {
        if (this._inputStart >= 0 || this._resultArray != null) {
            return true;
        }
        return this._resultString == null;
    }

    public final char[] getTextBuffer() {
        if (this._inputStart >= 0) {
            return this._inputBuffer;
        }
        if (this._resultArray != null) {
            return this._resultArray;
        }
        if (this._resultString != null) {
            this._resultArray = this._resultString.toCharArray();
            return this._resultArray;
        }
        if (!this._hasSegments) {
            return this._currentSegment;
        }
        return this.contentsAsArray();
    }

    public final String contentsAsString() {
        if (this._resultString == null) {
            if (this._resultArray != null) {
                this._resultString = new String(this._resultArray);
            } else if (this._inputStart >= 0) {
                if (this._inputLen <= 0) {
                    this._resultString = "";
                    return "";
                }
                this._resultString = new String(this._inputBuffer, this._inputStart, this._inputLen);
            } else {
                int n2 = this._segmentSize;
                int n3 = this._currentSize;
                if (n2 == 0) {
                    this._resultString = n3 == 0 ? "" : new String(this._currentSegment, 0, n3);
                } else {
                    StringBuilder stringBuilder = new StringBuilder(n2 + n3);
                    if (this._segments != null) {
                        int n4 = this._segments.size();
                        for (n3 = 0; n3 < n4; ++n3) {
                            char[] cArray = this._segments.get(n3);
                            stringBuilder.append(cArray, 0, cArray.length);
                        }
                    }
                    stringBuilder.append(this._currentSegment, 0, this._currentSize);
                    this._resultString = stringBuilder.toString();
                }
            }
        }
        return this._resultString;
    }

    public final char[] contentsAsArray() {
        char[] cArray = this._resultArray;
        if (this._resultArray == null) {
            this._resultArray = cArray = this.buildResultArray();
        }
        return cArray;
    }

    public final BigDecimal contentsAsDecimal() {
        if (this._resultArray != null) {
            return new BigDecimal(this._resultArray);
        }
        if (this._inputStart >= 0) {
            return new BigDecimal(this._inputBuffer, this._inputStart, this._inputLen);
        }
        if (this._segmentSize == 0) {
            return new BigDecimal(this._currentSegment, 0, this._currentSize);
        }
        return new BigDecimal(this.contentsAsArray());
    }

    public final double contentsAsDouble() {
        return az.parseDouble(this.contentsAsString());
    }

    public final void ensureNotShared() {
        if (this._inputStart >= 0) {
            this.unshare(16);
        }
    }

    public final void append(char c2) {
        if (this._inputStart >= 0) {
            this.unshare(16);
        }
        this._resultString = null;
        this._resultArray = null;
        char[] cArray = this._currentSegment;
        if (this._currentSize >= cArray.length) {
            this.expand(1);
            cArray = this._currentSegment;
        }
        cArray[this._currentSize++] = c2;
    }

    public final void append(char[] cArray, int n2, int n3) {
        int n4;
        if (this._inputStart >= 0) {
            this.unshare(n3);
        }
        this._resultString = null;
        this._resultArray = null;
        char[] cArray2 = this._currentSegment;
        int n5 = this._currentSegment.length - this._currentSize;
        if (n5 >= n3) {
            System.arraycopy(cArray, n2, cArray2, this._currentSize, n3);
            this._currentSize += n3;
            return;
        }
        if (n5 > 0) {
            System.arraycopy(cArray, n2, cArray2, this._currentSize, n5);
            n2 += n5;
            n3 -= n5;
        }
        do {
            this.expand(n3);
            n4 = Math.min(this._currentSegment.length, n3);
            System.arraycopy(cArray, n2, this._currentSegment, 0, n4);
            this._currentSize += n4;
            n2 += n4;
        } while ((n3 -= n4) > 0);
    }

    public final void append(String string, int n2, int n3) {
        int n4;
        if (this._inputStart >= 0) {
            this.unshare(n3);
        }
        this._resultString = null;
        this._resultArray = null;
        char[] cArray = this._currentSegment;
        int n5 = this._currentSegment.length - this._currentSize;
        if (n5 >= n3) {
            int n6 = n2;
            string.getChars(n6, n6 + n3, cArray, this._currentSize);
            this._currentSize += n3;
            return;
        }
        if (n5 > 0) {
            int n7 = n2;
            string.getChars(n7, n7 + n5, cArray, this._currentSize);
            n3 -= n5;
            n2 += n5;
        }
        do {
            this.expand(n3);
            n4 = Math.min(this._currentSegment.length, n3);
            int n8 = n2;
            string.getChars(n8, n8 + n4, this._currentSegment, 0);
            this._currentSize += n4;
            n2 += n4;
        } while ((n3 -= n4) > 0);
    }

    public final char[] getCurrentSegment() {
        if (this._inputStart >= 0) {
            this.unshare(1);
        } else {
            char[] cArray = this._currentSegment;
            if (this._currentSegment == null) {
                this._currentSegment = this.findBuffer(0);
            } else if (this._currentSize >= cArray.length) {
                this.expand(1);
            }
        }
        return this._currentSegment;
    }

    public final char[] emptyAndGetCurrentSegment() {
        this._inputStart = -1;
        this._currentSize = 0;
        this._inputLen = 0;
        this._inputBuffer = null;
        this._resultString = null;
        this._resultArray = null;
        if (this._hasSegments) {
            this.clearSegments();
        }
        char[] cArray = this._currentSegment;
        if (this._currentSegment == null) {
            this._currentSegment = cArray = this.findBuffer(0);
        }
        return cArray;
    }

    public final int getCurrentSegmentSize() {
        return this._currentSize;
    }

    public final void setCurrentLength(int n2) {
        this._currentSize = n2;
    }

    public final char[] finishCurrentSegment() {
        if (this._segments == null) {
            this._segments = new ArrayList();
        }
        this._hasSegments = true;
        this._segments.add(this._currentSegment);
        int n2 = this._currentSegment.length;
        this._segmentSize += n2;
        int n3 = n2;
        n2 = Math.min(n3 + (n3 >> 1), 262144);
        char[] cArray = this._charArray(n2);
        this._currentSize = 0;
        this._currentSegment = cArray;
        return cArray;
    }

    public final char[] expandCurrentSegment() {
        int n2;
        char[] cArray = this._currentSegment;
        int n3 = this._currentSegment.length;
        if (n3 == 262144) {
            n2 = 262145;
        } else {
            int n4 = n3;
            n2 = Math.min(262144, n4 + (n4 >> 1));
        }
        int n5 = n2;
        this._currentSegment = this._charArray(n5);
        System.arraycopy(cArray, 0, this._currentSegment, 0, n3);
        return this._currentSegment;
    }

    public final String toString() {
        return this.contentsAsString();
    }

    private void unshare(int n2) {
        int n3 = this._inputLen;
        this._inputLen = 0;
        char[] cArray = this._inputBuffer;
        this._inputBuffer = null;
        int n4 = this._inputStart;
        this._inputStart = -1;
        n2 = n3 + n2;
        if (this._currentSegment == null || n2 > this._currentSegment.length) {
            this._currentSegment = this.findBuffer(n2);
        }
        if (n3 > 0) {
            System.arraycopy(cArray, n4, this._currentSegment, 0, n3);
        }
        this._segmentSize = 0;
        this._currentSize = n3;
    }

    private void expand(int n2) {
        if (this._segments == null) {
            this._segments = new ArrayList();
        }
        char[] cArray = this._currentSegment;
        this._hasSegments = true;
        this._segments.add(cArray);
        this._segmentSize += cArray.length;
        int n3 = cArray.length;
        int n4 = n3 >> 1;
        if (n4 < n2) {
            n4 = n2;
        }
        char[] cArray2 = this._charArray(Math.min(262144, n3 + n4));
        this._currentSize = 0;
        this._currentSegment = cArray2;
    }

    private char[] buildResultArray() {
        char[] cArray;
        if (this._resultString != null) {
            return this._resultString.toCharArray();
        }
        if (this._inputStart >= 0) {
            if (this._inputLen <= 0) {
                return NO_CHARS;
            }
            bs bs2 = this;
            cArray = bs2._charArray(bs2._inputLen);
            System.arraycopy(this._inputBuffer, this._inputStart, cArray, 0, this._inputLen);
        } else {
            int n2 = this.size();
            if (n2 <= 0) {
                return NO_CHARS;
            }
            int n3 = 0;
            cArray = this._charArray(n2);
            if (this._segments != null) {
                int n4 = this._segments.size();
                for (int i2 = 0; i2 < n4; ++i2) {
                    char[] cArray2 = this._segments.get(i2);
                    int n5 = cArray2.length;
                    System.arraycopy(cArray2, 0, cArray, n3, n5);
                    n3 += n5;
                }
            }
            System.arraycopy(this._currentSegment, 0, cArray, n3, this._currentSize);
        }
        return cArray;
    }

    private char[] _charArray(int n2) {
        return new char[n2];
    }
}

