/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.datastorage.migration;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.docx4j.TraversalUtil;
import org.docx4j.XmlUtils;
import org.docx4j.model.datastorage.migration.AbstractMigratorUsingAnswersFormat;
import org.docx4j.model.fields.ComplexFieldLocator;
import org.docx4j.model.fields.FieldRef;
import org.docx4j.model.fields.FieldsPreprocessor;
import org.docx4j.openpackaging.io.SaveToZipFile;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.P;
import org.docx4j.wml.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FromMergeFields
extends AbstractMigratorUsingAnswersFormat {
    private static Logger log = LoggerFactory.getLogger(FromMergeFields.class);

    public WordprocessingMLPackage migrate(WordprocessingMLPackage pkgIn) throws Exception {
        WordprocessingMLPackage pkgOut = (WordprocessingMLPackage)pkgIn.clone();
        this.createParts(pkgOut);
        FieldsPreprocessor.complexifyFields(pkgOut.getMainDocumentPart());
        if (log.isDebugEnabled()) {
            log.debug("complexified: " + XmlUtils.marshaltoString(pkgOut.getMainDocumentPart().getJaxbElement(), true));
        }
        ComplexFieldLocator fl = new ComplexFieldLocator();
        new TraversalUtil(pkgOut.getMainDocumentPart().getContent(), fl);
        log.info("Found " + fl.getStarts().size() + " fields ");
        ArrayList<FieldRef> fieldRefs = new ArrayList<FieldRef>();
        for (P p : fl.getStarts()) {
            int index = ((ContentAccessor)p.getParent()).getContent().indexOf(p);
            P newP = FieldsPreprocessor.canonicalise(p, fieldRefs);
            ((ContentAccessor)p.getParent()).getContent().set(index, newP);
        }
        for (FieldRef fr : fieldRefs) {
            if (!fr.getFldName().equals("MERGEFIELD")) continue;
            String instr = FromMergeFields.extractInstr(fr.getInstructions());
            String tmp = instr.substring(instr.indexOf("MERGEFIELD") + 10);
            String key = (tmp = tmp.trim()).indexOf(" ") > -1 ? tmp.substring(0, tmp.indexOf(" ")) : tmp;
            log.info("Key: '" + key + "'");
            int end = fr.getParent().getContent().indexOf(fr.getEndRun());
            int begin = fr.getParent().getContent().indexOf(fr.getBeginRun());
            for (int i = end; i >= begin; --i) {
                fr.getParent().getContent().remove(i);
            }
            ArrayList<Object> replacementContent = new ArrayList<Object>();
            this.createContentControl(null, replacementContent, key);
            fr.getParent().getContent().addAll(begin, replacementContent);
        }
        return pkgOut;
    }

    private static String extractInstr(List<Object> instructions) {
        if (instructions.size() != 1) {
            log.error("TODO MERGEFIELD field contained complex instruction");
            return null;
        }
        Object o = XmlUtils.unwrap(instructions.get(0));
        if (o instanceof Text) {
            return ((Text)o).getValue();
        }
        if (log.isErrorEnabled()) {
            log.error("TODO: extract field name from " + o.getClass().getName());
            log.error(XmlUtils.marshaltoString(instructions.get(0), true, true));
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        String inputfilepath = System.getProperty("user.dir") + "/TEST1.docx";
        String outputfilepath = System.getProperty("user.dir") + "/OUT_TEST1.docx";
        WordprocessingMLPackage pkgIn = WordprocessingMLPackage.load(new File(inputfilepath));
        FromMergeFields migrator = new FromMergeFields();
        WordprocessingMLPackage pkgOut = migrator.migrate(pkgIn);
        SaveToZipFile saver = new SaveToZipFile(pkgOut);
        saver.save(outputfilepath);
    }
}

