/*
 * Decompiled with CFR 0.152.
 */
package org.opendope.conditions;

import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.docx4j.model.datastorage.BindingHandler;
import org.docx4j.model.datastorage.XPathEnhancerParser;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.CustomXmlPart;
import org.opendope.conditions.Condition;
import org.opendope.conditions.Evaluable;
import org.opendope.xpaths.Xpaths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="")
@XmlRootElement(name="xpathref")
public class Xpathref
implements Evaluable {
    private static Logger log = LoggerFactory.getLogger(Xpathref.class);
    @XmlAttribute(required=true)
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlSchemaType(name="NCName")
    protected String id;

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    @Override
    public boolean evaluate(WordprocessingMLPackage pkg, Map<String, CustomXmlPart> customXmlDataStorageParts, Map<String, Condition> conditionsMap, Map<String, Xpaths.Xpath> xpathsMap) {
        Xpaths.Xpath xpath = xpathsMap.get(this.id);
        if (log.isDebugEnabled()) {
            log.debug("Evaluating " + xpath.getDataBinding().getXpath());
        }
        String val = BindingHandler.xpathGetString(pkg, customXmlDataStorageParts, xpath.getDataBinding().getStoreItemID(), xpath.getDataBinding().getXpath(), xpath.getDataBinding().getPrefixMappings());
        return Boolean.parseBoolean(val);
    }

    @Override
    public void listXPaths(List<Xpaths.Xpath> theList, Map<String, Condition> conditionsMap, Map<String, Xpaths.Xpath> xpathsMap) {
        Xpaths.Xpath xpath = xpathsMap.get(this.id);
        theList.add(xpath);
    }

    @Override
    public void mapIds(Map<String, String> xpathIdMap, Map<String, String> conditionIdMap) {
        if (xpathIdMap == null) {
            return;
        }
        String newId = xpathIdMap.get(this.getId());
        if (newId != null) {
            this.setId(newId);
        }
    }

    @Override
    public String toString(Map<String, Condition> conditionsMap, Map<String, Xpaths.Xpath> xpathsMap) {
        Xpaths.Xpath xpath = xpathsMap.get(this.id);
        return xpath.getDataBinding().getXpath();
    }

    @Override
    public Condition repeat(String xpathBase, int index, Map<String, Condition> conditionsMap, Map<String, Xpaths.Xpath> xpathsMap) {
        Xpaths.Xpath xpathObj = xpathsMap.get(this.id);
        String thisXPath = xpathObj.getDataBinding().getXpath();
        int xpathBaseIdx = thisXPath.indexOf(xpathBase);
        if (xpathBaseIdx < 0) {
            return null;
        }
        if (thisXPath.trim().startsWith("count")) {
            int pos = xpathBaseIdx + xpathBase.length();
            String tail = thisXPath.substring(pos);
            log.debug("the tail: " + tail);
            if (tail.contains("oda:repeat")) {
                log.debug("deeper repeats in count");
            } else if (tail.contains("/")) {
                log.debug("deeper bits in count");
            } else if (tail.startsWith("[")) {
                log.debug("index needs enhancement");
            } else {
                if (tail.startsWith(")")) {
                    log.debug("retaining (repeat count): " + thisXPath);
                    return null;
                }
                log.info("fallback, enhance: " + thisXPath);
            }
        }
        String newPath = XPathEnhancerParser.enhanceXPath(xpathBase, index + 1, thisXPath);
        if (log.isDebugEnabled()) {
            if (thisXPath.equals(newPath)) {
                log.debug("xpath base " + xpathBase + " enhanced NO CHANGE to " + newPath);
            } else {
                log.debug("xpath " + thisXPath + " enhanced to " + newPath + " using xpath base " + xpathBase);
            }
        }
        Xpaths.Xpath newXPathObj = this.createNewXPathObject(xpathsMap, newPath, xpathObj, index);
        this.id = newXPathObj.getId();
        return null;
    }

    private Xpaths.Xpath createNewXPathObject(Map<String, Xpaths.Xpath> xpathsMap, String newPath, Xpaths.Xpath xpathObj, int index) {
        Xpaths.Xpath newXPathObj = new Xpaths.Xpath();
        String newXPathId = xpathObj.getId() + "_" + index;
        newXPathObj.setId(newXPathId);
        Xpaths.Xpath.DataBinding dataBinding = new Xpaths.Xpath.DataBinding();
        newXPathObj.setDataBinding(dataBinding);
        dataBinding.setXpath(newPath);
        dataBinding.setStoreItemID(xpathObj.getDataBinding().getStoreItemID());
        dataBinding.setPrefixMappings(xpathObj.getDataBinding().getPrefixMappings());
        Xpaths.Xpath preExistingSanity = xpathsMap.put(newXPathId, newXPathObj);
        if (preExistingSanity != null) {
            if (preExistingSanity.getDataBinding().getXpath().equals(newXPathObj.getDataBinding().getXpath())) {
                log.debug("Duplicate identical XPath being added: " + newXPathId);
            } else {
                log.error("Duplicate XPath " + newXPathId + ": \n" + newXPathObj.getDataBinding().getXpath() + " overwriting \n" + preExistingSanity.getDataBinding().getXpath());
            }
        }
        return newXPathObj;
    }
}

