/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.openxml4j.opc;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.InvalidOperationException;
import org.apache.poi.openxml4j.exceptions.NotOfficeXmlFileException;
import org.apache.poi.openxml4j.exceptions.ODFNotOfficeXmlFileException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JRuntimeException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackagePartCollection;
import org.apache.poi.openxml4j.opc.PackagePartName;
import org.apache.poi.openxml4j.opc.PackagingURIHelper;
import org.apache.poi.openxml4j.opc.TargetMode;
import org.apache.poi.openxml4j.opc.ZipPackagePart;
import org.apache.poi.openxml4j.opc.internal.FileHelper;
import org.apache.poi.openxml4j.opc.internal.MemoryPackagePart;
import org.apache.poi.openxml4j.opc.internal.PartMarshaller;
import org.apache.poi.openxml4j.opc.internal.ZipContentTypeManager;
import org.apache.poi.openxml4j.opc.internal.ZipHelper;
import org.apache.poi.openxml4j.opc.internal.marshallers.ZipPartMarshaller;
import org.apache.poi.openxml4j.util.ZipEntrySource;
import org.apache.poi.openxml4j.util.ZipFileZipEntrySource;
import org.apache.poi.openxml4j.util.ZipInputStreamZipEntrySource;
import org.apache.poi.openxml4j.util.ZipSecureFile;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;
import org.apache.poi.util.TempFile;

public final class ZipPackage
extends OPCPackage {
    private static final String MIMETYPE = "mimetype";
    private static final String SETTINGS_XML = "settings.xml";
    private static final POILogger LOG = POILogFactory.getLogger(ZipPackage.class);
    private final ZipEntrySource zipArchive;

    public ZipPackage() {
        super(defaultPackageAccess);
        this.zipArchive = null;
        try {
            this.contentTypeManager = new ZipContentTypeManager(null, this);
        }
        catch (InvalidFormatException e) {
            LOG.log(5, new Object[]{"Could not parse ZipPackage", e});
        }
    }

    ZipPackage(InputStream in, PackageAccess access) throws IOException {
        super(access);
        ZipSecureFile.ThresholdInputStream zis = ZipHelper.openZipStream(in);
        try {
            this.zipArchive = new ZipInputStreamZipEntrySource(zis);
        }
        catch (IOException e) {
            IOUtils.closeQuietly((Closeable)zis);
            throw new IOException("Failed to read zip entry source", e);
        }
    }

    ZipPackage(String path, PackageAccess access) throws InvalidOperationException {
        this(new File(path), access);
    }

    ZipPackage(File file, PackageAccess access) throws InvalidOperationException {
        super(access);
        ZipEntrySource ze;
        try {
            ZipFile zipFile = ZipHelper.openZipFile(file);
            ze = new ZipFileZipEntrySource(zipFile);
        }
        catch (IOException e) {
            if (access == PackageAccess.WRITE) {
                throw new InvalidOperationException("Can't open the specified file: '" + file + "'", e);
            }
            LOG.log(7, new Object[]{"Error in zip file " + file + " - falling back to stream processing (i.e. ignoring zip central directory)"});
            ze = ZipPackage.openZipEntrySourceStream(file);
        }
        this.zipArchive = ze;
    }

    private static ZipEntrySource openZipEntrySourceStream(File file) throws InvalidOperationException {
        FileInputStream fis;
        try {
            fis = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new InvalidOperationException("Can't open the specified file input stream from file: '" + file + "'", e);
        }
        try {
            return ZipPackage.openZipEntrySourceStream(fis);
        }
        catch (Exception e) {
            IOUtils.closeQuietly((Closeable)fis);
            if (e instanceof InvalidOperationException) {
                throw (InvalidOperationException)e;
            }
            throw new InvalidOperationException("Failed to read the file input stream from file: '" + file + "'", e);
        }
    }

    private static ZipEntrySource openZipEntrySourceStream(FileInputStream fis) throws InvalidOperationException {
        ZipSecureFile.ThresholdInputStream zis;
        try {
            zis = ZipHelper.openZipStream(fis);
        }
        catch (IOException e) {
            throw new InvalidOperationException("Could not open the file input stream", e);
        }
        try {
            return ZipPackage.openZipEntrySourceStream(zis);
        }
        catch (Exception e) {
            IOUtils.closeQuietly((Closeable)zis);
            if (e instanceof InvalidOperationException) {
                throw (InvalidOperationException)e;
            }
            throw new InvalidOperationException("Failed to read the zip entry source stream", e);
        }
    }

    private static ZipEntrySource openZipEntrySourceStream(ZipSecureFile.ThresholdInputStream zis) throws InvalidOperationException {
        try {
            return new ZipInputStreamZipEntrySource(zis);
        }
        catch (IOException e) {
            throw new InvalidOperationException("Could not open the specified zip entry source stream", e);
        }
    }

    ZipPackage(ZipEntrySource zipEntry, PackageAccess access) {
        super(access);
        this.zipArchive = zipEntry;
    }

    @Override
    protected PackagePart[] getPartsImpl() throws InvalidFormatException {
        ZipPackagePart part;
        String contentType;
        PackagePartName partName;
        ZipEntry entry;
        if (this.partList == null) {
            this.partList = new PackagePartCollection();
        }
        if (this.zipArchive == null) {
            return this.partList.sortedValues().toArray(new PackagePart[this.partList.size()]);
        }
        Enumeration<? extends ZipEntry> entries = this.zipArchive.getEntries();
        while (entries.hasMoreElements()) {
            entry = entries.nextElement();
            if (!entry.getName().equalsIgnoreCase("[Content_Types].xml")) continue;
            try {
                this.contentTypeManager = new ZipContentTypeManager(this.getZipArchive().getInputStream(entry), this);
                break;
            }
            catch (IOException e) {
                throw new InvalidFormatException(e.getMessage(), e);
            }
        }
        if (this.contentTypeManager == null) {
            int numEntries = 0;
            boolean hasMimetype = false;
            boolean hasSettingsXML = false;
            entries = this.zipArchive.getEntries();
            while (entries.hasMoreElements()) {
                ZipEntry entry2 = entries.nextElement();
                String name = entry2.getName();
                if (MIMETYPE.equals(name)) {
                    hasMimetype = true;
                }
                if (SETTINGS_XML.equals(name)) {
                    hasSettingsXML = true;
                }
                ++numEntries;
            }
            if (hasMimetype && hasSettingsXML) {
                throw new ODFNotOfficeXmlFileException("The supplied data appears to be in ODF (Open Document) Format. Formats like these (eg ODS, ODP) are not supported, try Apache ODFToolkit");
            }
            if (numEntries == 0) {
                throw new NotOfficeXmlFileException("No valid entries or contents found, this is not a valid OOXML (Office Open XML) file");
            }
            throw new InvalidFormatException("Package should contain a content type part [M1.13]");
        }
        entries = this.zipArchive.getEntries();
        while (entries.hasMoreElements()) {
            entry = entries.nextElement();
            partName = this.buildPartName(entry);
            if (partName == null || (contentType = this.contentTypeManager.getContentType(partName)) == null || !contentType.equals("application/vnd.openxmlformats-package.relationships+xml")) continue;
            try {
                part = new ZipPackagePart((OPCPackage)this, entry, partName, contentType);
                this.partList.put(partName, part);
            }
            catch (InvalidOperationException e) {
                throw new InvalidFormatException(e.getMessage(), e);
            }
        }
        entries = this.zipArchive.getEntries();
        while (entries.hasMoreElements()) {
            entry = entries.nextElement();
            partName = this.buildPartName(entry);
            if (partName == null || (contentType = this.contentTypeManager.getContentType(partName)) != null && contentType.equals("application/vnd.openxmlformats-package.relationships+xml")) continue;
            if (contentType != null) {
                try {
                    part = new ZipPackagePart((OPCPackage)this, entry, partName, contentType);
                    this.partList.put(partName, part);
                    continue;
                }
                catch (InvalidOperationException e) {
                    throw new InvalidFormatException(e.getMessage(), e);
                }
            }
            throw new InvalidFormatException("The part " + partName.getURI().getPath() + " does not have any content type ! Rule: Package require content types when retrieving a part from a package. [M.1.14]");
        }
        return this.partList.sortedValues().toArray(new PackagePart[this.partList.size()]);
    }

    private PackagePartName buildPartName(ZipEntry entry) {
        try {
            if (entry.getName().equalsIgnoreCase("[Content_Types].xml")) {
                return null;
            }
            return PackagingURIHelper.createPartName(ZipHelper.getOPCNameFromZipItemName(entry.getName()));
        }
        catch (Exception e) {
            LOG.log(5, new Object[]{"Entry " + entry.getName() + " is not valid, so this part won't be add to the package.", e});
            return null;
        }
    }

    @Override
    protected PackagePart createPartImpl(PackagePartName partName, String contentType, boolean loadRelationships) {
        if (contentType == null) {
            throw new IllegalArgumentException("contentType");
        }
        if (partName == null) {
            throw new IllegalArgumentException("partName");
        }
        try {
            return new MemoryPackagePart((OPCPackage)this, partName, contentType, loadRelationships);
        }
        catch (InvalidFormatException e) {
            LOG.log(5, new Object[]{e});
            return null;
        }
    }

    @Override
    protected void removePartImpl(PackagePartName partName) {
        if (partName == null) {
            throw new IllegalArgumentException("partUri");
        }
    }

    @Override
    protected void flushImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void closeImpl() throws IOException {
        this.flush();
        if (this.originalPackagePath == null || "".equals(this.originalPackagePath)) {
            return;
        }
        File targetFile = new File(this.originalPackagePath);
        if (!targetFile.exists()) {
            throw new InvalidOperationException("Can't close a package not previously open with the open() method !");
        }
        String tempFileName = this.generateTempFileName(FileHelper.getDirectory(targetFile));
        File tempFile = TempFile.createTempFile((String)tempFileName, (String)".tmp");
        try {
            this.save(tempFile);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((Closeable)this.zipArchive);
            try {
                FileHelper.copyFile(tempFile, targetFile);
                if (tempFile.delete()) throw throwable;
            }
            catch (Throwable throwable2) {
                if (tempFile.delete()) throw throwable2;
                LOG.log(5, new Object[]{"The temporary file: '" + targetFile.getAbsolutePath() + "' cannot be deleted ! Make sure that no other application use it."});
                throw throwable2;
            }
            LOG.log(5, new Object[]{"The temporary file: '" + targetFile.getAbsolutePath() + "' cannot be deleted ! Make sure that no other application use it."});
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)this.zipArchive);
        try {
            FileHelper.copyFile(tempFile, targetFile);
            if (tempFile.delete()) return;
        }
        catch (Throwable throwable) {
            if (tempFile.delete()) throw throwable;
            LOG.log(5, new Object[]{"The temporary file: '" + targetFile.getAbsolutePath() + "' cannot be deleted ! Make sure that no other application use it."});
            throw throwable;
        }
        LOG.log(5, new Object[]{"The temporary file: '" + targetFile.getAbsolutePath() + "' cannot be deleted ! Make sure that no other application use it."});
    }

    private synchronized String generateTempFileName(File directory) {
        File tmpFilename;
        while ((tmpFilename = new File(directory.getAbsoluteFile() + File.separator + "OpenXML4J" + System.nanoTime())).exists()) {
        }
        return FileHelper.getFilename(tmpFilename.getAbsoluteFile());
    }

    @Override
    protected void revertImpl() {
        try {
            if (this.zipArchive != null) {
                this.zipArchive.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    protected PackagePart getPartImpl(PackagePartName partName) {
        if (this.partList.containsKey(partName)) {
            return this.partList.get(partName);
        }
        return null;
    }

    @Override
    public void saveImpl(OutputStream outputStream) {
        this.throwExceptionIfReadOnly();
        try {
            ZipOutputStream zos = !(outputStream instanceof ZipOutputStream) ? new ZipOutputStream(outputStream) : (ZipOutputStream)outputStream;
            if (this.getPartsByRelationshipType("http://schemas.openxmlformats.org/package/2006/relationships/metadata/core-properties").size() == 0 && this.getPartsByRelationshipType("http://schemas.openxmlformats.org/officedocument/2006/relationships/metadata/core-properties").size() == 0) {
                LOG.log(1, new Object[]{"Save core properties part"});
                this.getPackageProperties();
                this.addPackagePart(this.packageProperties);
                this.relationships.addRelationship(this.packageProperties.getPartName().getURI(), TargetMode.INTERNAL, "http://schemas.openxmlformats.org/package/2006/relationships/metadata/core-properties", null);
                if (!this.contentTypeManager.isContentTypeRegister("application/vnd.openxmlformats-package.core-properties+xml")) {
                    this.contentTypeManager.addContentType(this.packageProperties.getPartName(), "application/vnd.openxmlformats-package.core-properties+xml");
                }
            }
            LOG.log(1, new Object[]{"Save package relationships"});
            ZipPartMarshaller.marshallRelationshipPart(this.getRelationships(), PackagingURIHelper.PACKAGE_RELATIONSHIPS_ROOT_PART_NAME, zos);
            LOG.log(1, new Object[]{"Save content types part"});
            this.contentTypeManager.save(zos);
            for (PackagePart part : this.getParts()) {
                if (part.isRelationshipPart()) continue;
                PackagePartName ppn = part.getPartName();
                LOG.log(1, new Object[]{"Save part '" + ZipHelper.getZipItemNameFromOPCName(ppn.getName()) + "'"});
                PartMarshaller marshaller = (PartMarshaller)this.partMarshallers.get(part._contentType);
                String errMsg = "The part " + ppn.getURI() + " failed to be saved in the stream with marshaller ";
                if (marshaller != null) {
                    if (marshaller.marshall(part, zos)) continue;
                    throw new OpenXML4JException(errMsg + marshaller);
                }
                if (this.defaultPartMarshaller.marshall(part, zos)) continue;
                throw new OpenXML4JException(errMsg + this.defaultPartMarshaller);
            }
            zos.close();
        }
        catch (OpenXML4JRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OpenXML4JRuntimeException("Fail to save: an error occurs while saving the package : " + e.getMessage(), e);
        }
    }

    public ZipEntrySource getZipArchive() {
        return this.zipArchive;
    }
}

