/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.fonts.fop.fonts;

import java.util.List;
import org.docx4j.fonts.fop.apps.io.InternalResourceResolver;
import org.docx4j.fonts.fop.fonts.EmbedFontInfo;
import org.docx4j.fonts.fop.fonts.FontCollection;
import org.docx4j.fonts.fop.fonts.FontInfo;
import org.docx4j.fonts.fop.fonts.FontTriplet;
import org.docx4j.fonts.fop.fonts.LazyFont;

public class CustomFontCollection
implements FontCollection {
    private final List<EmbedFontInfo> embedFontInfoList;
    private final InternalResourceResolver uriResolver;
    private final boolean useComplexScripts;

    public CustomFontCollection(InternalResourceResolver fontResolver, List<EmbedFontInfo> customFonts, boolean useComplexScriptFeatures) {
        this.uriResolver = fontResolver;
        this.embedFontInfoList = customFonts;
        this.useComplexScripts = useComplexScriptFeatures;
    }

    @Override
    public int setup(int num, FontInfo fontInfo) {
        if (this.embedFontInfoList == null) {
            return num;
        }
        String internalName = null;
        for (EmbedFontInfo embedFontInfo : this.embedFontInfoList) {
            internalName = "F" + num;
            ++num;
            LazyFont font = new LazyFont(embedFontInfo, this.uriResolver, this.useComplexScripts);
            fontInfo.addMetrics(internalName, font);
            List<FontTriplet> triplets = embedFontInfo.getFontTriplets();
            for (FontTriplet triplet : triplets) {
                fontInfo.addFontProperties(internalName, triplet);
            }
        }
        return num;
    }
}

