/*
 * Decompiled with CFR 0.152.
 */
package org.grails.orm.hibernate.support;

import javax.sql.DataSource;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.MetaDataAccessException;
import org.springframework.jdbc.support.lob.DefaultLobHandler;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.jdbc.support.lob.OracleLobHandler;
import org.springframework.jdbc.support.nativejdbc.CommonsDbcpNativeJdbcExtractor;
import org.springframework.jdbc.support.nativejdbc.NativeJdbcExtractor;
import org.springframework.util.Assert;

public class SpringLobHandlerDetectorFactoryBean
implements FactoryBean<LobHandler>,
InitializingBean {
    private static final String ORACLE_DB_NAME = "Oracle";
    private DataSource dataSource;
    private LobHandler lobHandler;
    private boolean pooledConnection;
    private NativeJdbcExtractor nativeJdbcExtractor = new CommonsDbcpNativeJdbcExtractor();

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setNativeJdbcExtractor(NativeJdbcExtractor nativeJdbcExtractor) {
        this.nativeJdbcExtractor = nativeJdbcExtractor;
    }

    public void setPooledConnection(boolean pooledConnection) {
        this.pooledConnection = pooledConnection;
    }

    public LobHandler getObject() {
        return this.lobHandler;
    }

    public Class<LobHandler> getObjectType() {
        return LobHandler.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws MetaDataAccessException {
        Assert.notNull((Object)this.dataSource, (String)"Data source is not set!");
        String dbName = (String)JdbcUtils.extractDatabaseMetaData((DataSource)this.dataSource, (String)"getDatabaseProductName");
        if (ORACLE_DB_NAME.equals(dbName)) {
            OracleLobHandler oracleLobHandler = new OracleLobHandler();
            this.lobHandler = oracleLobHandler;
            if (this.pooledConnection) {
                oracleLobHandler.setNativeJdbcExtractor(this.nativeJdbcExtractor);
            }
        } else {
            this.lobHandler = new DefaultLobHandler();
        }
    }
}

