/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.procedure.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Parameter;
import org.hibernate.QueryParameterException;
import org.hibernate.query.ParameterMetadata;
import org.hibernate.query.QueryParameter;
import org.hibernate.query.procedure.ProcedureParameter;
import org.hibernate.query.procedure.spi.ProcedureParameterImplementor;

public class ProcedureParameterMetadata
implements ParameterMetadata {
    private List<ProcedureParameterImplementor> parameters = new ArrayList<ProcedureParameterImplementor>();
    private boolean hasNamed;
    private int ordinalParamCount;

    public void registerParameter(ProcedureParameterImplementor parameter) {
        if (this.parameters == null) {
            this.parameters = new ArrayList<ProcedureParameterImplementor>();
        }
        this.parameters.add(parameter);
        boolean bl = this.hasNamed = this.hasNamed || parameter.getName() != null;
        if (parameter.getPosition() != null) {
            ++this.ordinalParamCount;
        }
    }

    @Override
    public boolean hasNamedParameters() {
        return this.hasNamed;
    }

    @Override
    public boolean hasPositionalParameters() {
        return this.ordinalParamCount > 0;
    }

    @Override
    public Set<QueryParameter<?>> collectAllParameters() {
        HashSet rtn = new HashSet();
        for (ProcedureParameter procedureParameter : this.parameters) {
            rtn.add(procedureParameter);
        }
        return rtn;
    }

    @Override
    public Set<Parameter<?>> collectAllParametersJpa() {
        HashSet rtn = new HashSet();
        for (ProcedureParameter procedureParameter : this.parameters) {
            rtn.add(procedureParameter);
        }
        return rtn;
    }

    @Override
    public Set<String> getNamedParameterNames() {
        if (!this.hasNamed) {
            return Collections.emptySet();
        }
        HashSet<String> rtn = new HashSet<String>();
        for (ProcedureParameter procedureParameter : this.parameters) {
            if (procedureParameter.getName() == null) continue;
            rtn.add(procedureParameter.getName());
        }
        return rtn;
    }

    @Override
    public int getPositionalParameterCount() {
        return this.ordinalParamCount;
    }

    @Override
    public <T> QueryParameter<T> getQueryParameter(String name) {
        assert (name != null);
        ProcedureParameter result = null;
        if (this.hasNamed) {
            for (ProcedureParameter procedureParameter : this.parameters) {
                if (!name.equals(procedureParameter.getName())) continue;
                result = procedureParameter;
                break;
            }
        }
        if (result != null) {
            return result;
        }
        throw new QueryParameterException("could not locate named parameter [" + name + "]");
    }

    @Override
    public <T> QueryParameter<T> getQueryParameter(Integer position) {
        assert (position != null);
        if (this.ordinalParamCount > 0) {
            for (ProcedureParameter procedureParameter : this.parameters) {
                if (procedureParameter.getPosition() == null || position.intValue() != procedureParameter.getPosition().intValue()) continue;
                return procedureParameter;
            }
        }
        throw new QueryParameterException("could not locate parameter at position [" + position + "]");
    }

    @Override
    public <T> QueryParameter<T> resolve(Parameter<T> param) {
        for (ProcedureParameter procedureParameter : this.parameters) {
            if (procedureParameter != param) continue;
            return procedureParameter;
        }
        if (param.getPosition() != null || param.getName() != null) {
            for (ProcedureParameter procedureParameter : this.parameters) {
                if (param.getName() != null && param.getName().equals(procedureParameter.getName())) {
                    return procedureParameter;
                }
                if (param.getPosition() == null || !param.getPosition().equals(procedureParameter.getPosition())) continue;
                return procedureParameter;
            }
        }
        return null;
    }
}

