/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.datastorage;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.docx4j.TraversalUtil;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.model.datastorage.CustomXmlDataStoragePartSelector;
import org.docx4j.model.datastorage.DocxFetcher;
import org.docx4j.model.datastorage.OpenDoPEHandler;
import org.docx4j.model.sdt.QueryString;
import org.docx4j.openpackaging.contenttype.ContentType;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.CustomXmlDataStoragePart;
import org.docx4j.openpackaging.parts.CustomXmlPart;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.WordprocessingML.AlternativeFormatInputPart;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.openpackaging.parts.opendope.ComponentsPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.docx4j.wml.Body;
import org.docx4j.wml.CTAltChunk;
import org.docx4j.wml.Document;
import org.docx4j.wml.Id;
import org.docx4j.wml.SdtElement;
import org.docx4j.wml.SdtPr;
import org.docx4j.wml.Tag;
import org.opendope.components.Components;
import org.opendope.conditions.Condition;
import org.opendope.conditions.Conditions;
import org.opendope.xpaths.Xpaths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class OpenDoPEHandlerComponents {
    private static Logger log = LoggerFactory.getLogger(OpenDoPEHandlerComponents.class);
    private WordprocessingMLPackage srcPackage;
    protected boolean justGotAComponent = false;
    private Components components;
    private Map<String, Xpaths.Xpath> xpathsMap = null;
    private Map<String, Condition> conditionsMap = null;
    private static DocxFetcher docxFetcher;
    Map<String, String> altChunkXPathContexts = new HashMap<String, String>();

    public static DocxFetcher getDocxFetcher() {
        return docxFetcher;
    }

    public static void setDocxFetcher(DocxFetcher docxFetcher) {
        OpenDoPEHandlerComponents.docxFetcher = docxFetcher;
    }

    public OpenDoPEHandlerComponents(WordprocessingMLPackage wordMLPackage) throws Docx4JException {
        this.srcPackage = wordMLPackage;
        if (wordMLPackage.getMainDocumentPart().getXPathsPart() == null) {
            log.info("OpenDoPE XPaths part missing (ok if you are just processing w15 repeatingSection)");
            return;
        }
        Xpaths xPaths = (Xpaths)wordMLPackage.getMainDocumentPart().getXPathsPart().getJaxbElement();
        if (log.isDebugEnabled()) {
            log.debug(XmlUtils.marshaltoString((Object)xPaths, true, true));
        }
        this.xpathsMap = new HashMap<String, Xpaths.Xpath>(2 * xPaths.getXpath().size());
        for (Xpaths.Xpath xp : xPaths.getXpath()) {
            if (this.xpathsMap.put(xp.getId(), xp) == null) continue;
            log.error("Duplicates in XPaths part: " + xp.getId());
        }
        if (wordMLPackage.getMainDocumentPart().getConditionsPart() != null) {
            Conditions conditions = (Conditions)wordMLPackage.getMainDocumentPart().getConditionsPart().getJaxbElement();
            if (log.isDebugEnabled()) {
                log.debug(XmlUtils.marshaltoString((Object)conditions, true, true));
            }
            this.conditionsMap = new HashMap<String, Condition>(2 * conditions.getCondition().size());
            for (Condition c : conditions.getCondition()) {
                if (this.conditionsMap.put(c.getId(), c) == null) continue;
                log.error("Duplicates in Conditions part: " + c.getId());
            }
        }
        if (wordMLPackage.getMainDocumentPart().getComponentsPart() != null) {
            this.components = (Components)wordMLPackage.getMainDocumentPart().getComponentsPart().getJaxbElement();
            if (log.isDebugEnabled()) {
                log.debug(XmlUtils.marshaltoString((Object)this.components, true, true));
            }
        }
    }

    public WordprocessingMLPackage fetchComponents() throws Docx4JException {
        if (this.xpathsMap == null) {
            return this.srcPackage;
        }
        this.justGotAComponent = false;
        MainDocumentPart part = this.srcPackage.getMainDocumentPart();
        FindComponentsTraversor t = new FindComponentsTraversor();
        t.wordMLPackage = this.srcPackage;
        if (part instanceof MainDocumentPart) {
            Body b = ((Document)part.getJaxbElement()).getBody();
            t.walkJAXBElements(b);
        } else {
            t.walkJAXBElements(part.getContent());
        }
        if (!this.justGotAComponent) {
            return this.srcPackage;
        }
        HashMap<QName, CustomXmlPart> answerDomDocs = new HashMap<QName, CustomXmlPart>();
        CustomXmlPart data = CustomXmlDataStoragePartSelector.getCustomXmlDataStoragePart(this.srcPackage);
        if (!(data instanceof CustomXmlDataStoragePart)) {
            throw new Docx4JException("TODO: handle " + data.getClass().getName());
        }
        org.w3c.dom.Document doc = ((CustomXmlDataStoragePart)data).getData().getDocument();
        answerDomDocs.put(this.getQName(doc.getDocumentElement()), data);
        try {
            Class<?> documentBuilder = Class.forName("com.plutext.merge.altchunk.ProcessAltChunk");
            Method[] methods = documentBuilder.getMethods();
            Method processMethod = null;
            for (int j = 0; j < methods.length; ++j) {
                if (!methods[j].getName().equals("process") || methods[j].getParameterCount() != 5) continue;
                processMethod = methods[j];
            }
            if (processMethod == null) {
                throw new NoSuchMethodException();
            }
            return (WordprocessingMLPackage)processMethod.invoke(null, this.srcPackage, answerDomDocs, this.xpathsMap, this.conditionsMap, this.altChunkXPathContexts);
        }
        catch (ClassNotFoundException e) {
            this.extensionMissing(e);
            return this.srcPackage;
        }
        catch (NoSuchMethodException e) {
            this.extensionMissing(e);
            return this.srcPackage;
        }
        catch (Exception e) {
            throw new Docx4JException("Problem processing w:altChunk", e);
        }
    }

    private QName getQName(Element el) {
        QName qname = new QName(el.getNamespaceURI(), el.getLocalName());
        System.out.println(qname);
        return qname;
    }

    public void extensionMissing(Exception e) {
        log.error("\n" + e.getClass().getName() + ": " + e.getMessage() + "\n");
        log.error("* You don't appear to have the MergeDocx paid extension,");
        log.error("* which is necessary to merge docx, or process altChunk.");
        log.error("* Purchases of this extension support the docx4j project.");
        log.error("* Please visit www.plutext.com if you want to buy it.");
    }

    private PartName getNewPartName(String prefix, String suffix, RelationshipsPart rp) throws InvalidFormatException {
        PartName proposed = null;
        int i = 1;
        do {
            proposed = i > 1 ? new PartName(prefix + i + suffix) : new PartName(prefix + suffix);
            ++i;
        } while (rp.getRel(proposed) != null);
        return proposed;
    }

    private class FindComponentsTraversor
    extends TraversalUtil.CallbackImpl {
        WordprocessingMLPackage wordMLPackage;
        private LinkedList<String> repeatContext = new LinkedList();

        private FindComponentsTraversor() {
        }

        @Override
        public List<Object> apply(Object wrapped) throws RuntimeException {
            SdtPr sdtPr;
            Object o = XmlUtils.unwrap(wrapped);
            if (o instanceof SdtElement && (sdtPr = OpenDoPEHandler.getSdtPr(o)).getDataBinding() == null) {
                try {
                    return this.processBindingRoleIfAny(this.wordMLPackage, (SdtElement)o);
                }
                catch (Docx4JException e) {
                    throw new RuntimeException(e);
                }
            }
            ArrayList<Object> newContent = new ArrayList<Object>();
            newContent.add(wrapped);
            return newContent;
        }

        @Override
        public void walkJAXBElements(Object parent) {
            List<Object> children;
            ArrayList<Object> newChildren = new ArrayList<Object>();
            Object parentUnwrapped = XmlUtils.unwrap(parent);
            boolean mustPopRepeat = false;
            if (parentUnwrapped instanceof SdtElement) {
                Tag tag = ((SdtElement)parentUnwrapped).getSdtPr().getTag();
                if (tag == null) {
                    log.debug("no tag " + XmlUtils.marshaltoString(parentUnwrapped));
                } else {
                    HashMap<String, String> map = QueryString.parseQueryString(tag.getVal(), true);
                    String repeatId = map.get("od:repeat");
                    if (repeatId != null) {
                        this.repeatContext.push(repeatId);
                        mustPopRepeat = true;
                    }
                }
            }
            if ((children = this.getChildren(parentUnwrapped)) == null) {
                return;
            }
            for (Object o : children) {
                newChildren.addAll(this.apply(o));
            }
            TraversalUtil.replaceChildren(parentUnwrapped, newChildren);
            children = this.getChildren(parentUnwrapped);
            if (children == null) {
                log.debug("no children: " + parentUnwrapped.getClass().getName());
            } else {
                for (Object o : children) {
                    if (!this.shouldTraverse(o)) continue;
                    this.walkJAXBElements(o);
                }
            }
            if (mustPopRepeat) {
                this.repeatContext.pop();
            }
        }

        private List<Object> processBindingRoleIfAny(WordprocessingMLPackage wordMLPackage, Object sdt) throws Docx4JException {
            Tag tag;
            Id id = OpenDoPEHandler.getSdtPr(sdt).getId();
            if (id != null) {
                // empty if block
            }
            if ((tag = OpenDoPEHandler.getSdtPr(sdt).getTag()) == null) {
                ArrayList<Object> newContent = new ArrayList<Object>();
                newContent.add(sdt);
                return newContent;
            }
            log.info(tag.getVal());
            HashMap<String, String> map = QueryString.parseQueryString(tag.getVal(), true);
            String conditionId = map.get("od:condition");
            String repeatId = map.get("od:repeat");
            String componentId = map.get("od:component");
            String componentContextId = map.get("od:context");
            if (componentId == null && conditionId == null && repeatId == null) {
                ArrayList<Object> newContent = new ArrayList<Object>();
                newContent.add(sdt);
                return newContent;
            }
            HashMap<String, CustomXmlPart> customXmlDataStorageParts = wordMLPackage.getCustomXmlDataStorageParts();
            if (componentId != null) {
                OpenDoPEHandlerComponents.this.justGotAComponent = true;
                if (componentContextId != null) {
                    log.debug("Using explicit component context " + componentContextId);
                    return this.processOpenDopeComponent(wordMLPackage, componentId, componentContextId);
                }
                if (!this.repeatContext.isEmpty()) {
                    log.debug("Using component context inferred from repeat " + this.repeatContext.peek());
                    return this.processOpenDopeComponent(wordMLPackage, componentId, this.repeatContext.peek());
                }
                log.debug("No context, its just root ");
                return this.processOpenDopeComponent(wordMLPackage, componentId, null);
            }
            if (conditionId != null) {
                log.debug("Encountered Conditional: " + tag.getVal());
                ArrayList<Object> newContent = new ArrayList<Object>();
                newContent.add(sdt);
                return newContent;
            }
            if (repeatId != null) {
                log.info("Processing OpenDoPE Repeat: " + tag.getVal());
                ArrayList<Object> newContent = new ArrayList<Object>();
                newContent.add(sdt);
                return newContent;
            }
            return null;
        }

        private List<Object> processOpenDopeComponent(WordprocessingMLPackage srcPackage, String componentId, String xpathId) throws Docx4JException {
            String iri = ComponentsPart.getComponentById(OpenDoPEHandlerComponents.this.components, componentId).getIri();
            log.debug("Fetching " + iri);
            if (OpenDoPEHandlerComponents.getDocxFetcher() == null) {
                log.error("You need a docxFetcher (and the MergeDocx extension) to fetch components");
                throw new Docx4JException("You need a docxFetcher (and the MergeDocx extension) to fetch components");
            }
            AlternativeFormatInputPart afiPart = new AlternativeFormatInputPart(OpenDoPEHandlerComponents.this.getNewPartName("/chunk", ".docx", srcPackage.getMainDocumentPart().getRelationshipsPart()));
            afiPart.setBinaryData(OpenDoPEHandlerComponents.getDocxFetcher().getDocxFromIRI(iri));
            afiPart.setContentType(new ContentType("application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml"));
            Relationship altChunkRel = srcPackage.getMainDocumentPart().addTargetPart(afiPart);
            CTAltChunk ac = Context.getWmlObjectFactory().createCTAltChunk();
            ac.setId(altChunkRel.getId());
            OpenDoPEHandlerComponents.this.altChunkXPathContexts.put(altChunkRel.getId(), xpathId);
            log.debug("Using altChunkRel " + altChunkRel.getId() + " and " + xpathId);
            ArrayList<Object> newContent = new ArrayList<Object>();
            newContent.add(ac);
            return newContent;
        }
    }
}

