/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.hibernate.snapshot;

import java.util.Collection;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.ext.hibernate.database.HibernateDatabase;
import liquibase.logging.LogService;
import liquibase.logging.Logger;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.snapshot.SnapshotGenerator;
import liquibase.snapshot.SnapshotGeneratorChain;
import liquibase.structure.DatabaseObject;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.mapping.Table;

public abstract class HibernateSnapshotGenerator
implements SnapshotGenerator {
    private static final int PRIORITY_HIBERNATE_ADDITIONAL = 200;
    private static final int PRIORITY_HIBERNATE_DEFAULT = 100;
    private Class<? extends DatabaseObject> defaultFor = null;
    private Class<? extends DatabaseObject>[] addsTo = null;
    protected static final Logger LOG = LogService.getLog(HibernateSnapshotGenerator.class);

    protected HibernateSnapshotGenerator(Class<? extends DatabaseObject> defaultFor) {
        this.defaultFor = defaultFor;
    }

    protected HibernateSnapshotGenerator(Class<? extends DatabaseObject> defaultFor, Class<? extends DatabaseObject>[] addsTo) {
        this.defaultFor = defaultFor;
        this.addsTo = addsTo;
    }

    public Class<? extends SnapshotGenerator>[] replaces() {
        return null;
    }

    public final int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (database instanceof HibernateDatabase) {
            if (this.defaultFor != null && this.defaultFor.isAssignableFrom(objectType)) {
                return 100;
            }
            if (this.addsTo() != null) {
                for (Class<? extends DatabaseObject> type : this.addsTo()) {
                    if (!type.isAssignableFrom(objectType)) continue;
                    return 200;
                }
            }
        }
        return -1;
    }

    public final Class<? extends DatabaseObject>[] addsTo() {
        return this.addsTo;
    }

    public final DatabaseObject snapshot(DatabaseObject example, DatabaseSnapshot snapshot, SnapshotGeneratorChain chain) throws DatabaseException, InvalidExampleException {
        if (this.defaultFor != null && this.defaultFor.isAssignableFrom(example.getClass())) {
            DatabaseObject result = this.snapshotObject(example, snapshot);
            return result;
        }
        DatabaseObject chainResponse = chain.snapshot(example, snapshot);
        if (chainResponse == null) {
            return null;
        }
        if (this.addsTo() != null) {
            for (Class<? extends DatabaseObject> addType : this.addsTo()) {
                if (!addType.isAssignableFrom(example.getClass()) || chainResponse == null) continue;
                this.addTo(chainResponse, snapshot);
            }
        }
        return chainResponse;
    }

    protected abstract DatabaseObject snapshotObject(DatabaseObject var1, DatabaseSnapshot var2) throws DatabaseException, InvalidExampleException;

    protected abstract void addTo(DatabaseObject var1, DatabaseSnapshot var2) throws DatabaseException, InvalidExampleException;

    protected Table findHibernateTable(DatabaseObject example, DatabaseSnapshot snapshot) throws DatabaseException {
        HibernateDatabase database = (HibernateDatabase)snapshot.getDatabase();
        MetadataImplementor metadata = (MetadataImplementor)database.getMetadata();
        Collection tmapp = metadata.collectTableMappings();
        for (Table hibernateTable : tmapp) {
            if (!hibernateTable.getName().equalsIgnoreCase(example.getName())) continue;
            return hibernateTable;
        }
        return null;
    }
}

