/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.packet.dao.parameters;

import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.mariadb.jdbc.internal.MariaDbType;
import org.mariadb.jdbc.internal.packet.dao.parameters.NotLongDataParameter;
import org.mariadb.jdbc.internal.stream.PacketOutputStream;
import org.mariadb.jdbc.internal.util.Options;

public class DateParameter
extends NotLongDataParameter
implements Cloneable {
    private Date date;
    private Calendar calendar;
    private Options options;

    public DateParameter(Date date, Calendar cal, Options options) {
        this.date = date;
        this.calendar = cal;
        this.options = options;
    }

    @Override
    public void writeTo(PacketOutputStream os) {
        os.write(39);
        os.write(this.dateByteFormat());
        os.write(39);
    }

    @Override
    public void writeUnsafeTo(PacketOutputStream os) {
        os.writeUnsafe(39);
        os.writeUnsafe(this.dateByteFormat());
        os.writeUnsafe(39);
    }

    private byte[] dateByteFormat() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(this.calendar().getTime()).getBytes();
    }

    private Calendar calendar() {
        if (this.options.useLegacyDatetimeCode || this.options.maximizeMysqlCompatibility) {
            this.calendar = Calendar.getInstance();
        }
        this.calendar.setTimeInMillis(this.date.getTime());
        return this.calendar;
    }

    @Override
    public long getApproximateTextProtocolLength() {
        return 16L;
    }

    @Override
    public void writeBinary(PacketOutputStream writeBuffer) {
        this.calendar = Calendar.getInstance();
        this.calendar.setTimeInMillis(this.date.getTime());
        writeBuffer.writeDateLength(this.calendar);
    }

    @Override
    public MariaDbType getMariaDbType() {
        return MariaDbType.DATE;
    }

    @Override
    public String toString() {
        return "'" + this.date.toString() + "'";
    }
}

