/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.hibernate.diff;

import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.ext.hibernate.database.HibernateDatabase;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Sequence;

public class MissingSequenceChangeGenerator
extends liquibase.diff.output.changelog.core.MissingSequenceChangeGenerator {
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (Sequence.class.isAssignableFrom(objectType)) {
            return 50;
        }
        return -1;
    }

    public Change[] fixMissing(DatabaseObject missingObject, DiffOutputControl control, Database referenceDatabase, Database comparisonDatabase, ChangeGeneratorChain chain) {
        if (referenceDatabase instanceof HibernateDatabase && !comparisonDatabase.supportsSequences()) {
            return null;
        }
        if (comparisonDatabase instanceof HibernateDatabase && !referenceDatabase.supportsSequences()) {
            return null;
        }
        return super.fixMissing(missingObject, control, referenceDatabase, comparisonDatabase, chain);
    }
}

