/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.poi.xwpf.converter.core.styles.run;

import fr.opensagres.poi.xwpf.converter.core.styles.XWPFStylesDocument;
import fr.opensagres.poi.xwpf.converter.core.styles.run.AbstractRunValueProvider;
import java.util.List;
import org.openxmlformats.schemas.drawingml.x2006.main.CTFontCollection;
import org.openxmlformats.schemas.drawingml.x2006.main.CTFontScheme;
import org.openxmlformats.schemas.drawingml.x2006.main.ThemeDocument;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDocDefaults;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFonts;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STTheme;

public abstract class RunFontFamilyValueProvider
extends AbstractRunValueProvider<String> {
    @Override
    public String getValue(CTRPr ppr, XWPFStylesDocument stylesDocument) {
        CTFonts fonts = this.getRFonts(ppr);
        if (fonts != null) {
            return this.getFontFamily(stylesDocument, fonts);
        }
        return null;
    }

    private CTFonts getRFonts(CTRPr ppr) {
        if (ppr == null || ppr.sizeOfRFontsArray() == 0) {
            return null;
        }
        return ppr.getRFontsArray(0);
    }

    @Override
    protected String getValueFromDocDefaultsStyle(CTDocDefaults docDefaults, XWPFStylesDocument stylesDocument) {
        CTFonts fonts = this.getRFonts(this.getRPr(docDefaults));
        if (fonts != null) {
            return this.getFontFamily(stylesDocument, fonts);
        }
        return "Times New Roman";
    }

    private String getFontFamily(XWPFStylesDocument stylesDocument, CTFonts fonts) {
        STTheme.Enum asciiTheme = this.getTheme(fonts);
        if (asciiTheme != null) {
            try {
                List<ThemeDocument> themeDocuments = stylesDocument.getThemeDocuments();
                if (themeDocuments.size() > 0) {
                    for (ThemeDocument themeDocument : themeDocuments) {
                        CTFontCollection fontCollection = this.getFontCollection(themeDocument, asciiTheme);
                        if (fontCollection == null || fontCollection.getLatin() == null) continue;
                        return fontCollection.getLatin().getTypeface();
                    }
                }
                return this.getDefaultFontFamily(asciiTheme);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.getFamily(fonts);
    }

    private String getDefaultFontFamily(STTheme.Enum asciiTheme) {
        if (asciiTheme.equals(STTheme.MINOR_H_ANSI)) {
            return "Calibri";
        }
        return null;
    }

    private CTFontCollection getFontCollection(ThemeDocument themeDocument, STTheme.Enum asciiTheme) {
        CTFontScheme fontScheme = themeDocument.getTheme().getThemeElements().getFontScheme();
        if (fontScheme != null) {
            if (asciiTheme.equals(STTheme.MINOR_ASCII) || asciiTheme.equals(STTheme.MINOR_BIDI) || asciiTheme.equals(STTheme.MINOR_EAST_ASIA) || asciiTheme.equals(STTheme.MINOR_H_ANSI)) {
                return fontScheme.getMinorFont();
            }
            return fontScheme.getMajorFont();
        }
        return null;
    }

    protected abstract STTheme.Enum getTheme(CTFonts var1);

    protected abstract String getFamily(CTFonts var1);
}

