/*
 * Decompiled with CFR 0.152.
 */
package fr.w3blog.zpl.model.element;

import fr.w3blog.zpl.constant.ZebraFont;
import fr.w3blog.zpl.constant.ZebraJustification;
import fr.w3blog.zpl.constant.ZebraPPP;
import fr.w3blog.zpl.constant.ZebraRotation;
import fr.w3blog.zpl.model.PrinterOptions;
import fr.w3blog.zpl.model.ZebraElement;
import fr.w3blog.zpl.utils.ZplUtils;
import java.awt.Font;
import java.awt.Graphics2D;

public class ZebraText
extends ZebraElement<ZebraText> {
    ZebraFont zebraFont = null;
    Integer fontSize = null;
    String text;

    public ZebraText(String text) {
        this.text = text;
    }

    public ZebraText(String text, int fontSize) {
        this.fontSize = fontSize;
        this.text = text;
    }

    public ZebraText(String text, ZebraFont zebraFont, int fontSize) {
        this.zebraFont = zebraFont;
        this.fontSize = fontSize;
        this.text = text;
    }

    public ZebraText(String text, ZebraFont zebraFont, int fontSize, ZebraRotation zebraRotation) {
        this.zebraFont = zebraFont;
        this.zebraRotation = zebraRotation;
        this.fontSize = fontSize;
        this.text = text;
    }

    public ZebraText(int positionX, int positionY, String text) {
        this.text = text;
        this.positionX = positionX;
        this.positionY = positionY;
    }

    public ZebraText(int positionX, int positionY, String text, int fontSize) {
        this.fontSize = fontSize;
        this.text = text;
        this.positionX = positionX;
        this.positionY = positionY;
    }

    public ZebraText(int positionX, int positionY, String text, int fontSize, ZebraJustification justification) {
        this.fontSize = fontSize;
        this.text = text;
        this.positionX = positionX;
        this.positionY = positionY;
        this.justification = justification;
    }

    public ZebraText(int positionX, int positionY, String text, ZebraFont zebraFont, int fontSize, ZebraRotation zebraRotation) {
        this.zebraFont = zebraFont;
        this.fontSize = fontSize;
        this.zebraRotation = zebraRotation;
        this.text = text;
        this.positionX = positionX;
        this.positionY = positionY;
    }

    public ZebraText(int positionX, int positionY, String text, ZebraFont zebraFont, int fontSize) {
        this.zebraFont = zebraFont;
        this.fontSize = fontSize;
        this.text = text;
        this.positionX = positionX;
        this.positionY = positionY;
    }

    @Override
    protected ZebraText getThis() {
        return this;
    }

    @Override
    public String getZplCode(PrinterOptions printerOptions) {
        StringBuffer zpl = new StringBuffer();
        zpl.append(this.getZplCodePosition(printerOptions.getZebraPPP()));
        ZebraFont defaultZebraFont = printerOptions.getDefaultZebraFont();
        Integer defaultFontSize = printerOptions.getDefaultFontSize();
        ZebraPPP defaultZebraPPP = printerOptions.getZebraPPP();
        if (this.fontSize != null && this.zebraFont != null) {
            Integer[] dimension = ZplUtils.extractDotsFromFont(this.zebraFont, this.fontSize, defaultZebraPPP);
            zpl.append((CharSequence)ZplUtils.zplCommand("A", this.zebraFont.getLetter() + this.zebraRotation.getLetter(), dimension[0], dimension[1]));
        } else if (this.fontSize != null && defaultZebraFont != null) {
            Integer[] dimension = ZplUtils.extractDotsFromFont(defaultZebraFont, this.fontSize, defaultZebraPPP);
            zpl.append((CharSequence)ZplUtils.zplCommand("A", defaultZebraFont.getLetter() + this.zebraRotation.getLetter(), dimension[0], dimension[1]));
        } else if (defaultFontSize != null && defaultZebraFont != null) {
            Integer[] dimension = ZplUtils.extractDotsFromFont(defaultZebraFont, defaultFontSize, defaultZebraPPP);
            zpl.append((CharSequence)ZplUtils.zplCommand("A", defaultZebraFont.getLetter() + this.zebraRotation.getLetter(), dimension[0], dimension[1]));
        }
        zpl.append("^FH\\^FD");
        zpl.append(ZplUtils.convertAccentToZplAsciiHexa(this.text));
        zpl.append((CharSequence)ZplUtils.zplCommandSautLigne("FS"));
        return zpl.toString();
    }

    @Override
    public void drawPreviewGraphic(PrinterOptions printerOptions, Graphics2D graphic) {
        if (this.defaultDrawGraphic) {
            int top = 0;
            int left = 0;
            if (this.positionX != null) {
                left = ZplUtils.convertPointInPixel(this.positionX);
            }
            if (this.positionY != null) {
                top = ZplUtils.convertPointInPixel(this.positionY);
            }
            Font font = null;
            if (this.fontSize != null && this.zebraFont != null) {
                Integer[] dimension = ZplUtils.extractDotsFromFont(printerOptions.getDefaultZebraFont(), this.fontSize, printerOptions.getZebraPPP());
                font = new Font(ZebraFont.findBestEquivalentFontForPreview(this.zebraFont), 1, dimension[0]);
            } else if (this.fontSize != null && printerOptions.getDefaultZebraFont() != null) {
                Integer[] dimensionPoint = ZplUtils.extractDotsFromFont(printerOptions.getDefaultZebraFont(), this.fontSize, printerOptions.getZebraPPP());
                font = new Font(ZebraFont.findBestEquivalentFontForPreview(printerOptions.getDefaultZebraFont()), 1, Math.round((float)dimensionPoint[0].intValue() / 1.33f));
            } else {
                Integer[] dimensionPoint = ZplUtils.extractDotsFromFont(printerOptions.getDefaultZebraFont(), 15, printerOptions.getZebraPPP());
                font = new Font(ZebraFont.findBestEquivalentFontForPreview(ZebraFont.ZEBRA_A), 1, dimensionPoint[0]);
            }
            this.drawTopString(graphic, font, this.text, left, top);
        }
    }
}

