/*
 * Decompiled with CFR 0.152.
 */
package org.grails.orm.hibernate.query;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.FetchType;
import org.grails.datastore.gorm.finders.DynamicFinder;
import org.grails.datastore.gorm.query.criteria.DetachedAssociationCriteria;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.model.types.Association;
import org.grails.datastore.mapping.model.types.Embedded;
import org.grails.datastore.mapping.proxy.ProxyHandler;
import org.grails.datastore.mapping.query.AssociationQuery;
import org.grails.datastore.mapping.query.Query;
import org.grails.datastore.mapping.query.api.ProjectionList;
import org.grails.datastore.mapping.query.api.QueryableCriteria;
import org.grails.datastore.mapping.query.criteria.FunctionCallingCriterion;
import org.grails.datastore.mapping.query.event.PostQueryEvent;
import org.grails.datastore.mapping.query.event.PreQueryEvent;
import org.grails.orm.hibernate.AbstractHibernateSession;
import org.grails.orm.hibernate.IHibernateTemplate;
import org.grails.orm.hibernate.cfg.AbstractGrailsDomainBinder;
import org.grails.orm.hibernate.cfg.Mapping;
import org.grails.orm.hibernate.proxy.SimpleHibernateProxyHandler;
import org.grails.orm.hibernate.query.AbstractHibernateCriterionAdapter;
import org.grails.orm.hibernate.query.HibernateProjectionAdapter;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.LockMode;
import org.hibernate.NonUniqueResultException;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Junction;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.persister.entity.PropertyMapping;
import org.hibernate.sql.JoinType;
import org.hibernate.type.BasicType;
import org.hibernate.type.Type;
import org.hibernate.type.TypeResolver;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.util.ReflectionUtils;

public abstract class AbstractHibernateQuery
extends Query {
    public static final String SIZE_CONSTRAINT_PREFIX = "Size";
    protected static final String ALIAS = "_alias";
    protected static ConversionService conversionService = new DefaultConversionService();
    protected static Field opField = ReflectionUtils.findField(SimpleExpression.class, (String)"op");
    private static final Map<String, Boolean> JOIN_STATUS_CACHE = new ConcurrentHashMap<String, Boolean>();
    protected Criteria criteria;
    protected DetachedCriteria detachedCriteria;
    protected HibernateProjectionList hibernateProjectionList;
    protected String alias;
    protected int aliasCount;
    protected Map<String, CriteriaAndAlias> createdAssociationPaths = new HashMap<String, CriteriaAndAlias>();
    protected LinkedList<String> aliasStack = new LinkedList();
    protected LinkedList<PersistentEntity> entityStack = new LinkedList();
    protected LinkedList<Association> associationStack = new LinkedList();
    protected LinkedList aliasInstanceStack = new LinkedList();
    private boolean hasJoins = false;
    protected ProxyHandler proxyHandler = new SimpleHibernateProxyHandler();
    protected final AbstractHibernateCriterionAdapter abstractHibernateCriterionAdapter;

    protected AbstractHibernateQuery(Criteria criteria, AbstractHibernateSession session, PersistentEntity entity) {
        super((Session)session, entity);
        this.criteria = criteria;
        if (entity != null) {
            this.initializeJoinStatus();
        }
        this.abstractHibernateCriterionAdapter = this.createHibernateCriterionAdapter();
    }

    protected AbstractHibernateQuery(DetachedCriteria criteria, PersistentEntity entity) {
        super(null, entity);
        this.detachedCriteria = criteria;
        this.abstractHibernateCriterionAdapter = this.createHibernateCriterionAdapter();
        if (entity != null) {
            this.initializeJoinStatus();
        }
    }

    protected Object resolveIdIfEntity(Object value) {
        return value;
    }

    protected void initializeJoinStatus() {
        Boolean cachedStatus = JOIN_STATUS_CACHE.get(this.entity.getName());
        if (cachedStatus != null) {
            this.hasJoins = cachedStatus;
        } else {
            for (Association a : this.entity.getAssociations()) {
                if (a.getFetchStrategy() != FetchType.EAGER) continue;
                this.hasJoins = true;
            }
        }
    }

    protected AbstractHibernateQuery(Criteria subCriteria, AbstractHibernateSession session, PersistentEntity associatedEntity, String newAlias) {
        this(subCriteria, session, associatedEntity);
        this.alias = newAlias;
    }

    public Query isEmpty(String property) {
        Criterion criterion = Restrictions.isEmpty((String)this.calculatePropertyName(property));
        this.addToCriteria(criterion);
        return this;
    }

    public Query isNotEmpty(String property) {
        this.addToCriteria(Restrictions.isNotEmpty((String)this.calculatePropertyName(property)));
        return this;
    }

    public Query isNull(String property) {
        this.addToCriteria(Restrictions.isNull((String)this.calculatePropertyName(property)));
        return this;
    }

    public Query isNotNull(String property) {
        this.addToCriteria(Restrictions.isNotNull((String)this.calculatePropertyName(property)));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Query.Criterion criterion) {
        if (criterion instanceof FunctionCallingCriterion) {
            Criterion sqlRestriction = this.getRestrictionForFunctionCall((FunctionCallingCriterion)criterion, this.getEntity());
            if (sqlRestriction != null) {
                this.addToCriteria(sqlRestriction);
            }
        } else if (criterion instanceof Query.PropertyCriterion) {
            Query.PropertyCriterion pc = (Query.PropertyCriterion)criterion;
            Object value = pc.getValue();
            if (value instanceof QueryableCriteria) {
                this.setDetachedCriteriaValue((QueryableCriteria)value, pc);
            } else {
                AbstractHibernateQuery.doTypeConversionIfNeccessary(this.getEntity(), pc);
            }
        }
        if (criterion instanceof DetachedAssociationCriteria) {
            DetachedAssociationCriteria associationCriteria = (DetachedAssociationCriteria)criterion;
            Association association = associationCriteria.getAssociation();
            List criteria = associationCriteria.getCriteria();
            if (association instanceof Embedded) {
                String associationName = association.getName();
                if (this.getCurrentAlias() != null) {
                    associationName = this.getCurrentAlias() + '.' + associationName;
                }
                for (Query.Criterion c : criteria) {
                    Criterion hibernateCriterion = this.getHibernateCriterionAdapter().toHibernateCriterion(this, c, associationName);
                    if (hibernateCriterion == null) continue;
                    this.addToCriteria(hibernateCriterion);
                }
            } else {
                CriteriaAndAlias criteriaAndAlias = this.getCriteriaAndAlias(associationCriteria);
                if (criteriaAndAlias.criteria != null) {
                    this.aliasInstanceStack.add(criteriaAndAlias.criteria);
                } else if (criteriaAndAlias.detachedCriteria != null) {
                    this.aliasInstanceStack.add(criteriaAndAlias.detachedCriteria);
                }
                this.aliasStack.add(criteriaAndAlias.alias);
                this.associationStack.add(association);
                this.entityStack.add(association.getAssociatedEntity());
                try {
                    List associationCriteriaList = criteria;
                    for (Query.Criterion c : associationCriteriaList) {
                        this.add(c);
                    }
                }
                finally {
                    this.aliasInstanceStack.removeLast();
                    this.aliasStack.removeLast();
                    this.entityStack.removeLast();
                    this.associationStack.removeLast();
                }
            }
        } else {
            Criterion hibernateCriterion = this.getHibernateCriterionAdapter().toHibernateCriterion(this, criterion, this.getCurrentAlias());
            if (hibernateCriterion != null) {
                this.addToCriteria(hibernateCriterion);
            }
        }
    }

    public PersistentEntity getEntity() {
        if (!this.entityStack.isEmpty()) {
            return this.entityStack.getLast();
        }
        return super.getEntity();
    }

    protected String getAssociationPath(String propertyName) {
        if (propertyName.indexOf(46) > -1) {
            return propertyName;
        }
        StringBuilder fullPath = new StringBuilder();
        for (Association association : this.associationStack) {
            fullPath.append(association.getName());
            fullPath.append('.');
        }
        fullPath.append(propertyName);
        return fullPath.toString();
    }

    protected String getCurrentAlias() {
        if (this.alias != null) {
            return this.alias;
        }
        if (this.aliasStack.isEmpty()) {
            return null;
        }
        return this.aliasStack.getLast();
    }

    static void doTypeConversionIfNeccessary(PersistentEntity entity, Query.PropertyCriterion pc) {
        if (pc.getClass().getSimpleName().startsWith(SIZE_CONSTRAINT_PREFIX)) {
            return;
        }
        String property = pc.getProperty();
        Object value = pc.getValue();
        PersistentProperty p = entity.getPropertyByName(property);
        if (p != null && !p.getType().isInstance(value)) {
            pc.setValue(conversionService.convert(value, p.getType()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Criterion getRestrictionForFunctionCall(FunctionCallingCriterion criterion, PersistentEntity entity) {
        SessionFactory sessionFactory = ((IHibernateTemplate)this.session.getNativeInterface()).getSessionFactory();
        String property = criterion.getProperty();
        Query.PropertyCriterion datastoreCriterion = criterion.getPropertyCriterion();
        PersistentProperty pp = entity.getPropertyByName(property);
        if (pp == null) {
            throw new InvalidDataAccessResourceUsageException("Cannot execute function defined in query [" + criterion.getFunctionName() + "] on non-existent property [" + property + "] of [" + entity.getJavaClass() + "]");
        }
        String functionName = criterion.getFunctionName();
        Dialect dialect = this.getDialect(sessionFactory);
        SQLFunction sqlFunction = (SQLFunction)dialect.getFunctions().get(functionName);
        if (sqlFunction == null) throw new InvalidDataAccessResourceUsageException("Unsupported function defined in query [" + functionName + "]");
        TypeResolver typeResolver = this.getTypeResolver(sessionFactory);
        BasicType basic = typeResolver.basic(pp.getType().getName());
        if (basic == null) throw new InvalidDataAccessResourceUsageException("Unsupported function [" + functionName + "] defined in query for property [" + property + "] with type [" + pp.getType() + "]");
        if (!(datastoreCriterion instanceof Query.PropertyCriterion)) throw new InvalidDataAccessResourceUsageException("Unsupported function [" + functionName + "] defined in query for property [" + property + "] with type [" + pp.getType() + "]");
        Query.PropertyCriterion pc = datastoreCriterion;
        Criterion hibernateCriterion = this.getHibernateCriterionAdapter().toHibernateCriterion(this, (Query.Criterion)datastoreCriterion, this.alias);
        if (!(hibernateCriterion instanceof SimpleExpression)) throw new InvalidDataAccessResourceUsageException("Unsupported function [" + functionName + "] defined in query for property [" + property + "] with type [" + pp.getType() + "]");
        SimpleExpression expr = (SimpleExpression)hibernateCriterion;
        Object op = ReflectionUtils.getField((Field)opField, (Object)expr);
        PropertyMapping mapping = this.getEntityPersister(entity.getJavaClass().getName(), sessionFactory);
        String[] columns = this.alias != null ? mapping.toColumns(this.alias, property) : mapping.toColumns(property);
        String root = this.render(basic, Arrays.asList(columns), sessionFactory, sqlFunction);
        Object value = pc.getValue();
        if (value == null) return Restrictions.sqlRestriction((String)(root + op + "?"), (Object)value, (Type)basic);
        return Restrictions.sqlRestriction((String)(root + op + "?"), (Object)value, (Type)typeResolver.basic(value.getClass().getName()));
    }

    protected abstract String render(BasicType var1, List<String> var2, SessionFactory var3, SQLFunction var4);

    protected abstract PropertyMapping getEntityPersister(String var1, SessionFactory var2);

    protected abstract TypeResolver getTypeResolver(SessionFactory var1);

    protected abstract Dialect getDialect(SessionFactory var1);

    public Query.Junction disjunction() {
        Disjunction disjunction = Restrictions.disjunction();
        this.addToCriteria((Criterion)disjunction);
        return new HibernateJunction((Junction)disjunction, this.alias);
    }

    public Query.Junction negation() {
        Disjunction disjunction = Restrictions.disjunction();
        this.addToCriteria(Restrictions.not((Criterion)disjunction));
        return new HibernateJunction((Junction)disjunction, this.alias);
    }

    public Query eq(String property, Object value) {
        this.addToCriteria((Criterion)Restrictions.eq((String)this.calculatePropertyName(property), (Object)value));
        return this;
    }

    public Query idEq(Object value) {
        this.addToCriteria(Restrictions.idEq((Object)value));
        return this;
    }

    public Query gt(String property, Object value) {
        this.addToCriteria((Criterion)Restrictions.gt((String)this.calculatePropertyName(property), (Object)value));
        return this;
    }

    public Query and(Query.Criterion a, Query.Criterion b) {
        AbstractHibernateCriterionAdapter adapter = this.getHibernateCriterionAdapter();
        this.addToCriteria((Criterion)Restrictions.and((Criterion)adapter.toHibernateCriterion(this, a, this.alias), (Criterion)adapter.toHibernateCriterion(this, a, this.alias)));
        return this;
    }

    public Query or(Query.Criterion a, Query.Criterion b) {
        AbstractHibernateCriterionAdapter adapter = this.getHibernateCriterionAdapter();
        this.addToCriteria((Criterion)Restrictions.or((Criterion)adapter.toHibernateCriterion(this, a, this.alias), (Criterion)adapter.toHibernateCriterion(this, b, this.alias)));
        return this;
    }

    public Query allEq(Map<String, Object> values) {
        this.addToCriteria(Restrictions.allEq(values));
        return this;
    }

    public Query ge(String property, Object value) {
        this.addToCriteria((Criterion)Restrictions.ge((String)this.calculatePropertyName(property), (Object)value));
        return this;
    }

    public Query le(String property, Object value) {
        this.addToCriteria((Criterion)Restrictions.le((String)this.calculatePropertyName(property), (Object)value));
        return this;
    }

    public Query gte(String property, Object value) {
        this.addToCriteria((Criterion)Restrictions.ge((String)this.calculatePropertyName(property), (Object)value));
        return this;
    }

    public Query lte(String property, Object value) {
        this.addToCriteria((Criterion)Restrictions.le((String)this.calculatePropertyName(property), (Object)value));
        return this;
    }

    public Query lt(String property, Object value) {
        this.addToCriteria((Criterion)Restrictions.lt((String)this.calculatePropertyName(property), (Object)value));
        return this;
    }

    public Query in(String property, List values) {
        this.addToCriteria(Restrictions.in((String)this.calculatePropertyName(property), (Collection)values));
        return this;
    }

    public Query between(String property, Object start, Object end) {
        this.addToCriteria(Restrictions.between((String)this.calculatePropertyName(property), (Object)start, (Object)end));
        return this;
    }

    public Query like(String property, String expr) {
        this.addToCriteria((Criterion)Restrictions.like((String)this.calculatePropertyName(property), (Object)this.calculatePropertyName(expr)));
        return this;
    }

    public Query ilike(String property, String expr) {
        this.addToCriteria(Restrictions.ilike((String)this.calculatePropertyName(property), (Object)this.calculatePropertyName(expr)));
        return this;
    }

    public Query rlike(String property, String expr) {
        this.addToCriteria(this.createRlikeExpression(this.calculatePropertyName(property), this.calculatePropertyName(expr)));
        return this;
    }

    public AssociationQuery createQuery(String associationName) {
        PersistentProperty property = this.entity.getPropertyByName(this.calculatePropertyName(associationName));
        if (property != null && property instanceof Association) {
            String alias = this.generateAlias(associationName);
            CriteriaAndAlias subCriteria = this.getOrCreateAlias(associationName, alias);
            Association association = (Association)property;
            if (subCriteria.criteria != null) {
                return new HibernateAssociationQuery(subCriteria.criteria, (AbstractHibernateSession)this.getSession(), association.getAssociatedEntity(), association, alias);
            }
            if (subCriteria.detachedCriteria != null) {
                return new HibernateAssociationQuery(subCriteria.detachedCriteria, (AbstractHibernateSession)this.getSession(), association.getAssociatedEntity(), association, alias);
            }
        }
        throw new InvalidDataAccessApiUsageException("Cannot query association [" + this.calculatePropertyName(associationName) + "] of entity [" + this.entity + "]. Property is not an association!");
    }

    protected CriteriaAndAlias getCriteriaAndAlias(DetachedAssociationCriteria associationCriteria) {
        String associationPath = associationCriteria.getAssociationPath();
        String alias = associationCriteria.getAlias();
        if (associationPath == null) {
            associationPath = associationCriteria.getAssociation().getName();
        }
        return this.getOrCreateAlias(associationPath, alias);
    }

    protected CriteriaAndAlias getOrCreateAlias(String associationName, String alias) {
        CriteriaAndAlias subCriteria = null;
        String associationPath = this.getAssociationPath(associationName);
        Criteria parentCriteria = this.criteria;
        if (alias == null) {
            alias = this.generateAlias(associationName);
        } else {
            CriteriaAndAlias criteriaAndAlias = this.createdAssociationPaths.get(alias);
            if (criteriaAndAlias != null && (parentCriteria = criteriaAndAlias.criteria) != null) {
                alias = associationName + '_' + alias;
                associationPath = criteriaAndAlias.associationPath + '.' + associationPath;
            }
        }
        if (this.createdAssociationPaths.containsKey(associationName)) {
            subCriteria = this.createdAssociationPaths.get(associationName);
        } else {
            javax.persistence.criteria.JoinType joinType = (javax.persistence.criteria.JoinType)this.joinTypes.get(associationName);
            if (parentCriteria != null) {
                Criteria sc = parentCriteria.createAlias(associationPath, alias, this.resolveJoinType(joinType));
                subCriteria = new CriteriaAndAlias(sc, alias, associationPath);
            } else if (this.detachedCriteria != null) {
                DetachedCriteria sc = this.detachedCriteria.createAlias(associationPath, alias, this.resolveJoinType(joinType));
                subCriteria = new CriteriaAndAlias(sc, alias, associationPath);
            }
            if (subCriteria != null) {
                this.createdAssociationPaths.put(associationPath, subCriteria);
                this.createdAssociationPaths.put(alias, subCriteria);
            }
        }
        return subCriteria;
    }

    private JoinType resolveJoinType(javax.persistence.criteria.JoinType joinType) {
        if (joinType == null) {
            return JoinType.INNER_JOIN;
        }
        switch (joinType) {
            case LEFT: {
                return JoinType.LEFT_OUTER_JOIN;
            }
            case RIGHT: {
                return JoinType.RIGHT_OUTER_JOIN;
            }
        }
        return JoinType.INNER_JOIN;
    }

    public Query.ProjectionList projections() {
        if (this.hibernateProjectionList == null) {
            this.hibernateProjectionList = new HibernateProjectionList();
        }
        return this.hibernateProjectionList;
    }

    public Query max(int max) {
        if (this.criteria != null) {
            this.criteria.setMaxResults(max);
        }
        return this;
    }

    public Query maxResults(int max) {
        if (this.criteria != null) {
            this.criteria.setMaxResults(max);
        }
        return this;
    }

    public Query offset(int offset) {
        if (this.criteria != null) {
            this.criteria.setFirstResult(offset);
        }
        return this;
    }

    public Query firstResult(int offset) {
        this.offset(offset);
        return this;
    }

    public Query cache(boolean cache) {
        this.criteria.setCacheable(cache);
        return super.cache(cache);
    }

    public Query lock(boolean lock) {
        this.criteria.setCacheable(false);
        this.criteria.setLockMode(LockMode.PESSIMISTIC_WRITE);
        return super.lock(lock);
    }

    public Query order(Query.Order order) {
        super.order(order);
        String property = order.getProperty();
        int i = property.indexOf(46);
        if (i > -1) {
            String sortHead = property.substring(0, i);
            String sortTail = property.substring(i + 1);
            if (this.createdAssociationPaths.containsKey(sortHead)) {
                CriteriaAndAlias criteriaAndAlias = this.createdAssociationPaths.get(sortHead);
                Criteria criteria = criteriaAndAlias.criteria;
                Order hibernateOrder = order.getDirection() == Query.Order.Direction.ASC ? Order.asc((String)property) : Order.desc((String)property);
                criteria.addOrder(order.isIgnoreCase() ? hibernateOrder.ignoreCase() : hibernateOrder);
            } else {
                PersistentProperty persistentProperty = this.entity.getPropertyByName(sortHead);
                if (persistentProperty instanceof Association) {
                    Association a = (Association)persistentProperty;
                    if (persistentProperty instanceof Embedded) {
                        this.addSimpleOrder(order, property);
                    } else if (this.criteria != null) {
                        Criteria subCriteria = this.criteria.createCriteria(sortHead);
                        this.addOrderToCriteria(subCriteria, sortTail, order);
                    } else if (this.detachedCriteria != null) {
                        DetachedCriteria subDetachedCriteria = this.detachedCriteria.createCriteria(sortHead);
                        this.addOrderToDetachedCriteria(subDetachedCriteria, sortTail, order);
                    }
                }
            }
        } else {
            this.addSimpleOrder(order, property);
        }
        return this;
    }

    private void addSimpleOrder(Query.Order order, String property) {
        Criteria c = this.criteria;
        if (c != null) {
            this.addOrderToCriteria(c, property, order);
        } else {
            DetachedCriteria dc = this.detachedCriteria;
            this.addOrderToDetachedCriteria(dc, property, order);
        }
    }

    private void addOrderToDetachedCriteria(DetachedCriteria dc, String property, Query.Order order) {
        if (dc != null) {
            Order hibernateOrder = order.getDirection() == Query.Order.Direction.ASC ? Order.asc((String)this.calculatePropertyName(property)) : Order.desc((String)this.calculatePropertyName(property));
            dc.addOrder(order.isIgnoreCase() ? hibernateOrder.ignoreCase() : hibernateOrder);
        }
    }

    private void addOrderToCriteria(Criteria c, String property, Query.Order order) {
        Order hibernateOrder = order.getDirection() == Query.Order.Direction.ASC ? Order.asc((String)this.calculatePropertyName(property)) : Order.desc((String)this.calculatePropertyName(property));
        c.addOrder(order.isIgnoreCase() ? hibernateOrder.ignoreCase() : hibernateOrder);
    }

    public Query join(String property) {
        this.hasJoins = true;
        if (this.criteria != null) {
            this.criteria.setFetchMode(property, FetchMode.JOIN);
        } else if (this.detachedCriteria != null) {
            this.detachedCriteria.setFetchMode(property, FetchMode.JOIN);
        }
        return this;
    }

    public Query select(String property) {
        this.hasJoins = true;
        if (this.criteria != null) {
            this.criteria.setFetchMode(property, FetchMode.SELECT);
        } else if (this.detachedCriteria != null) {
            this.detachedCriteria.setFetchMode(property, FetchMode.SELECT);
        }
        return this;
    }

    public List list() {
        org.hibernate.criterion.ProjectionList projectionList;
        if (this.criteria == null) {
            throw new IllegalStateException("Cannot execute query using a detached criteria instance");
        }
        int projectionLength = 0;
        if (this.hibernateProjectionList != null && (projectionLength = (projectionList = this.hibernateProjectionList.getHibernateProjectionList()).getLength()) > 0) {
            this.criteria.setProjection((Projection)projectionList);
        }
        if (projectionLength < 2) {
            this.criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        }
        this.applyDefaultSortOrderAndCaching();
        this.applyFetchStrategies();
        return this.listForCriteria();
    }

    public List listForCriteria() {
        Datastore datastore = this.session.getDatastore();
        ApplicationEventPublisher publisher = datastore.getApplicationEventPublisher();
        if (publisher != null) {
            publisher.publishEvent((ApplicationEvent)new PreQueryEvent((Object)datastore, (Query)this));
        }
        List results = this.criteria.list();
        if (publisher != null) {
            publisher.publishEvent((ApplicationEvent)new PostQueryEvent((Object)datastore, (Query)this, results));
        }
        return results;
    }

    protected void applyDefaultSortOrderAndCaching() {
        if (this.orderBy.isEmpty() && this.entity != null) {
            if (this.hibernateProjectionList != null && !this.hibernateProjectionList.isEmpty()) {
                return;
            }
            Mapping mapping = AbstractGrailsDomainBinder.getMapping(this.entity.getJavaClass());
            if (mapping != null) {
                if (this.queryCache == null && mapping.getCache() != null && mapping.getCache().isEnabled()) {
                    this.criteria.setCacheable(true);
                }
                Map sortMap = mapping.getSort().getNamesAndDirections();
                DynamicFinder.applySortForMap((Query)this, (Map)sortMap, (boolean)true);
            }
        }
    }

    protected void applyFetchStrategies() {
        for (Map.Entry entry : this.fetchStrategies.entrySet()) {
            switch ((FetchType)entry.getValue()) {
                case EAGER: {
                    if (this.criteria != null) {
                        this.criteria.setFetchMode((String)entry.getKey(), FetchMode.JOIN);
                        break;
                    }
                    if (this.detachedCriteria == null) break;
                    this.detachedCriteria.setFetchMode((String)entry.getKey(), FetchMode.JOIN);
                    break;
                }
                case LAZY: {
                    if (this.criteria != null) {
                        this.criteria.setFetchMode((String)entry.getKey(), FetchMode.SELECT);
                        break;
                    }
                    if (this.detachedCriteria == null) break;
                    this.detachedCriteria.setFetchMode((String)entry.getKey(), FetchMode.SELECT);
                }
            }
        }
    }

    protected void flushBeforeQuery() {
    }

    public Object singleResult() {
        Object result;
        if (this.criteria == null) {
            throw new IllegalStateException("Cannot execute query using a detached criteria instance");
        }
        if (this.hibernateProjectionList != null) {
            this.criteria.setProjection((Projection)this.hibernateProjectionList.getHibernateProjectionList());
        }
        this.criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        this.applyDefaultSortOrderAndCaching();
        this.applyFetchStrategies();
        Datastore datastore = this.session.getDatastore();
        ApplicationEventPublisher publisher = datastore.getApplicationEventPublisher();
        if (publisher != null) {
            publisher.publishEvent((ApplicationEvent)new PreQueryEvent((Object)datastore, (Query)this));
        }
        if (this.hasJoins) {
            try {
                result = this.proxyHandler.unwrap(this.criteria.uniqueResult());
            }
            catch (NonUniqueResultException e) {
                result = this.singleResultViaListCall();
            }
        } else {
            result = this.singleResultViaListCall();
        }
        if (publisher != null) {
            publisher.publishEvent((ApplicationEvent)new PostQueryEvent((Object)datastore, (Query)this, Collections.singletonList(result)));
        }
        return result;
    }

    private Object singleResultViaListCall() {
        List results;
        this.criteria.setMaxResults(1);
        if (this.hibernateProjectionList != null && this.hibernateProjectionList.isRowCount()) {
            this.criteria.setFirstResult(0);
        }
        if ((results = this.criteria.list()).size() > 0) {
            return this.proxyHandler.unwrap(results.get(0));
        }
        return null;
    }

    protected List executeQuery(PersistentEntity entity, Query.Junction criteria) {
        return this.list();
    }

    String handleAssociationQuery(Association<?> association, List<Query.Criterion> criteriaList) {
        return this.getCriteriaAndAlias(association).alias;
    }

    String handleAssociationQuery(Association<?> association, List<Query.Criterion> criteriaList, String alias) {
        String associationName = this.calculatePropertyName(association.getName());
        return this.getOrCreateAlias((String)associationName, (String)alias).alias;
    }

    protected CriteriaAndAlias getCriteriaAndAlias(Association<?> association) {
        String associationName = this.calculatePropertyName(association.getName());
        String newAlias = this.generateAlias(associationName);
        return this.getOrCreateAlias(associationName, newAlias);
    }

    protected void addToCriteria(Criterion criterion) {
        if (criterion == null) {
            return;
        }
        if (this.aliasInstanceStack.isEmpty()) {
            if (this.criteria != null) {
                this.criteria.add(criterion);
            } else if (this.detachedCriteria != null) {
                this.detachedCriteria.add(criterion);
            }
        } else {
            Object criteriaObject = this.aliasInstanceStack.getLast();
            if (criteriaObject instanceof Criteria) {
                ((Criteria)criteriaObject).add(criterion);
            } else if (criteriaObject instanceof DetachedCriteria) {
                ((DetachedCriteria)criteriaObject).add(criterion);
            }
        }
    }

    protected String calculatePropertyName(String property) {
        if (this.alias == null) {
            return property;
        }
        return this.alias + '.' + property;
    }

    protected String generateAlias(String associationName) {
        return this.calculatePropertyName(associationName) + this.calculatePropertyName(ALIAS) + this.aliasCount++;
    }

    protected abstract void setDetachedCriteriaValue(QueryableCriteria var1, Query.PropertyCriterion var2);

    protected AbstractHibernateCriterionAdapter getHibernateCriterionAdapter() {
        return this.abstractHibernateCriterionAdapter;
    }

    protected abstract AbstractHibernateCriterionAdapter createHibernateCriterionAdapter();

    protected abstract Criterion createRlikeExpression(String var1, String var2);

    static {
        ReflectionUtils.makeAccessible((Field)opField);
    }

    protected class CriteriaAndAlias {
        protected DetachedCriteria detachedCriteria;
        protected Criteria criteria;
        protected String alias;
        protected String associationPath;

        public CriteriaAndAlias(DetachedCriteria detachedCriteria, String alias, String associationPath) {
            this.detachedCriteria = detachedCriteria;
            this.alias = alias;
            this.associationPath = associationPath;
        }

        public CriteriaAndAlias(Criteria criteria, String alias, String associationPath) {
            this.criteria = criteria;
            this.alias = alias;
            this.associationPath = associationPath;
        }
    }

    protected class HibernateAssociationQuery
    extends AssociationQuery {
        protected String alias;
        protected Junction hibernateJunction;
        protected Criteria assocationCriteria;
        protected DetachedCriteria detachedAssocationCriteria;

        public HibernateAssociationQuery(Criteria criteria, AbstractHibernateSession session, PersistentEntity associatedEntity, Association association, String alias) {
            super((Session)session, associatedEntity, association);
            this.alias = alias;
            this.assocationCriteria = criteria;
        }

        public HibernateAssociationQuery(DetachedCriteria criteria, AbstractHibernateSession session, PersistentEntity associatedEntity, Association association, String alias) {
            super((Session)session, associatedEntity, association);
            this.alias = alias;
            this.detachedAssocationCriteria = criteria;
        }

        public Query order(Query.Order order) {
            Query.Order.Direction direction = order.getDirection();
            switch (direction) {
                case ASC: {
                    this.assocationCriteria.addOrder(Order.asc((String)order.getProperty()));
                }
                case DESC: {
                    this.assocationCriteria.addOrder(Order.desc((String)order.getProperty()));
                }
            }
            return super.order(order);
        }

        public Query isEmpty(String property) {
            Criterion criterion = Restrictions.isEmpty((String)AbstractHibernateQuery.this.calculatePropertyName(property));
            this.addToCriteria(criterion);
            return this;
        }

        protected void addToCriteria(Criterion criterion) {
            if (this.hibernateJunction != null) {
                this.hibernateJunction.add(criterion);
            } else if (this.assocationCriteria != null) {
                this.assocationCriteria.add(criterion);
            } else if (this.detachedAssocationCriteria != null) {
                this.detachedAssocationCriteria.add(criterion);
            }
        }

        public Query isNotEmpty(String property) {
            this.addToCriteria(Restrictions.isNotEmpty((String)AbstractHibernateQuery.this.calculatePropertyName(property)));
            return this;
        }

        public Query isNull(String property) {
            this.addToCriteria(Restrictions.isNull((String)AbstractHibernateQuery.this.calculatePropertyName(property)));
            return this;
        }

        public Query isNotNull(String property) {
            this.addToCriteria(Restrictions.isNotNull((String)AbstractHibernateQuery.this.calculatePropertyName(property)));
            return this;
        }

        public void add(Query.Criterion criterion) {
            Criterion hibernateCriterion = AbstractHibernateQuery.this.getHibernateCriterionAdapter().toHibernateCriterion(AbstractHibernateQuery.this, criterion, this.alias);
            if (hibernateCriterion != null) {
                this.addToCriteria(hibernateCriterion);
            }
        }

        public Query.Junction disjunction() {
            Disjunction disjunction = Restrictions.disjunction();
            this.addToCriteria((Criterion)disjunction);
            return new HibernateJunction((Junction)disjunction, this.alias);
        }

        public Query.Junction negation() {
            Disjunction disjunction = Restrictions.disjunction();
            this.addToCriteria(Restrictions.not((Criterion)disjunction));
            return new HibernateJunction((Junction)disjunction, this.alias);
        }

        public Query eq(String property, Object value) {
            this.addToCriteria((Criterion)Restrictions.eq((String)AbstractHibernateQuery.this.calculatePropertyName(property), (Object)value));
            return this;
        }

        public Query idEq(Object value) {
            this.addToCriteria(Restrictions.idEq((Object)value));
            return this;
        }

        public Query gt(String property, Object value) {
            this.addToCriteria((Criterion)Restrictions.gt((String)AbstractHibernateQuery.this.calculatePropertyName(property), (Object)value));
            return this;
        }

        public Query and(Query.Criterion a, Query.Criterion b) {
            AbstractHibernateCriterionAdapter adapter = AbstractHibernateQuery.this.getHibernateCriterionAdapter();
            this.addToCriteria((Criterion)Restrictions.and((Criterion)adapter.toHibernateCriterion(AbstractHibernateQuery.this, a, this.alias), (Criterion)adapter.toHibernateCriterion(AbstractHibernateQuery.this, b, this.alias)));
            return this;
        }

        public Query or(Query.Criterion a, Query.Criterion b) {
            AbstractHibernateCriterionAdapter adapter = AbstractHibernateQuery.this.getHibernateCriterionAdapter();
            this.addToCriteria((Criterion)Restrictions.or((Criterion)adapter.toHibernateCriterion(AbstractHibernateQuery.this, a, this.alias), (Criterion)adapter.toHibernateCriterion(AbstractHibernateQuery.this, b, this.alias)));
            return this;
        }

        public Query allEq(Map<String, Object> values) {
            this.addToCriteria(Restrictions.allEq(values));
            return this;
        }

        public Query ge(String property, Object value) {
            this.addToCriteria((Criterion)Restrictions.ge((String)AbstractHibernateQuery.this.calculatePropertyName(property), (Object)value));
            return this;
        }

        public Query le(String property, Object value) {
            this.addToCriteria((Criterion)Restrictions.le((String)AbstractHibernateQuery.this.calculatePropertyName(property), (Object)value));
            return this;
        }

        public Query gte(String property, Object value) {
            this.addToCriteria((Criterion)Restrictions.ge((String)AbstractHibernateQuery.this.calculatePropertyName(property), (Object)value));
            return this;
        }

        public Query lte(String property, Object value) {
            this.addToCriteria((Criterion)Restrictions.le((String)AbstractHibernateQuery.this.calculatePropertyName(property), (Object)value));
            return this;
        }

        public Query lt(String property, Object value) {
            this.addToCriteria((Criterion)Restrictions.lt((String)AbstractHibernateQuery.this.calculatePropertyName(property), (Object)value));
            return this;
        }

        public Query in(String property, List values) {
            this.addToCriteria(Restrictions.in((String)AbstractHibernateQuery.this.calculatePropertyName(property), (Collection)values));
            return this;
        }

        public Query between(String property, Object start, Object end) {
            this.addToCriteria(Restrictions.between((String)AbstractHibernateQuery.this.calculatePropertyName(property), (Object)start, (Object)end));
            return this;
        }

        public Query like(String property, String expr) {
            this.addToCriteria((Criterion)Restrictions.like((String)AbstractHibernateQuery.this.calculatePropertyName(property), (Object)AbstractHibernateQuery.this.calculatePropertyName(expr)));
            return this;
        }

        public Query ilike(String property, String expr) {
            this.addToCriteria(Restrictions.ilike((String)AbstractHibernateQuery.this.calculatePropertyName(property), (Object)AbstractHibernateQuery.this.calculatePropertyName(expr)));
            return this;
        }

        public Query rlike(String property, String expr) {
            this.addToCriteria(AbstractHibernateQuery.this.createRlikeExpression(AbstractHibernateQuery.this.calculatePropertyName(property), AbstractHibernateQuery.this.calculatePropertyName(expr)));
            return this;
        }
    }

    protected class HibernateProjectionList
    extends Query.ProjectionList {
        org.hibernate.criterion.ProjectionList projectionList = Projections.projectionList();
        private boolean rowCount = false;

        protected HibernateProjectionList() {
        }

        public boolean isRowCount() {
            return this.rowCount;
        }

        public org.hibernate.criterion.ProjectionList getHibernateProjectionList() {
            return this.projectionList;
        }

        public boolean isEmpty() {
            return this.projectionList.getLength() == 0;
        }

        public Query.ProjectionList add(Query.Projection p) {
            this.projectionList.add(new HibernateProjectionAdapter(p).toHibernateProjection());
            return this;
        }

        public ProjectionList countDistinct(String property) {
            this.projectionList.add((Projection)Projections.countDistinct((String)AbstractHibernateQuery.this.calculatePropertyName(property)));
            return this;
        }

        public ProjectionList distinct(String property) {
            this.projectionList.add(Projections.distinct((Projection)Projections.property((String)AbstractHibernateQuery.this.calculatePropertyName(property))));
            return this;
        }

        public ProjectionList rowCount() {
            this.projectionList.add(Projections.rowCount());
            this.rowCount = true;
            return this;
        }

        public Query.ProjectionList id() {
            this.projectionList.add((Projection)Projections.id());
            return this;
        }

        public Query.ProjectionList count() {
            this.projectionList.add(Projections.rowCount());
            this.rowCount = true;
            return this;
        }

        public Query.ProjectionList property(String name) {
            this.projectionList.add((Projection)Projections.property((String)AbstractHibernateQuery.this.calculatePropertyName(name)));
            return this;
        }

        public Query.ProjectionList sum(String name) {
            this.projectionList.add((Projection)Projections.sum((String)AbstractHibernateQuery.this.calculatePropertyName(name)));
            return this;
        }

        public Query.ProjectionList min(String name) {
            this.projectionList.add((Projection)Projections.min((String)AbstractHibernateQuery.this.calculatePropertyName(name)));
            return this;
        }

        public Query.ProjectionList max(String name) {
            this.projectionList.add((Projection)Projections.max((String)AbstractHibernateQuery.this.calculatePropertyName(name)));
            return this;
        }

        public Query.ProjectionList avg(String name) {
            this.projectionList.add((Projection)Projections.avg((String)AbstractHibernateQuery.this.calculatePropertyName(name)));
            return this;
        }

        public Query.ProjectionList distinct() {
            if (AbstractHibernateQuery.this.criteria != null) {
                AbstractHibernateQuery.this.criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
            } else if (AbstractHibernateQuery.this.detachedCriteria != null) {
                AbstractHibernateQuery.this.detachedCriteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
            }
            return this;
        }
    }

    protected class HibernateJunction
    extends Query.Junction {
        protected Junction hibernateJunction;
        protected String alias;

        public HibernateJunction(Junction junction, String alias) {
            this.hibernateJunction = junction;
            this.alias = alias;
        }

        public Query.Junction add(Query.Criterion c) {
            if (c != null) {
                if (c instanceof FunctionCallingCriterion) {
                    Criterion sqlRestriction = AbstractHibernateQuery.this.getRestrictionForFunctionCall((FunctionCallingCriterion)c, AbstractHibernateQuery.this.entity);
                    if (sqlRestriction != null) {
                        this.hibernateJunction.add(sqlRestriction);
                    }
                } else {
                    AbstractHibernateCriterionAdapter adapter = AbstractHibernateQuery.this.getHibernateCriterionAdapter();
                    Criterion criterion = adapter.toHibernateCriterion(AbstractHibernateQuery.this, c, this.alias);
                    if (criterion != null) {
                        this.hibernateJunction.add(criterion);
                    }
                }
            }
            return this;
        }
    }
}

