/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.offheapstore.storage.allocator;

import org.terracotta.offheapstore.util.AATreeSet;

class Region
extends AATreeSet.AbstractTreeNode<Region>
implements Comparable<Comparable<?>> {
    private int start;
    private int end;
    private int availableBitSet;

    Region(int value) {
        this(value, value);
    }

    Region(int start, int end) {
        this.start = start;
        this.end = end;
        this.updateAvailable();
    }

    Region(Region r) {
        this(r.start(), r.end());
    }

    int available() {
        if (this.getLeft().getPayload() == null && this.getRight().getPayload() == null) {
            return this.availableHere();
        }
        return this.availableBitSet;
    }

    private void updateAvailable() {
        Region left = (Region)this.getLeft().getPayload();
        Region right = (Region)this.getRight().getPayload();
        int leftAvailable = left == null ? 0 : left.available();
        int rightAvailable = right == null ? 0 : right.available();
        this.availableBitSet = this.availableHere() | leftAvailable | rightAvailable;
    }

    int availableHere() {
        int bits = 0;
        for (int i = 0; i < 31; ++i) {
            int size = 1 << i;
            int mask = size - 1;
            int a = this.start + mask & ~mask;
            if (this.end - a + 1 < size) continue;
            bits |= size;
        }
        return bits;
    }

    @Override
    public void setLeft(AATreeSet.Node<Region> l) {
        super.setLeft(l);
        this.updateAvailable();
    }

    @Override
    public void setRight(AATreeSet.Node<Region> r) {
        super.setRight(r);
        this.updateAvailable();
    }

    public String toString() {
        return "Range(" + this.start + "," + this.end + ")" + " available:" + Integer.toBinaryString(this.availableHere());
    }

    public int size() {
        return this.isNull() ? 0 : this.end - this.start + 1;
    }

    protected boolean isNull() {
        return this.start > this.end;
    }

    int treeSize() {
        int treeSize = this.size();
        Region left = (Region)this.getLeft().getPayload();
        treeSize += left == null ? 0 : left.treeSize();
        Region right = (Region)this.getRight().getPayload();
        return treeSize += right == null ? 0 : right.treeSize();
    }

    public Region remove(Region r) {
        if (r.start < this.start || r.end > this.end) {
            throw new AssertionError((Object)("Ranges : Illegal value passed to remove : " + this + " remove called for : " + r));
        }
        if (this.start == r.start) {
            this.start = r.end + 1;
            this.updateAvailable();
            return null;
        }
        if (this.end == r.end) {
            this.end = r.start - 1;
            this.updateAvailable();
            return null;
        }
        Region newRegion = new Region(r.end + 1, this.end);
        this.end = r.start - 1;
        this.updateAvailable();
        return newRegion;
    }

    public void merge(Region r) {
        if (this.start == r.end + 1) {
            this.start = r.start;
        } else if (this.end == r.start - 1) {
            this.end = r.end;
        } else {
            throw new AssertionError((Object)("Ranges : Merge called on non contiguous values : [this]:" + this + " and " + r));
        }
        this.updateAvailable();
    }

    public boolean tryMerge(Region r) {
        if (this.start == r.end + 1) {
            this.start = r.start;
        } else if (this.end == r.start - 1) {
            this.end = r.end;
        } else {
            if (this.start <= r.start && this.end >= r.end) {
                return false;
            }
            throw new AssertionError((Object)("Ranges : Merge called on non contiguous values : [this]:" + this + " and " + r));
        }
        this.updateAvailable();
        return true;
    }

    @Override
    public int compareTo(Comparable<?> other) {
        if (other instanceof Region) {
            Region r = (Region)other;
            if (this.start < r.start) {
                return -1;
            }
            if (this.end > r.end) {
                return 1;
            }
            return 0;
        }
        if (other instanceof Integer) {
            Integer l = (Integer)other;
            if (l > this.end) {
                return -1;
            }
            if (l < this.start) {
                return 1;
            }
            return 0;
        }
        throw new AssertionError();
    }

    public boolean equals(Object other) {
        if (other instanceof Region) {
            Region r = (Region)other;
            return this.start == r.start && this.end == r.end;
        }
        throw new AssertionError();
    }

    public int hashCode() {
        return 3 * this.start ^ 7 * this.end;
    }

    @Override
    public Region getPayload() {
        return this;
    }

    @Override
    public void swapPayload(AATreeSet.Node<Region> other) {
        if (!(other instanceof Region)) {
            throw new AssertionError();
        }
        Region r = (Region)other;
        int temp = this.start;
        this.start = r.start;
        r.start = temp;
        temp = this.end;
        this.end = r.end;
        r.end = temp;
        this.updateAvailable();
    }

    public int start() {
        return this.start;
    }

    public int end() {
        return this.end;
    }
}

