/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.fonts.fop.fonts.substitute;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.docx4j.fonts.fop.fonts.FontInfo;
import org.docx4j.fonts.fop.fonts.FontTriplet;
import org.docx4j.fonts.fop.fonts.substitute.FontQualifier;
import org.docx4j.fonts.fop.fonts.substitute.FontSubstitution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FontSubstitutions
extends ArrayList<FontSubstitution> {
    private static final long serialVersionUID = -9173104935431899722L;
    protected static final Logger log = LoggerFactory.getLogger(FontSubstitutions.class);

    public void adjustFontInfo(FontInfo fontInfo) {
        Iterator subsIt = super.iterator();
        while (subsIt.hasNext()) {
            FontSubstitution substitution = (FontSubstitution)subsIt.next();
            FontQualifier toQualifier = substitution.getToQualifier();
            FontTriplet fontTriplet = toQualifier.bestMatch(fontInfo);
            if (fontTriplet == null) {
                log.error("Unable to match font substitution for destination qualifier " + toQualifier);
                continue;
            }
            String internalFontKey = fontInfo.getInternalFontKey(fontTriplet);
            FontQualifier fromQualifier = substitution.getFromQualifier();
            List<FontTriplet> tripletList = fromQualifier.getTriplets();
            Iterator<FontTriplet> iterator = tripletList.iterator();
            while (iterator.hasNext()) {
                FontTriplet aTripletList;
                FontTriplet triplet = aTripletList = iterator.next();
                fontInfo.addFontProperties(internalFontKey, triplet);
            }
        }
    }
}

