/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.tracing;

import io.sentry.protocol.TransactionNameSource;
import io.sentry.spring.tracing.TransactionNameProvider;
import javax.servlet.http.HttpServletRequest;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.web.servlet.HandlerMapping;

@ApiStatus.Internal
public final class SpringMvcTransactionNameProvider
implements TransactionNameProvider {
    @Override
    @Nullable
    public String provideTransactionName(@NotNull HttpServletRequest request) {
        String pattern = (String)request.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE);
        if (pattern != null) {
            return request.getMethod() + " " + pattern;
        }
        return null;
    }

    @Override
    @ApiStatus.Internal
    @NotNull
    public TransactionNameSource provideTransactionSource() {
        return TransactionNameSource.ROUTE;
    }
}

