/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.core.utils;

import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class DatatypeUtils {
    private static DatatypeFactory datatypeFactory;

    private static DatatypeFactory getDataTypeFactory() {
        if (datatypeFactory == null) {
            try {
                datatypeFactory = DatatypeFactory.newInstance();
            }
            catch (DatatypeConfigurationException e) {
                e.printStackTrace();
            }
        }
        return datatypeFactory;
    }

    public static String formatAsXSDateTime(Date date) {
        GregorianCalendar gCalendar = new GregorianCalendar();
        gCalendar.setTime(date);
        XMLGregorianCalendar xmlCalendar = DatatypeUtils.getDataTypeFactory().newXMLGregorianCalendar(gCalendar);
        return xmlCalendar.toXMLFormat();
    }

    public static Date parseXSDateTime(String lexicalRepresentation) {
        XMLGregorianCalendar xmlCalendar = DatatypeUtils.getDataTypeFactory().newXMLGregorianCalendar(lexicalRepresentation);
        return xmlCalendar.toGregorianCalendar().getTime();
    }
}

