/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.api.agent;

import com.newrelic.api.agent.ExternalParameters;
import java.net.URI;

public class GenericParameters
implements ExternalParameters {
    private final String library;
    private final URI uri;
    private final String procedure;

    protected GenericParameters(String library, URI uri, String procedure) {
        this.library = library;
        this.uri = uri;
        this.procedure = procedure;
    }

    protected GenericParameters(GenericParameters genericParameters) {
        this.library = genericParameters.library;
        this.uri = genericParameters.uri;
        this.procedure = genericParameters.procedure;
    }

    public String getLibrary() {
        return this.library;
    }

    public URI getUri() {
        return this.uri;
    }

    public String getProcedure() {
        return this.procedure;
    }

    public static UriParameter library(String library) {
        return new Builder(library);
    }

    public static interface Build {
        public GenericParameters build();
    }

    public static interface ProcedureParameter {
        public Build procedure(String var1);
    }

    public static interface UriParameter {
        public ProcedureParameter uri(URI var1);
    }

    protected static class Builder
    implements UriParameter,
    ProcedureParameter,
    Build {
        private String library;
        private URI uri;
        private String procedure;

        public Builder(String library) {
            this.library = library;
        }

        @Override
        public ProcedureParameter uri(URI uri) {
            this.uri = uri;
            return this;
        }

        @Override
        public Build procedure(String procedure) {
            this.procedure = procedure;
            return this;
        }

        @Override
        public GenericParameters build() {
            return new GenericParameters(this.library, this.uri, this.procedure);
        }
    }
}

