/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.changelog.filter;

import java.util.List;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.RanChangeSet;
import liquibase.changelog.filter.ChangeSetFilter;
import liquibase.changelog.filter.ChangeSetFilterResult;
import liquibase.exception.LiquibaseException;
import liquibase.logging.LogService;
import liquibase.logging.Logger;

public class SingleChangeSetFilter
implements ChangeSetFilter {
    private Logger log = LogService.getLog(this.getClass());
    private String id;
    private String author;
    private String filePath;
    private RanChangeSet matchingIdChangeSet = null;

    public SingleChangeSetFilter(String string, String string2, String string3, List<RanChangeSet> object, DatabaseChangeLog databaseChangeLog) {
        object = object.iterator();
        while (object.hasNext()) {
            RanChangeSet ranChangeSet = (RanChangeSet)object.next();
            if (string.equalsIgnoreCase(ranChangeSet.getId()) && string2.equalsIgnoreCase(ranChangeSet.getAuthor()) && string3.equalsIgnoreCase(ranChangeSet.getChangeLog())) {
                if (databaseChangeLog.getChangeSet(string3, string2, string) == null) {
                    this.log.info("Unable to locate the change for " + string + "::" + string2 + "::" + string3);
                    string = this.createNotFoundErrorMessage(databaseChangeLog, string, string2, string3);
                    throw new LiquibaseException(string);
                }
                this.log.debug("FOUND the change for " + string + "::" + string2 + "::" + string3);
                this.id = string;
                this.author = string2;
                this.filePath = string3;
                return;
            }
            if (string.equalsIgnoreCase(ranChangeSet.getId())) {
                this.matchingIdChangeSet = ranChangeSet;
            } else {
                this.log.debug("ID '" + string + "' did not match '" + ranChangeSet.getId() + "'");
            }
            if (!string2.equalsIgnoreCase(ranChangeSet.getAuthor())) {
                this.log.debug("Author '" + string2 + "' did not match '" + ranChangeSet.getAuthor() + "'");
                continue;
            }
            if (string3.equalsIgnoreCase(ranChangeSet.getChangeLog())) continue;
            this.log.debug("Path '" + string3 + "' did not match '" + ranChangeSet.getChangeLog() + "'");
            this.log.debug("Path length: " + string3.length() + " changelog length: " + ranChangeSet.getChangeLog().length());
        }
    }

    public RanChangeSet getMatchingIdChangeSet() {
        return this.matchingIdChangeSet;
    }

    public boolean isEmpty() {
        return this.id == null || this.author == null || this.filePath == null;
    }

    private String createNotFoundErrorMessage(DatabaseChangeLog object, String string, String string2, String string3) {
        Object object2 = ((DatabaseChangeLog)object).getChangeSets();
        String string4 = "\nThe command 'rollbackOneChangeSet' failed because the changeset targeted by '" + string + "::" + string2 + "::" + string3 + "'\ncannot be located.  ";
        boolean bl2 = ((DatabaseChangeLog)object).ignoreClasspathPrefix();
        object2 = object2.iterator();
        while (object2.hasNext()) {
            ChangeSet changeSet = (ChangeSet)object2.next();
            if (!this.normalizePath(changeSet.getFilePath(), bl2).equalsIgnoreCase(this.normalizePath(string3, bl2))) {
                return string4 + "The path '" + changeSet.getFilePath() + "' does not resolve to the desired changelog. One solution may be to control the lookup path of\nyour changeLogFile by adding it's base directory to the --classpath flag  and removing any relative path information from the --changeLogFile flag.";
            }
            if (!changeSet.getAuthor().equalsIgnoreCase(string2)) {
                return string4 + "The changelog author '" + changeSet.getAuthor() + "' does not match the change set author '" + string2 + "'";
            }
            if (!changeSet.getId().equalsIgnoreCase(string)) {
                return string4 + "The changelog ID '" + changeSet.getId() + "' does not match the change set ID '" + string + "'";
            }
            if (((DatabaseChangeLog)object).isDbmsMatch(changeSet.getDbmsSet())) continue;
            object = ((DatabaseChangeLog)object).getChangeLogParameters().getValue("database.typeName", (DatabaseChangeLog)object).toString();
            return string4 + "The changelog DBMS: '" + (String)object + "'  does not match the change set DBMS '" + changeSet.getDbmsSet().toString() + "'";
        }
        return "";
    }

    private String normalizePath(String string, boolean bl2) {
        if (bl2) {
            return string.replaceFirst("^classpath:", "");
        }
        return string;
    }

    @Override
    public ChangeSetFilterResult accepts(ChangeSet changeSet) {
        String string = changeSet.toString();
        if (this.id.equalsIgnoreCase(changeSet.getId()) && this.author.equalsIgnoreCase(changeSet.getAuthor()) && this.filePath.equals(changeSet.getFilePath())) {
            return new ChangeSetFilterResult(true, "Change set to rollback is ".concat(String.valueOf(string)), this.getClass());
        }
        return new ChangeSetFilterResult(false, "Change set " + string + " will not rollback", this.getClass());
    }
}

