/*
 * Decompiled with CFR 0.152.
 */
package fr.w3blog.zpl.model;

import fr.w3blog.zpl.constant.ZebraFieldPosition;
import fr.w3blog.zpl.constant.ZebraJustification;
import fr.w3blog.zpl.constant.ZebraPPP;
import fr.w3blog.zpl.constant.ZebraRotation;
import fr.w3blog.zpl.model.PrinterOptions;
import fr.w3blog.zpl.utils.ZebraDefaultSettings;
import fr.w3blog.zpl.utils.ZplUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;

public abstract class ZebraElement<T extends ZebraElement<T>> {
    protected Integer positionX;
    protected Integer positionY;
    protected ZebraJustification justification = ZebraDefaultSettings.DEFAULT_ZEBRA_JUSTIFICATION;
    protected ZebraFieldPosition fieldPosition = ZebraDefaultSettings.DEFAULT_ZEBRA_FIELD_POSITION;
    protected ZebraRotation zebraRotation = ZebraDefaultSettings.DEFAULT_ZEBRA_ROTATION;
    protected boolean defaultDrawGraphic = true;

    protected abstract T getThis();

    public String getZplCode(PrinterOptions printerOptions) {
        return "";
    }

    protected String getZplCodePosition() {
        StringBuffer zpl = new StringBuffer("");
        if (this.positionX != null && this.positionY != null) {
            if (this.justification != null) {
                zpl.append((CharSequence)ZplUtils.zplCommand(this.fieldPosition.getZpl(), new Object[]{this.positionX, this.positionY, this.justification}));
            } else {
                zpl.append((CharSequence)ZplUtils.zplCommand(this.fieldPosition.getZpl(), this.positionX, this.positionY));
            }
        }
        return zpl.toString();
    }

    protected String getZplCodePosition(ZebraPPP zebraPPP) {
        StringBuilder zpl = new StringBuilder("");
        if (zebraPPP != null) {
            float factor = this.scale(zebraPPP);
            if (this.positionX != null && this.positionY != null) {
                zpl.append((CharSequence)ZplUtils.zplCommand("FO", Math.round((float)this.positionX.intValue() * factor), Math.round((float)this.positionY.intValue() * factor)));
            }
            return zpl.toString();
        }
        return zpl.toString();
    }

    protected float scale(ZebraPPP zebraPPP) {
        if (zebraPPP != null) {
            return zebraPPP.getDotByMm() / ZebraPPP.values()[0].getDotByMm();
        }
        return 1.0f;
    }

    public void drawPreviewGraphic(PrinterOptions printerOptions, Graphics2D graphic) {
        if (this.defaultDrawGraphic) {
            int top = 0;
            int left = 0;
            if (this.positionX != null) {
                left = Math.round((float)this.positionX.intValue() / printerOptions.getZebraPPP().getDotByMm() * 10.0f);
            }
            if (this.positionY != null) {
                top = Math.round((float)this.positionY.intValue() / printerOptions.getZebraPPP().getDotByMm() * 10.0f);
            }
            graphic.setColor(Color.BLACK);
            graphic.drawRect(left, top, 100, 20);
            this.drawTopString(graphic, new Font("Arial", 1, 11), "Default", left, top);
        }
    }

    protected void drawTopString(Graphics2D graphic, Font font, String text, int positionX, int positionY) {
        graphic.setFont(font);
        FontMetrics fm = graphic.getFontMetrics(font);
        Rectangle2D rect = fm.getStringBounds(text, graphic);
        int textHeight = (int)rect.getHeight();
        graphic.drawString(text, positionX, positionY += textHeight);
    }

    public int getPositionX() {
        return this.positionX;
    }

    public ZebraElement setPositionX(int positionX) {
        this.positionX = positionX;
        return this;
    }

    public int getPositionY() {
        return this.positionY;
    }

    public ZebraElement setPositionY(int positionY) {
        this.positionY = positionY;
        return this;
    }

    public ZebraJustification getJustification() {
        return this.justification;
    }

    public void setJustification(ZebraJustification justification) {
        this.justification = justification;
    }

    public ZebraFieldPosition getFieldPosition() {
        return this.fieldPosition;
    }

    public void setFieldPosition(ZebraFieldPosition fieldPositition) {
        this.fieldPosition = fieldPositition;
    }

    public ZebraRotation getZebraRotation() {
        return this.zebraRotation;
    }

    public void setZebraRotation(ZebraRotation zebraRotation) {
        this.zebraRotation = zebraRotation;
    }

    public void setPositionX(Integer positionX) {
        this.positionX = positionX;
    }

    public void setPositionY(Integer positionY) {
        this.positionY = positionY;
    }

    public T withZebraRotation(ZebraRotation zebraRotation) {
        this.setZebraRotation(zebraRotation);
        return this.getThis();
    }

    public T withZebraJustification(ZebraJustification zebraJustification) {
        this.setJustification(this.justification);
        return this.getThis();
    }

    public T withFieldPosition(ZebraFieldPosition zebraFieldPosition) {
        this.setFieldPosition(zebraFieldPosition);
        return this.getThis();
    }

    public T withPositionX(Integer positionX) {
        this.setPositionX(positionX);
        return this.getThis();
    }

    public T withPositionY(Integer positionY) {
        this.setPositionX(positionY);
        return this.getThis();
    }
}

