/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.odfdom.converter.pdf.internal.stylable;

import com.lowagie.text.Anchor;
import com.lowagie.text.Chunk;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import fr.opensagres.odfdom.converter.pdf.internal.stylable.IStylableContainer;
import fr.opensagres.odfdom.converter.pdf.internal.stylable.IStylableFactory;
import fr.opensagres.odfdom.converter.pdf.internal.styles.Style;
import fr.opensagres.odfdom.converter.pdf.internal.styles.StyleTextProperties;
import java.util.ArrayList;

public class StylableAnchor
extends Anchor
implements IStylableContainer {
    private static final long serialVersionUID = 664309269352903329L;
    private final IStylableContainer parent;
    private Style lastStyleApplied = null;

    public StylableAnchor(IStylableFactory ownerDocument, IStylableContainer parent) {
        this.parent = parent;
    }

    @Override
    public void addElement(Element element) {
        super.add((Object)element);
    }

    @Override
    public void applyStyles(Style style) {
        Font font;
        this.lastStyleApplied = style;
        StyleTextProperties textProperties = style.getTextProperties();
        if (textProperties != null && (font = textProperties.getFont()) != null) {
            if (!font.isUnderlined()) {
                font = new Font(font);
                font.setStyle(font.getStyle() | 4);
            }
            super.setFont(font);
        }
    }

    @Override
    public Style getLastStyleApplied() {
        return this.lastStyleApplied;
    }

    @Override
    public IStylableContainer getParent() {
        return this.parent;
    }

    @Override
    public Element getElement() {
        ArrayList chunks = this.getChunks();
        for (Chunk chunk : chunks) {
            Font f = chunk.getFont();
            if (f == null || f.isUnderlined()) continue;
            f = new Font(f);
            f.setStyle(f.getStyle() | 4);
            chunk.setFont(f);
        }
        return this;
    }
}

