/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.textstyling.properties;

public class Color {
    private final int red;
    private final int green;
    private final int blue;

    public Color(int red, int green, int blue) {
        this.red = this.checkColor(red);
        this.green = this.checkColor(green);
        this.blue = this.checkColor(blue);
    }

    public int getRed() {
        return this.red;
    }

    public int getGreen() {
        return this.green;
    }

    public int getBlue() {
        return this.blue;
    }

    private int checkColor(int color) {
        if (color >= 0 && color < 256) {
            return color;
        }
        throw new IllegalArgumentException("rgb must be between 0 and 255");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Color color = (Color)o;
        if (this.getRed() != color.getRed()) {
            return false;
        }
        if (this.getGreen() != color.getGreen()) {
            return false;
        }
        return this.getBlue() == color.getBlue();
    }

    public int hashCode() {
        int result = this.getRed();
        result = 31 * result + this.getGreen();
        result = 31 * result + this.getBlue();
        return result;
    }
}

