/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web;

import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import java.io.File;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import org.apache.catalina.Context;
import org.apache.catalina.Valve;
import org.apache.catalina.valves.AccessLogValve;
import org.apache.catalina.valves.ErrorReportValve;
import org.apache.catalina.valves.RemoteIpValve;
import org.apache.coyote.AbstractProtocol;
import org.apache.coyote.ProtocolHandler;
import org.apache.coyote.http11.AbstractHttp11Protocol;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.springframework.boot.autoconfigure.web.ErrorProperties;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.context.embedded.Compression;
import org.springframework.boot.context.embedded.ConfigurableEmbeddedServletContainer;
import org.springframework.boot.context.embedded.EmbeddedServletContainerCustomizer;
import org.springframework.boot.context.embedded.InitParameterConfiguringServletContextInitializer;
import org.springframework.boot.context.embedded.JspServlet;
import org.springframework.boot.context.embedded.Ssl;
import org.springframework.boot.context.embedded.jetty.JettyEmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.jetty.JettyServerCustomizer;
import org.springframework.boot.context.embedded.tomcat.TomcatConnectorCustomizer;
import org.springframework.boot.context.embedded.tomcat.TomcatContextCustomizer;
import org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.undertow.UndertowBuilderCustomizer;
import org.springframework.boot.context.embedded.undertow.UndertowEmbeddedServletContainerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.DeprecatedConfigurationProperty;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.Ordered;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="server", ignoreUnknownFields=true)
public class ServerProperties
implements EmbeddedServletContainerCustomizer,
EnvironmentAware,
Ordered {
    private Integer port;
    private InetAddress address;
    private String contextPath;
    private String displayName = "application";
    @NestedConfigurationProperty
    private ErrorProperties error = new ErrorProperties();
    private String servletPath = "/";
    private final Map<String, String> contextParameters = new HashMap<String, String>();
    private Boolean useForwardHeaders;
    private String serverHeader;
    private int maxHttpHeaderSize = 0;
    private int maxHttpPostSize = 0;
    private Integer connectionTimeout;
    private Session session = new Session();
    @NestedConfigurationProperty
    private Ssl ssl;
    @NestedConfigurationProperty
    private Compression compression = new Compression();
    @NestedConfigurationProperty
    private JspServlet jspServlet;
    private final Tomcat tomcat = new Tomcat();
    private final Jetty jetty = new Jetty();
    private final Undertow undertow = new Undertow();
    private Environment environment;

    public int getOrder() {
        return 0;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void customize(ConfigurableEmbeddedServletContainer container) {
        if (this.getPort() != null) {
            container.setPort(this.getPort().intValue());
        }
        if (this.getAddress() != null) {
            container.setAddress(this.getAddress());
        }
        if (this.getContextPath() != null) {
            container.setContextPath(this.getContextPath());
        }
        if (this.getDisplayName() != null) {
            container.setDisplayName(this.getDisplayName());
        }
        if (this.getSession().getTimeout() != null) {
            container.setSessionTimeout(this.getSession().getTimeout().intValue());
        }
        container.setPersistSession(this.getSession().isPersistent());
        container.setSessionStoreDir(this.getSession().getStoreDir());
        if (this.getSsl() != null) {
            container.setSsl(this.getSsl());
        }
        if (this.getJspServlet() != null) {
            container.setJspServlet(this.getJspServlet());
        }
        if (this.getCompression() != null) {
            container.setCompression(this.getCompression());
        }
        container.setServerHeader(this.getServerHeader());
        if (container instanceof TomcatEmbeddedServletContainerFactory) {
            this.getTomcat().customizeTomcat(this, (TomcatEmbeddedServletContainerFactory)container);
        }
        if (container instanceof JettyEmbeddedServletContainerFactory) {
            this.getJetty().customizeJetty(this, (JettyEmbeddedServletContainerFactory)container);
        }
        if (container instanceof UndertowEmbeddedServletContainerFactory) {
            this.getUndertow().customizeUndertow(this, (UndertowEmbeddedServletContainerFactory)container);
        }
        container.addInitializers(new ServletContextInitializer[]{new SessionConfiguringInitializer(this.session)});
        container.addInitializers(new ServletContextInitializer[]{new InitParameterConfiguringServletContextInitializer(this.getContextParameters())});
    }

    public String getServletMapping() {
        if (this.servletPath.equals("") || this.servletPath.equals("/")) {
            return "/";
        }
        if (this.servletPath.contains("*")) {
            return this.servletPath;
        }
        if (this.servletPath.endsWith("/")) {
            return this.servletPath + "*";
        }
        return this.servletPath + "/*";
    }

    public String getPath(String path) {
        String prefix = this.getServletPrefix();
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return prefix + path;
    }

    public String getServletPrefix() {
        String result = this.servletPath;
        if (result.contains("*")) {
            result = result.substring(0, result.indexOf("*"));
        }
        if (result.endsWith("/")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public String[] getPathsArray(Collection<String> paths) {
        String[] result = new String[paths.size()];
        int i = 0;
        for (String path : paths) {
            result[i++] = this.getPath(path);
        }
        return result;
    }

    public String[] getPathsArray(String[] paths) {
        String[] result = new String[paths.length];
        int i = 0;
        for (String path : paths) {
            result[i++] = this.getPath(path);
        }
        return result;
    }

    public void setLoader(String value) {
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public void setAddress(InetAddress address) {
        this.address = address;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = this.cleanContextPath(contextPath);
    }

    private String cleanContextPath(String contextPath) {
        if (StringUtils.hasText((String)contextPath) && contextPath.endsWith("/")) {
            return contextPath.substring(0, contextPath.length() - 1);
        }
        return contextPath;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public void setServletPath(String servletPath) {
        Assert.notNull((Object)servletPath, (String)"ServletPath must not be null");
        this.servletPath = servletPath;
    }

    public Map<String, String> getContextParameters() {
        return this.contextParameters;
    }

    public Boolean isUseForwardHeaders() {
        return this.useForwardHeaders;
    }

    public void setUseForwardHeaders(Boolean useForwardHeaders) {
        this.useForwardHeaders = useForwardHeaders;
    }

    public String getServerHeader() {
        return this.serverHeader;
    }

    public void setServerHeader(String serverHeader) {
        this.serverHeader = serverHeader;
    }

    public int getMaxHttpHeaderSize() {
        return this.maxHttpHeaderSize;
    }

    public void setMaxHttpHeaderSize(int maxHttpHeaderSize) {
        this.maxHttpHeaderSize = maxHttpHeaderSize;
    }

    @Deprecated
    @DeprecatedConfigurationProperty(reason="Use dedicated property for each container.")
    public int getMaxHttpPostSize() {
        return this.maxHttpPostSize;
    }

    @Deprecated
    public void setMaxHttpPostSize(int maxHttpPostSize) {
        this.maxHttpPostSize = maxHttpPostSize;
        this.jetty.setMaxHttpPostSize(maxHttpPostSize);
        this.tomcat.setMaxHttpPostSize(maxHttpPostSize);
        this.undertow.setMaxHttpPostSize(maxHttpPostSize);
    }

    protected final boolean getOrDeduceUseForwardHeaders() {
        if (this.useForwardHeaders != null) {
            return this.useForwardHeaders;
        }
        CloudPlatform platform = CloudPlatform.getActive((Environment)this.environment);
        return platform != null ? platform.isUsingForwardHeaders() : false;
    }

    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public ErrorProperties getError() {
        return this.error;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public Ssl getSsl() {
        return this.ssl;
    }

    public void setSsl(Ssl ssl) {
        this.ssl = ssl;
    }

    public Compression getCompression() {
        return this.compression;
    }

    public JspServlet getJspServlet() {
        return this.jspServlet;
    }

    public void setJspServlet(JspServlet jspServlet) {
        this.jspServlet = jspServlet;
    }

    public Tomcat getTomcat() {
        return this.tomcat;
    }

    public Jetty getJetty() {
        return this.jetty;
    }

    public Undertow getUndertow() {
        return this.undertow;
    }

    private static class SessionConfiguringInitializer
    implements ServletContextInitializer {
        private final Session session;

        SessionConfiguringInitializer(Session session) {
            this.session = session;
        }

        public void onStartup(ServletContext servletContext) throws ServletException {
            if (this.session.getTrackingModes() != null) {
                servletContext.setSessionTrackingModes(this.session.getTrackingModes());
            }
            this.configureSessionCookie(servletContext.getSessionCookieConfig());
        }

        private void configureSessionCookie(SessionCookieConfig config) {
            Session.Cookie cookie = this.session.getCookie();
            if (cookie.getName() != null) {
                config.setName(cookie.getName());
            }
            if (cookie.getDomain() != null) {
                config.setDomain(cookie.getDomain());
            }
            if (cookie.getPath() != null) {
                config.setPath(cookie.getPath());
            }
            if (cookie.getComment() != null) {
                config.setComment(cookie.getComment());
            }
            if (cookie.getHttpOnly() != null) {
                config.setHttpOnly(cookie.getHttpOnly().booleanValue());
            }
            if (cookie.getSecure() != null) {
                config.setSecure(cookie.getSecure().booleanValue());
            }
            if (cookie.getMaxAge() != null) {
                config.setMaxAge(cookie.getMaxAge().intValue());
            }
        }
    }

    public static class Undertow {
        private long maxHttpPostSize = -1L;
        private Integer bufferSize;
        @Deprecated
        private Integer buffersPerRegion;
        private Integer ioThreads;
        private Integer workerThreads;
        private Boolean directBuffers;
        private final Accesslog accesslog = new Accesslog();

        public long getMaxHttpPostSize() {
            return this.maxHttpPostSize;
        }

        public void setMaxHttpPostSize(long maxHttpPostSize) {
            this.maxHttpPostSize = maxHttpPostSize;
        }

        public Integer getBufferSize() {
            return this.bufferSize;
        }

        public void setBufferSize(Integer bufferSize) {
            this.bufferSize = bufferSize;
        }

        @DeprecatedConfigurationProperty(reason="The property is not used by Undertow. See https://issues.jboss.org/browse/UNDERTOW-587 for details")
        public Integer getBuffersPerRegion() {
            return this.buffersPerRegion;
        }

        public void setBuffersPerRegion(Integer buffersPerRegion) {
            this.buffersPerRegion = buffersPerRegion;
        }

        public Integer getIoThreads() {
            return this.ioThreads;
        }

        public void setIoThreads(Integer ioThreads) {
            this.ioThreads = ioThreads;
        }

        public Integer getWorkerThreads() {
            return this.workerThreads;
        }

        public void setWorkerThreads(Integer workerThreads) {
            this.workerThreads = workerThreads;
        }

        public Boolean getDirectBuffers() {
            return this.directBuffers;
        }

        public void setDirectBuffers(Boolean directBuffers) {
            this.directBuffers = directBuffers;
        }

        public Accesslog getAccesslog() {
            return this.accesslog;
        }

        void customizeUndertow(ServerProperties serverProperties, UndertowEmbeddedServletContainerFactory factory) {
            if (this.bufferSize != null) {
                factory.setBufferSize(this.bufferSize);
            }
            if (this.ioThreads != null) {
                factory.setIoThreads(this.ioThreads);
            }
            if (this.workerThreads != null) {
                factory.setWorkerThreads(this.workerThreads);
            }
            if (this.directBuffers != null) {
                factory.setDirectBuffers(this.directBuffers);
            }
            if (this.accesslog.enabled != null) {
                factory.setAccessLogEnabled(this.accesslog.enabled.booleanValue());
            }
            factory.setAccessLogDirectory(this.accesslog.dir);
            factory.setAccessLogPattern(this.accesslog.pattern);
            factory.setAccessLogPrefix(this.accesslog.prefix);
            factory.setAccessLogSuffix(this.accesslog.suffix);
            factory.setAccessLogRotate(this.accesslog.rotate);
            factory.setUseForwardHeaders(serverProperties.getOrDeduceUseForwardHeaders());
            if (serverProperties.getMaxHttpHeaderSize() > 0) {
                this.customizeMaxHttpHeaderSize(factory, serverProperties.getMaxHttpHeaderSize());
            }
            if (this.maxHttpPostSize > 0L) {
                this.customizeMaxHttpPostSize(factory, this.maxHttpPostSize);
            }
            if (serverProperties.getConnectionTimeout() != null) {
                this.customizeConnectionTimeout(factory, serverProperties.getConnectionTimeout());
            }
        }

        private void customizeConnectionTimeout(UndertowEmbeddedServletContainerFactory factory, final int connectionTimeout) {
            factory.addBuilderCustomizers(new UndertowBuilderCustomizer[]{new UndertowBuilderCustomizer(){

                public void customize(Undertow.Builder builder) {
                    builder.setSocketOption(UndertowOptions.NO_REQUEST_TIMEOUT, (Object)connectionTimeout);
                }
            }});
        }

        private void customizeMaxHttpHeaderSize(UndertowEmbeddedServletContainerFactory factory, final int maxHttpHeaderSize) {
            factory.addBuilderCustomizers(new UndertowBuilderCustomizer[]{new UndertowBuilderCustomizer(){

                public void customize(Undertow.Builder builder) {
                    builder.setServerOption(UndertowOptions.MAX_HEADER_SIZE, (Object)maxHttpHeaderSize);
                }
            }});
        }

        private void customizeMaxHttpPostSize(UndertowEmbeddedServletContainerFactory factory, final long maxHttpPostSize) {
            factory.addBuilderCustomizers(new UndertowBuilderCustomizer[]{new UndertowBuilderCustomizer(){

                public void customize(Undertow.Builder builder) {
                    builder.setServerOption(UndertowOptions.MAX_ENTITY_SIZE, (Object)maxHttpPostSize);
                }
            }});
        }

        public static class Accesslog {
            private Boolean enabled;
            private String pattern = "common";
            protected String prefix = "access_log.";
            private String suffix = "log";
            private File dir = new File("logs");
            private boolean rotate = true;

            public Boolean getEnabled() {
                return this.enabled;
            }

            public void setEnabled(Boolean enabled) {
                this.enabled = enabled;
            }

            public String getPattern() {
                return this.pattern;
            }

            public void setPattern(String pattern) {
                this.pattern = pattern;
            }

            public String getPrefix() {
                return this.prefix;
            }

            public void setPrefix(String prefix) {
                this.prefix = prefix;
            }

            public String getSuffix() {
                return this.suffix;
            }

            public void setSuffix(String suffix) {
                this.suffix = suffix;
            }

            public File getDir() {
                return this.dir;
            }

            public void setDir(File dir) {
                this.dir = dir;
            }

            public boolean isRotate() {
                return this.rotate;
            }

            public void setRotate(boolean rotate) {
                this.rotate = rotate;
            }
        }
    }

    public static class Jetty {
        private int maxHttpPostSize = 200000;
        private Integer acceptors = -1;
        private Integer selectors = -1;

        public int getMaxHttpPostSize() {
            return this.maxHttpPostSize;
        }

        public void setMaxHttpPostSize(int maxHttpPostSize) {
            this.maxHttpPostSize = maxHttpPostSize;
        }

        public Integer getAcceptors() {
            return this.acceptors;
        }

        public void setAcceptors(Integer acceptors) {
            this.acceptors = acceptors;
        }

        public Integer getSelectors() {
            return this.selectors;
        }

        public void setSelectors(Integer selectors) {
            this.selectors = selectors;
        }

        void customizeJetty(ServerProperties serverProperties, JettyEmbeddedServletContainerFactory factory) {
            factory.setUseForwardHeaders(serverProperties.getOrDeduceUseForwardHeaders());
            if (this.acceptors != null) {
                factory.setAcceptors(this.acceptors.intValue());
            }
            if (this.selectors != null) {
                factory.setSelectors(this.selectors.intValue());
            }
            if (serverProperties.getMaxHttpHeaderSize() > 0) {
                this.customizeMaxHttpHeaderSize(factory, serverProperties.getMaxHttpHeaderSize());
            }
            if (this.maxHttpPostSize > 0) {
                this.customizeMaxHttpPostSize(factory, this.maxHttpPostSize);
            }
            if (serverProperties.getConnectionTimeout() != null) {
                this.customizeConnectionTimeout(factory, serverProperties.getConnectionTimeout());
            }
        }

        private void customizeConnectionTimeout(JettyEmbeddedServletContainerFactory factory, final int connectionTimeout) {
            factory.addServerCustomizers(new JettyServerCustomizer[]{new JettyServerCustomizer(){

                public void customize(Server server) {
                    for (Connector connector : server.getConnectors()) {
                        if (!(connector instanceof AbstractConnector)) continue;
                        ((AbstractConnector)connector).setIdleTimeout((long)connectionTimeout);
                    }
                }
            }});
        }

        private void customizeMaxHttpHeaderSize(JettyEmbeddedServletContainerFactory factory, final int maxHttpHeaderSize) {
            factory.addServerCustomizers(new JettyServerCustomizer[]{new JettyServerCustomizer(){

                public void customize(Server server) {
                    for (Connector connector : server.getConnectors()) {
                        try {
                            for (ConnectionFactory connectionFactory : connector.getConnectionFactories()) {
                                if (!(connectionFactory instanceof HttpConfiguration.ConnectionFactory)) continue;
                                this.customize((HttpConfiguration.ConnectionFactory)connectionFactory);
                            }
                        }
                        catch (NoSuchMethodError ex) {
                            this.customizeOnJetty8(connector, maxHttpHeaderSize);
                        }
                    }
                }

                private void customize(HttpConfiguration.ConnectionFactory factory) {
                    HttpConfiguration configuration = factory.getHttpConfiguration();
                    configuration.setRequestHeaderSize(maxHttpHeaderSize);
                    configuration.setResponseHeaderSize(maxHttpHeaderSize);
                }

                private void customizeOnJetty8(Connector connector, int maxHttpHeaderSize2) {
                    try {
                        connector.getClass().getMethod("setRequestHeaderSize", Integer.TYPE).invoke((Object)connector, maxHttpHeaderSize2);
                        connector.getClass().getMethod("setResponseHeaderSize", Integer.TYPE).invoke((Object)connector, maxHttpHeaderSize2);
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                }
            }});
        }

        private void customizeMaxHttpPostSize(JettyEmbeddedServletContainerFactory factory, final int maxHttpPostSize) {
            factory.addServerCustomizers(new JettyServerCustomizer[]{new JettyServerCustomizer(){

                public void customize(Server server) {
                    this.setHandlerMaxHttpPostSize(maxHttpPostSize, server.getHandlers());
                }

                private void setHandlerMaxHttpPostSize(int maxHttpPostSize2, Handler ... handlers) {
                    for (Handler handler : handlers) {
                        if (handler instanceof ContextHandler) {
                            ((ContextHandler)handler).setMaxFormContentSize(maxHttpPostSize2);
                            continue;
                        }
                        if (handler instanceof HandlerWrapper) {
                            this.setHandlerMaxHttpPostSize(maxHttpPostSize2, ((HandlerWrapper)handler).getHandler());
                            continue;
                        }
                        if (!(handler instanceof HandlerCollection)) continue;
                        this.setHandlerMaxHttpPostSize(maxHttpPostSize2, ((HandlerCollection)handler).getHandlers());
                    }
                }
            }});
        }
    }

    public static class Tomcat {
        private final Accesslog accesslog = new Accesslog();
        private String internalProxies = "10\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}|192\\.168\\.\\d{1,3}\\.\\d{1,3}|169\\.254\\.\\d{1,3}\\.\\d{1,3}|127\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}|172\\.1[6-9]{1}\\.\\d{1,3}\\.\\d{1,3}|172\\.2[0-9]{1}\\.\\d{1,3}\\.\\d{1,3}|172\\.3[0-1]{1}\\.\\d{1,3}\\.\\d{1,3}|0:0:0:0:0:0:0:1|::1";
        private String protocolHeader;
        private String protocolHeaderHttpsValue = "https";
        private String portHeader = "X-Forwarded-Port";
        private String remoteIpHeader;
        private File basedir;
        private int backgroundProcessorDelay = 10;
        private int maxThreads = 200;
        private int minSpareThreads = 10;
        private int maxHttpPostSize = 0x200000;
        private int maxHttpHeaderSize = 0;
        private Boolean redirectContextRoot = true;
        private Charset uriEncoding = Charset.forName("UTF-8");
        private int maxConnections = 10000;
        private int acceptCount = 100;
        private List<String> additionalTldSkipPatterns = new ArrayList<String>();

        public int getMaxThreads() {
            return this.maxThreads;
        }

        public void setMaxThreads(int maxThreads) {
            this.maxThreads = maxThreads;
        }

        public int getMinSpareThreads() {
            return this.minSpareThreads;
        }

        public void setMinSpareThreads(int minSpareThreads) {
            this.minSpareThreads = minSpareThreads;
        }

        public int getMaxHttpPostSize() {
            return this.maxHttpPostSize;
        }

        public void setMaxHttpPostSize(int maxHttpPostSize) {
            this.maxHttpPostSize = maxHttpPostSize;
        }

        public Accesslog getAccesslog() {
            return this.accesslog;
        }

        public int getBackgroundProcessorDelay() {
            return this.backgroundProcessorDelay;
        }

        public void setBackgroundProcessorDelay(int backgroundProcessorDelay) {
            this.backgroundProcessorDelay = backgroundProcessorDelay;
        }

        public File getBasedir() {
            return this.basedir;
        }

        public void setBasedir(File basedir) {
            this.basedir = basedir;
        }

        public String getInternalProxies() {
            return this.internalProxies;
        }

        public void setInternalProxies(String internalProxies) {
            this.internalProxies = internalProxies;
        }

        public String getProtocolHeader() {
            return this.protocolHeader;
        }

        public void setProtocolHeader(String protocolHeader) {
            this.protocolHeader = protocolHeader;
        }

        public String getProtocolHeaderHttpsValue() {
            return this.protocolHeaderHttpsValue;
        }

        public void setProtocolHeaderHttpsValue(String protocolHeaderHttpsValue) {
            this.protocolHeaderHttpsValue = protocolHeaderHttpsValue;
        }

        public String getPortHeader() {
            return this.portHeader;
        }

        public void setPortHeader(String portHeader) {
            this.portHeader = portHeader;
        }

        public Boolean getRedirectContextRoot() {
            return this.redirectContextRoot;
        }

        public void setRedirectContextRoot(Boolean redirectContextRoot) {
            this.redirectContextRoot = redirectContextRoot;
        }

        public String getRemoteIpHeader() {
            return this.remoteIpHeader;
        }

        public void setRemoteIpHeader(String remoteIpHeader) {
            this.remoteIpHeader = remoteIpHeader;
        }

        public Charset getUriEncoding() {
            return this.uriEncoding;
        }

        public void setUriEncoding(Charset uriEncoding) {
            this.uriEncoding = uriEncoding;
        }

        public int getMaxConnections() {
            return this.maxConnections;
        }

        public void setMaxConnections(int maxConnections) {
            this.maxConnections = maxConnections;
        }

        public int getAcceptCount() {
            return this.acceptCount;
        }

        public void setAcceptCount(int acceptCount) {
            this.acceptCount = acceptCount;
        }

        public List<String> getAdditionalTldSkipPatterns() {
            return this.additionalTldSkipPatterns;
        }

        public void setAdditionalTldSkipPatterns(List<String> additionalTldSkipPatterns) {
            this.additionalTldSkipPatterns = additionalTldSkipPatterns;
        }

        void customizeTomcat(ServerProperties serverProperties, TomcatEmbeddedServletContainerFactory factory) {
            Session.Cookie cookie;
            int maxHttpHeaderSize;
            if (this.getBasedir() != null) {
                factory.setBaseDirectory(this.getBasedir());
            }
            factory.setBackgroundProcessorDelay(this.backgroundProcessorDelay);
            this.customizeRemoteIpValve(serverProperties, factory);
            if (this.maxThreads > 0) {
                this.customizeMaxThreads(factory);
            }
            if (this.minSpareThreads > 0) {
                this.customizeMinThreads(factory);
            }
            int n = maxHttpHeaderSize = serverProperties.getMaxHttpHeaderSize() > 0 ? serverProperties.getMaxHttpHeaderSize() : this.maxHttpHeaderSize;
            if (maxHttpHeaderSize > 0) {
                this.customizeMaxHttpHeaderSize(factory, maxHttpHeaderSize);
            }
            if (this.maxHttpPostSize != 0) {
                this.customizeMaxHttpPostSize(factory, this.maxHttpPostSize);
            }
            if (this.accesslog.enabled) {
                this.customizeAccessLog(factory);
            }
            if (this.getUriEncoding() != null) {
                factory.setUriEncoding(this.getUriEncoding());
            }
            if (serverProperties.getConnectionTimeout() != null) {
                this.customizeConnectionTimeout(factory, serverProperties.getConnectionTimeout());
            }
            if (this.redirectContextRoot != null) {
                this.customizeRedirectContextRoot(factory, this.redirectContextRoot);
            }
            if (this.maxConnections > 0) {
                this.customizeMaxConnections(factory);
            }
            if (this.acceptCount > 0) {
                this.customizeAcceptCount(factory);
            }
            if (!ObjectUtils.isEmpty(this.additionalTldSkipPatterns)) {
                factory.getTldSkipPatterns().addAll(this.additionalTldSkipPatterns);
            }
            if (serverProperties.getError().getIncludeStacktrace() == ErrorProperties.IncludeStacktrace.NEVER) {
                this.customizeErrorReportValve(factory);
            }
            if ((cookie = serverProperties.getSession().getCookie()).getHttpOnly() != null) {
                factory.addContextCustomizers(new TomcatContextCustomizer[]{new TomcatContextCustomizer(){

                    public void customize(Context context) {
                        context.setUseHttpOnly(cookie.getHttpOnly().booleanValue());
                    }
                }});
            }
        }

        private void customizeErrorReportValve(TomcatEmbeddedServletContainerFactory factory) {
            factory.addContextCustomizers(new TomcatContextCustomizer[]{new TomcatContextCustomizer(){

                public void customize(Context context) {
                    ErrorReportValve valve = new ErrorReportValve();
                    valve.setShowServerInfo(false);
                    valve.setShowReport(false);
                    context.getParent().getPipeline().addValve((Valve)valve);
                }
            }});
        }

        private void customizeAcceptCount(TomcatEmbeddedServletContainerFactory factory) {
            factory.addConnectorCustomizers(new TomcatConnectorCustomizer[]{new TomcatConnectorCustomizer(){

                public void customize(org.apache.catalina.connector.Connector connector) {
                    ProtocolHandler handler = connector.getProtocolHandler();
                    if (handler instanceof AbstractProtocol) {
                        AbstractProtocol protocol = (AbstractProtocol)handler;
                        protocol.setBacklog(Tomcat.this.acceptCount);
                    }
                }
            }});
        }

        private void customizeMaxConnections(TomcatEmbeddedServletContainerFactory factory) {
            factory.addConnectorCustomizers(new TomcatConnectorCustomizer[]{new TomcatConnectorCustomizer(){

                public void customize(org.apache.catalina.connector.Connector connector) {
                    ProtocolHandler handler = connector.getProtocolHandler();
                    if (handler instanceof AbstractProtocol) {
                        AbstractProtocol protocol = (AbstractProtocol)handler;
                        protocol.setMaxConnections(Tomcat.this.maxConnections);
                    }
                }
            }});
        }

        private void customizeConnectionTimeout(TomcatEmbeddedServletContainerFactory factory, final int connectionTimeout) {
            factory.addConnectorCustomizers(new TomcatConnectorCustomizer[]{new TomcatConnectorCustomizer(){

                public void customize(org.apache.catalina.connector.Connector connector) {
                    ProtocolHandler handler = connector.getProtocolHandler();
                    if (handler instanceof AbstractProtocol) {
                        AbstractProtocol protocol = (AbstractProtocol)handler;
                        protocol.setConnectionTimeout(connectionTimeout);
                    }
                }
            }});
        }

        private void customizeRemoteIpValve(ServerProperties properties, TomcatEmbeddedServletContainerFactory factory) {
            String protocolHeader = this.getProtocolHeader();
            String remoteIpHeader = this.getRemoteIpHeader();
            if (StringUtils.hasText((String)protocolHeader) || StringUtils.hasText((String)remoteIpHeader) || properties.getOrDeduceUseForwardHeaders()) {
                RemoteIpValve valve = new RemoteIpValve();
                valve.setProtocolHeader(StringUtils.hasLength((String)protocolHeader) ? protocolHeader : "X-Forwarded-Proto");
                if (StringUtils.hasLength((String)remoteIpHeader)) {
                    valve.setRemoteIpHeader(remoteIpHeader);
                }
                valve.setInternalProxies(this.getInternalProxies());
                valve.setPortHeader(this.getPortHeader());
                valve.setProtocolHeaderHttpsValue(this.getProtocolHeaderHttpsValue());
                factory.addEngineValves(new Valve[]{valve});
            }
        }

        private void customizeMaxThreads(TomcatEmbeddedServletContainerFactory factory) {
            factory.addConnectorCustomizers(new TomcatConnectorCustomizer[]{new TomcatConnectorCustomizer(){

                public void customize(org.apache.catalina.connector.Connector connector) {
                    ProtocolHandler handler = connector.getProtocolHandler();
                    if (handler instanceof AbstractProtocol) {
                        AbstractProtocol protocol = (AbstractProtocol)handler;
                        protocol.setMaxThreads(Tomcat.this.maxThreads);
                    }
                }
            }});
        }

        private void customizeMinThreads(TomcatEmbeddedServletContainerFactory factory) {
            factory.addConnectorCustomizers(new TomcatConnectorCustomizer[]{new TomcatConnectorCustomizer(){

                public void customize(org.apache.catalina.connector.Connector connector) {
                    ProtocolHandler handler = connector.getProtocolHandler();
                    if (handler instanceof AbstractProtocol) {
                        AbstractProtocol protocol = (AbstractProtocol)handler;
                        protocol.setMinSpareThreads(Tomcat.this.minSpareThreads);
                    }
                }
            }});
        }

        private void customizeMaxHttpHeaderSize(TomcatEmbeddedServletContainerFactory factory, final int maxHttpHeaderSize) {
            factory.addConnectorCustomizers(new TomcatConnectorCustomizer[]{new TomcatConnectorCustomizer(){

                public void customize(org.apache.catalina.connector.Connector connector) {
                    ProtocolHandler handler = connector.getProtocolHandler();
                    if (handler instanceof AbstractHttp11Protocol) {
                        AbstractHttp11Protocol protocol = (AbstractHttp11Protocol)handler;
                        protocol.setMaxHttpHeaderSize(maxHttpHeaderSize);
                    }
                }
            }});
        }

        private void customizeMaxHttpPostSize(TomcatEmbeddedServletContainerFactory factory, final int maxHttpPostSize) {
            factory.addConnectorCustomizers(new TomcatConnectorCustomizer[]{new TomcatConnectorCustomizer(){

                public void customize(org.apache.catalina.connector.Connector connector) {
                    connector.setMaxPostSize(maxHttpPostSize);
                }
            }});
        }

        private void customizeAccessLog(TomcatEmbeddedServletContainerFactory factory) {
            AccessLogValve valve = new AccessLogValve();
            valve.setPattern(this.accesslog.getPattern());
            valve.setDirectory(this.accesslog.getDirectory());
            valve.setPrefix(this.accesslog.getPrefix());
            valve.setSuffix(this.accesslog.getSuffix());
            valve.setRenameOnRotate(this.accesslog.isRenameOnRotate());
            valve.setRequestAttributesEnabled(this.accesslog.isRequestAttributesEnabled());
            valve.setRotatable(this.accesslog.isRotate());
            valve.setBuffered(this.accesslog.isBuffered());
            valve.setFileDateFormat(this.accesslog.getFileDateFormat());
            factory.addEngineValves(new Valve[]{valve});
        }

        private void customizeRedirectContextRoot(TomcatEmbeddedServletContainerFactory factory, final boolean redirectContextRoot) {
            factory.addContextCustomizers(new TomcatContextCustomizer[]{new TomcatContextCustomizer(){

                public void customize(Context context) {
                    try {
                        context.setMapperContextRootRedirectEnabled(redirectContextRoot);
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        // empty catch block
                    }
                }
            }});
        }

        public static class Accesslog {
            private boolean enabled = false;
            private String pattern = "common";
            private String directory = "logs";
            protected String prefix = "access_log";
            private String suffix = ".log";
            private boolean rotate = true;
            private boolean renameOnRotate = false;
            private String fileDateFormat = ".yyyy-MM-dd";
            private boolean requestAttributesEnabled = false;
            private boolean buffered = true;

            public boolean isEnabled() {
                return this.enabled;
            }

            public void setEnabled(boolean enabled) {
                this.enabled = enabled;
            }

            public String getPattern() {
                return this.pattern;
            }

            public void setPattern(String pattern) {
                this.pattern = pattern;
            }

            public String getDirectory() {
                return this.directory;
            }

            public void setDirectory(String directory) {
                this.directory = directory;
            }

            public String getPrefix() {
                return this.prefix;
            }

            public void setPrefix(String prefix) {
                this.prefix = prefix;
            }

            public String getSuffix() {
                return this.suffix;
            }

            public void setSuffix(String suffix) {
                this.suffix = suffix;
            }

            public boolean isRotate() {
                return this.rotate;
            }

            public void setRotate(boolean rotate) {
                this.rotate = rotate;
            }

            public boolean isRenameOnRotate() {
                return this.renameOnRotate;
            }

            public void setRenameOnRotate(boolean renameOnRotate) {
                this.renameOnRotate = renameOnRotate;
            }

            public String getFileDateFormat() {
                return this.fileDateFormat;
            }

            public void setFileDateFormat(String fileDateFormat) {
                this.fileDateFormat = fileDateFormat;
            }

            public boolean isRequestAttributesEnabled() {
                return this.requestAttributesEnabled;
            }

            public void setRequestAttributesEnabled(boolean requestAttributesEnabled) {
                this.requestAttributesEnabled = requestAttributesEnabled;
            }

            public boolean isBuffered() {
                return this.buffered;
            }

            public void setBuffered(boolean buffered) {
                this.buffered = buffered;
            }
        }
    }

    public static class Session {
        private Integer timeout;
        private Set<SessionTrackingMode> trackingModes;
        private boolean persistent;
        private File storeDir;
        private Cookie cookie = new Cookie();

        public Cookie getCookie() {
            return this.cookie;
        }

        public Integer getTimeout() {
            return this.timeout;
        }

        public void setTimeout(Integer sessionTimeout) {
            this.timeout = sessionTimeout;
        }

        public Set<SessionTrackingMode> getTrackingModes() {
            return this.trackingModes;
        }

        public void setTrackingModes(Set<SessionTrackingMode> trackingModes) {
            this.trackingModes = trackingModes;
        }

        public boolean isPersistent() {
            return this.persistent;
        }

        public void setPersistent(boolean persistent) {
            this.persistent = persistent;
        }

        public File getStoreDir() {
            return this.storeDir;
        }

        public void setStoreDir(File storeDir) {
            this.storeDir = storeDir;
        }

        public static class Cookie {
            private String name;
            private String domain;
            private String path;
            private String comment;
            private Boolean httpOnly;
            private Boolean secure;
            private Integer maxAge;

            public String getName() {
                return this.name;
            }

            public void setName(String name) {
                this.name = name;
            }

            public String getDomain() {
                return this.domain;
            }

            public void setDomain(String domain) {
                this.domain = domain;
            }

            public String getPath() {
                return this.path;
            }

            public void setPath(String path) {
                this.path = path;
            }

            public String getComment() {
                return this.comment;
            }

            public void setComment(String comment) {
                this.comment = comment;
            }

            public Boolean getHttpOnly() {
                return this.httpOnly;
            }

            public void setHttpOnly(Boolean httpOnly) {
                this.httpOnly = httpOnly;
            }

            public Boolean getSecure() {
                return this.secure;
            }

            public void setSecure(Boolean secure) {
                this.secure = secure;
            }

            public Integer getMaxAge() {
                return this.maxAge;
            }

            public void setMaxAge(Integer maxAge) {
                this.maxAge = maxAge;
            }
        }
    }
}

