/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.xhtml.extension;

import fr.opensagres.xdocreport.xhtml.extension.AbstractContentBuffer;
import fr.opensagres.xdocreport.xhtml.extension.CSSStylePropertyConstants;
import fr.opensagres.xdocreport.xhtml.extension.XHTMLConstants;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public class CSSStyleSheet
extends AbstractContentBuffer
implements XHTMLConstants,
CSSStylePropertyConstants {
    private StringBuilder cssStyles = new StringBuilder();

    public CSSStyleSheet(int indent) {
        super(indent);
        this.startCSSStyleDeclaration("p");
        this.setCSSProperty("margin-top", "0");
        this.setCSSProperty("margin-bottom", "0");
        this.endCSSStyleDeclaration();
        this.startCSSStyleDeclaration("ol");
        this.setCSSProperty("margin-top", "0");
        this.setCSSProperty("margin-bottom", "0");
        this.endCSSStyleDeclaration();
        this.startCSSStyleDeclaration("ul");
        this.setCSSProperty("margin-top", "0");
        this.setCSSProperty("margin-bottom", "0");
        this.endCSSStyleDeclaration();
    }

    public void save(Writer writer) throws IOException {
        writer.write(this.cssStyles.toString());
    }

    public void save(OutputStream out) throws IOException {
        out.write(this.cssStyles.toString().getBytes());
    }

    public boolean isEmpty() {
        return this.cssStyles.length() == 0;
    }

    public void setComment(String comment) {
        this.doIndentIfNeeded(1);
        this.cssStyles.append('/');
        this.cssStyles.append('*');
        this.cssStyles.append(comment);
        this.cssStyles.append('*');
        this.cssStyles.append('/');
    }

    @Override
    protected StringBuilder getCurrentBuffer() {
        return this.cssStyles;
    }

    public void startCSSStyleDeclaration(String selector) {
        this.doIndentIfNeeded(1);
        this.cssStyles.append(selector);
        this.cssStyles.append(' ');
        this.cssStyles.append('{');
    }

    public void endCSSStyleDeclaration() {
        this.doIndentIfNeeded(1);
        this.cssStyles.append('}');
    }

    public void setCSSProperty(String name, String value) {
        this.doIndentIfNeeded(2);
        this.cssStyles.append(name);
        this.cssStyles.append(':');
        this.cssStyles.append(value);
        this.cssStyles.append(';');
    }

    protected void doIndentIfNeeded(int subIndent) {
        this.doIndentIfNeeded(this.getCurrentBuffer(), this.indent > 0 ? this.indent + subIndent : 0);
    }
}

