/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.validation;

import grails.core.GrailsDomainClass;
import grails.core.GrailsDomainClassProperty;
import java.util.ArrayList;
import org.grails.datastore.gorm.GormValidateable;
import org.grails.datastore.gorm.support.BeforeValidateHelper;
import org.grails.datastore.gorm.validation.CascadingValidator;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.proxy.JavassistProxyFactory;
import org.grails.datastore.mapping.proxy.ProxyFactory;
import org.grails.validation.GrailsDomainClassValidator;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.MessageSourceAware;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;

public class DefaultDomainClassValidator
extends GrailsDomainClassValidator
implements MessageSourceAware,
CascadingValidator,
grails.validation.CascadingValidator,
ApplicationContextAware {
    private final BeforeValidateHelper beforeValidateHelper = new BeforeValidateHelper();
    private ProxyFactory proxyHandler = new JavassistProxyFactory();
    private Datastore datastore;
    private String datastoreName;
    private ApplicationContext applicationContext;

    public BeforeValidateHelper getBeforeValidateHelper() {
        return this.beforeValidateHelper;
    }

    public void setDatastoreName(String datastoreName) {
        this.datastoreName = datastoreName;
    }

    public Datastore getDatastore() {
        if (this.datastoreName == null) {
            throw new IllegalStateException("Not datastore name configured. Please provide one");
        }
        if (this.datastore != null) {
            return this.datastore;
        }
        this.datastore = (Datastore)this.applicationContext.getBean(this.datastoreName, Datastore.class);
        return this.datastore;
    }

    protected GrailsDomainClass getAssociatedDomainClassFromApplication(Object associatedObject) {
        String associatedObjectType = this.proxyHandler.getProxiedClass(associatedObject).getName();
        return (GrailsDomainClass)this.grailsApplication.getArtefact("Domain", associatedObjectType);
    }

    @Autowired(required=false)
    public void setProxyFactory(ProxyFactory proxyHandler) {
        this.proxyHandler = proxyHandler;
    }

    protected void cascadeValidationToMany(Errors errors, BeanWrapper bean, GrailsDomainClassProperty persistentProperty, String propertyName) {
        Object collection = bean.getPropertyValue(propertyName);
        if (collection == null) {
            return;
        }
        if (this.proxyHandler.isProxy(collection)) {
            if (this.proxyHandler.isInitialized(collection)) {
                super.cascadeValidationToMany(errors, bean, persistentProperty, propertyName);
            }
        } else {
            super.cascadeValidationToMany(errors, bean, persistentProperty, propertyName);
        }
    }

    protected void cascadeValidationToOne(Errors errors, BeanWrapper bean, Object associatedObject, GrailsDomainClassProperty persistentProperty, String propertyName, Object indexOrKey) {
        if (this.proxyHandler.isInitialized(associatedObject)) {
            Object object = associatedObject = this.proxyHandler.isProxy(associatedObject) ? this.proxyHandler.unwrap(associatedObject) : associatedObject;
            if (associatedObject != null) {
                this.cascadeBeforeValidate(associatedObject);
                GrailsDomainClass associatedDomainClass = this.getAssociatedDomainClass(associatedObject, persistentProperty);
                if (associatedDomainClass == null || !this.isOwningInstance(bean, associatedDomainClass) && !persistentProperty.isExplicitSaveUpdateCascade()) {
                    GormValidateable validateable;
                    Errors existingErrors;
                    if (associatedObject instanceof GormValidateable && (persistentProperty.isOneToOne() || persistentProperty.isManyToOne()) && (existingErrors = (validateable = (GormValidateable)associatedObject).getErrors()) != null && existingErrors.hasErrors()) {
                        for (FieldError error : existingErrors.getFieldErrors()) {
                            String path = propertyName + '.' + error.getField();
                            errors.rejectValue(path, error.getCode(), error.getArguments(), error.getDefaultMessage());
                        }
                    }
                } else {
                    super.cascadeValidationToOne(errors, bean, associatedObject, persistentProperty, propertyName, indexOrKey);
                }
            }
        }
    }

    protected void cascadeBeforeValidate(Object associatedObject) {
        GrailsDomainClass associatedDomainClass = this.getAssociatedDomainClassFromApplication(associatedObject);
        if (associatedDomainClass != null) {
            this.getBeforeValidateHelper().invokeBeforeValidate(associatedObject, new ArrayList(associatedDomainClass.getConstrainedProperties().keySet()));
        }
    }

    private GrailsDomainClass getAssociatedDomainClass(Object associatedObject, GrailsDomainClassProperty persistentProperty) {
        if (persistentProperty.isEmbedded()) {
            return persistentProperty.getComponent();
        }
        if (this.grailsApplication != null) {
            return this.getAssociatedDomainClassFromApplication(associatedObject);
        }
        return persistentProperty.getReferencedDomainClass();
    }

    private boolean isOwningInstance(BeanWrapper bean, GrailsDomainClass associatedDomainClass) {
        for (Class currentClass = bean.getWrappedClass(); currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            if (!associatedDomainClass.isOwningClass(currentClass)) continue;
            return true;
        }
        return false;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

