/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.dateandtime.joda.columnmapper;

import java.sql.Timestamp;
import org.jadira.usertype.dateandtime.joda.util.Formatter;
import org.jadira.usertype.dateandtime.shared.spi.AbstractTimestampColumnMapper;
import org.joda.time.LocalTime;
import org.joda.time.ReadablePartial;

public class TimestampColumnLocalTimeMapper
extends AbstractTimestampColumnMapper<LocalTime> {
    private static final long serialVersionUID = 1921591625617366103L;

    public LocalTime fromNonNullString(String s) {
        return new LocalTime((Object)s);
    }

    public LocalTime fromNonNullValue(Timestamp value) {
        return Formatter.LOCAL_DATETIME_PARSER.parseDateTime(value.toString()).toLocalTime();
    }

    public String toNonNullString(LocalTime value) {
        return value.toString();
    }

    public Timestamp toNonNullValue(LocalTime value) {
        String formattedTimestamp = Formatter.LOCAL_DATETIME_PRINTER.print((ReadablePartial)value);
        if (formattedTimestamp.endsWith(".")) {
            formattedTimestamp = formattedTimestamp.substring(0, formattedTimestamp.length() - 1);
        }
        Timestamp timestamp = Timestamp.valueOf(formattedTimestamp);
        return timestamp;
    }
}

