/*
 * Decompiled with CFR 0.152.
 */
package asset.pipeline.grails.utils.net;

import asset.pipeline.utils.net.Urls;
import javax.servlet.http.HttpServletRequest;
import org.grails.web.util.WebUtils;

public final class HttpServletRequests {
    public static String getScheme(HttpServletRequest req) {
        String forwardedScheme = req.getHeader("x-forwarded-proto");
        return forwardedScheme == null ? req.getScheme() : forwardedScheme;
    }

    public static int getPort(HttpServletRequest req) {
        String forwardedPort = req.getHeader("x-forwarded-port");
        return forwardedPort == null ? req.getServerPort() : Integer.parseInt(forwardedPort);
    }

    public static StringBuilder getAuthorityUrl(HttpServletRequest req, Object o) {
        return o == null ? HttpServletRequests.getAuthorityUrlWithScheme(req) : (o instanceof Boolean ? HttpServletRequests.getAuthorityUrl(req, (Boolean)o) : HttpServletRequests.getAuthorityUrlWithScheme(req, o.toString()));
    }

    public static StringBuilder getAuthorityUrl(HttpServletRequest req, boolean retainScheme) {
        return retainScheme ? HttpServletRequests.getAuthorityUrlWithScheme(req) : HttpServletRequests.getAuthorityUrlSansScheme(req);
    }

    public static StringBuilder getAuthorityUrlWithScheme(HttpServletRequest req) {
        return HttpServletRequests.getAuthorityUrlWithScheme(req, HttpServletRequests.getScheme(req), true);
    }

    public static StringBuilder getAuthorityUrlWithScheme(HttpServletRequest req, String scheme) {
        return HttpServletRequests.getAuthorityUrlWithScheme(req, scheme, HttpServletRequests.getScheme(req).equals(scheme));
    }

    public static StringBuilder getAuthorityUrlWithScheme(HttpServletRequest req, String scheme, boolean includeNonDefaultPort) {
        return HttpServletRequests.getAuthorityUrlSansScheme(req, includeNonDefaultPort, new StringBuilder().append(scheme).append(':'));
    }

    public static StringBuilder getAuthorityUrlSansScheme(HttpServletRequest req) {
        return HttpServletRequests.getAuthorityUrlSansScheme(req, false);
    }

    public static StringBuilder getAuthorityUrlSansScheme(HttpServletRequest req, String schemeToIncludeNonDefaultPort) {
        return HttpServletRequests.getAuthorityUrlSansScheme(req, HttpServletRequests.getScheme(req).equals(schemeToIncludeNonDefaultPort));
    }

    public static StringBuilder getAuthorityUrlSansScheme(HttpServletRequest req, boolean includeNonDefaultPort) {
        return HttpServletRequests.getAuthorityUrlSansScheme(req, includeNonDefaultPort, new StringBuilder());
    }

    private static StringBuilder getAuthorityUrlSansScheme(HttpServletRequest req, boolean includeNonDefaultPort, StringBuilder urlSb) {
        int port;
        urlSb.append("//").append(req.getServerName());
        if (includeNonDefaultPort && (port = HttpServletRequests.getPort(req)) >= 0 && port != Urls.getDefaultPort((String)HttpServletRequests.getScheme(req))) {
            urlSb.append(':').append(port);
        }
        return urlSb;
    }

    public static StringBuilder getBaseUrl(HttpServletRequest req, Object o) {
        return o == null ? HttpServletRequests.getBaseUrlWithScheme(req) : (o instanceof Boolean ? HttpServletRequests.getBaseUrl(req, (Boolean)o) : HttpServletRequests.getBaseUrlWithScheme(req, o.toString()));
    }

    public static StringBuilder getBaseUrl(HttpServletRequest req, boolean retainScheme) {
        return retainScheme ? HttpServletRequests.getBaseUrlWithScheme(req) : HttpServletRequests.getBaseUrlSansScheme(req);
    }

    public static StringBuilder getBaseUrlWithScheme(HttpServletRequest req) {
        return HttpServletRequests.getBaseUrlWithScheme(req, HttpServletRequests.getScheme(req), true);
    }

    public static StringBuilder getBaseUrlWithScheme(HttpServletRequest req, String scheme) {
        return HttpServletRequests.getBaseUrlWithScheme(req, scheme, HttpServletRequests.getScheme(req).equals(scheme));
    }

    public static StringBuilder getBaseUrlWithScheme(HttpServletRequest req, String scheme, boolean includeNonDefaultPort) {
        return HttpServletRequests.getBaseUrlSansScheme(req, includeNonDefaultPort, new StringBuilder().append(scheme).append(':'));
    }

    public static StringBuilder getBaseUrlSansScheme(HttpServletRequest req) {
        return HttpServletRequests.getBaseUrlSansScheme(req, false);
    }

    public static StringBuilder getBaseUrlSansScheme(HttpServletRequest req, String schemeToIncludeNonDefaultPort) {
        return HttpServletRequests.getBaseUrlSansScheme(req, HttpServletRequests.getScheme(req).equals(schemeToIncludeNonDefaultPort));
    }

    public static StringBuilder getBaseUrlSansScheme(HttpServletRequest req, boolean includeNonDefaultPort) {
        return HttpServletRequests.getBaseUrlSansScheme(req, includeNonDefaultPort, new StringBuilder());
    }

    private static StringBuilder getBaseUrlSansScheme(HttpServletRequest req, boolean includeNonDefaultPort, StringBuilder urlSb) {
        return HttpServletRequests.getAuthorityUrlSansScheme(req, includeNonDefaultPort, urlSb).append(req.getContextPath());
    }

    public static String prependBaseUrlWithScheme(HttpServletRequest req, String url) {
        return Urls.hasAuthority((String)url) ? url : HttpServletRequests.getBaseUrlWithScheme(req).append(url).toString();
    }

    public static StringBuilder getForwardUrl(HttpServletRequest req, Object o) {
        return o == null ? HttpServletRequests.getForwardUrlWithScheme(req) : (o instanceof Boolean ? HttpServletRequests.getForwardUrl(req, (Boolean)o) : HttpServletRequests.getForwardUrlWithScheme(req, o.toString()));
    }

    public static StringBuilder getForwardUrl(HttpServletRequest req, boolean retainScheme) {
        return retainScheme ? HttpServletRequests.getForwardUrlWithScheme(req) : HttpServletRequests.getForwardUrlSansScheme(req);
    }

    public static StringBuilder getForwardUrlWithScheme(HttpServletRequest req) {
        return HttpServletRequests.getForwardUrlWithScheme(req, HttpServletRequests.getScheme(req), true);
    }

    public static StringBuilder getForwardUrlWithScheme(HttpServletRequest req, String scheme) {
        return HttpServletRequests.getForwardUrlWithScheme(req, scheme, HttpServletRequests.getScheme(req).equals(scheme));
    }

    public static StringBuilder getForwardUrlWithScheme(HttpServletRequest req, String scheme, boolean includeNonDefaultPort) {
        return HttpServletRequests.getForwardUrlSansScheme(req, includeNonDefaultPort, new StringBuilder().append(scheme).append(':'));
    }

    public static StringBuilder getForwardUrlSansScheme(HttpServletRequest req) {
        return HttpServletRequests.getForwardUrlSansScheme(req, false);
    }

    public static StringBuilder getForwardUrlSansScheme(HttpServletRequest req, String schemeToIncludeNonDefaultPort) {
        return HttpServletRequests.getForwardUrlSansScheme(req, HttpServletRequests.getScheme(req).equals(schemeToIncludeNonDefaultPort));
    }

    public static StringBuilder getForwardUrlSansScheme(HttpServletRequest req, boolean includeNonDefaultPort) {
        return HttpServletRequests.getForwardUrlSansScheme(req, includeNonDefaultPort, new StringBuilder());
    }

    private static StringBuilder getForwardUrlSansScheme(HttpServletRequest req, boolean includeNonDefaultPort, StringBuilder urlSb) {
        return HttpServletRequests.getAuthorityUrlSansScheme(req, includeNonDefaultPort, urlSb).append(WebUtils.getForwardURI((HttpServletRequest)req));
    }

    private HttpServletRequests() {
    }
}

