/*
 * Decompiled with CFR 0.152.
 */
package liquibase.example;

import java.sql.Connection;
import java.sql.DriverManager;

public class StartH2Main {
    private static final String dbPort = "9090";
    private static final String webPort = "8090";
    private static final String username = "dbuser";
    private static final String password = "letmein";

    public static void main(String[] args) throws Exception {
        System.out.println("Starting Example H2 Database...");
        System.out.println("NOTE: The database does not persist data, so stopping and restarting this process will reset it back to a blank database");
        System.out.println();
        Class.forName("org.h2.Driver");
        try {
            Connection devConnection = DriverManager.getConnection("jdbc:h2:mem:dev", username, password);
            Throwable throwable = null;
            try {
                try {
                    Connection intConnection = DriverManager.getConnection("jdbc:h2:mem:integration", username, password);
                    Throwable throwable2 = null;
                    try {
                        try {
                            StartH2Main.startTcpServer();
                            Object webServer = StartH2Main.startWebServer();
                            String devUrl = StartH2Main.createWebSession(devConnection, webServer, true);
                            String intUrl = StartH2Main.createWebSession(intConnection, webServer, false);
                            System.out.println("Connection Information:" + System.lineSeparator() + "  Dev database: " + System.lineSeparator() + "    JDBC URL: jdbc:h2:tcp://localhost:" + dbPort + "/mem:dev" + System.lineSeparator() + "    Username: " + username + System.lineSeparator() + "    Password: " + password + System.lineSeparator() + "  Integration database: " + System.lineSeparator() + "    JDBC URL: jdbc:h2:tcp://localhost:" + dbPort + "/mem:integration" + System.lineSeparator() + "    Username: " + username + System.lineSeparator() + "    Password: " + password + System.lineSeparator() + "" + System.lineSeparator() + "Opening Database Console in Browser..." + System.lineSeparator() + "  Dev Web URL: " + devUrl + System.lineSeparator() + "  Integration Web URL: " + intUrl + System.lineSeparator());
                            while (true) {
                                Thread.sleep(60000L);
                            }
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable4) {
                        if (intConnection != null) {
                            if (throwable2 != null) {
                                try {
                                    intConnection.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable2.addSuppressed(throwable5);
                                }
                            } else {
                                intConnection.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (Throwable throwable6) {
                    throwable = throwable6;
                    throw throwable6;
                }
            }
            catch (Throwable throwable7) {
                if (devConnection != null) {
                    if (throwable != null) {
                        try {
                            devConnection.close();
                        }
                        catch (Throwable throwable8) {
                            throwable.addSuppressed(throwable8);
                        }
                    } else {
                        devConnection.close();
                    }
                }
                throw throwable7;
            }
        }
        catch (Throwable e2) {
            System.err.println("Error starting H2");
            e2.printStackTrace();
            System.exit(-1);
            return;
        }
    }

    protected static void startTcpServer() throws Exception {
        Class<?> serverClass = Class.forName("org.h2.tools.Server");
        Object tcpServer = serverClass.getMethod("createTcpServer", String[].class).invoke(null, new Object[]{new String[]{"-tcpAllowOthers", "-tcpPort", dbPort}});
        tcpServer.getClass().getMethod("start", new Class[0]).invoke(tcpServer, new Object[0]);
    }

    protected static Object startWebServer() throws Exception {
        Class<?> serverClass = Class.forName("org.h2.tools.Server");
        Object webServer = Class.forName("org.h2.server.web.WebServer").newInstance();
        Object web = serverClass.getConstructor(Class.forName("org.h2.server.Service"), String[].class).newInstance(webServer, new String[]{"-webPort", webPort});
        web.getClass().getMethod("start", new Class[0]).invoke(web, new Object[0]);
        return webServer;
    }

    private static String createWebSession(Connection connection, Object webServer, boolean openBrowser) throws Exception {
        Class<?> serverClass = Class.forName("org.h2.tools.Server");
        String url = (String)webServer.getClass().getMethod("addSession", Connection.class).invoke(webServer, connection);
        if (openBrowser) {
            try {
                serverClass.getMethod("openBrowser", String.class).invoke(null, url);
            }
            catch (Exception e2) {
                String message = e2.getMessage();
                if (message == null && e2.getCause() != null) {
                    message = e2.getCause().getMessage();
                }
                System.out.println("Cannot open browser: " + message);
                System.out.println("");
            }
        }
        return url;
    }
}

