/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.packet.dao.parameters;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.mariadb.jdbc.internal.MariaDbType;
import org.mariadb.jdbc.internal.packet.dao.parameters.LongDataParameter;
import org.mariadb.jdbc.internal.packet.dao.parameters.ParameterWriter;
import org.mariadb.jdbc.internal.stream.PacketOutputStream;
import org.mariadb.jdbc.internal.util.dao.QueryException;

public class SerializableParameter
extends LongDataParameter {
    private Object object;
    private boolean noBackSlashEscapes;
    private byte[] loadedStream = null;

    public SerializableParameter(Object object, boolean noBackslashEscapes) throws IOException {
        this.object = object;
        this.noBackSlashEscapes = noBackslashEscapes;
    }

    @Override
    public void writeTo(PacketOutputStream os) throws IOException {
        if (this.loadedStream == null) {
            this.writeObjectToBytes();
        }
        ParameterWriter.write((OutputStream)os, this.loadedStream, this.noBackSlashEscapes);
    }

    @Override
    public void writeUnsafeTo(PacketOutputStream os) throws IOException {
        if (this.loadedStream == null) {
            this.writeObjectToBytes();
        }
        ParameterWriter.writeUnsafe(os, this.loadedStream, this.noBackSlashEscapes);
    }

    private void writeObjectToBytes() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(this.object);
        this.loadedStream = baos.toByteArray();
        this.object = null;
    }

    @Override
    public long getApproximateTextProtocolLength() throws IOException {
        this.writeObjectToBytes();
        return this.loadedStream.length;
    }

    @Override
    public void sendComLongData(int statementId, short parameterId, PacketOutputStream writer) throws IOException, QueryException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(this.object);
        writer.startPacket(0);
        writer.buffer.put((byte)24);
        writer.writeInt(statementId);
        writer.buffer.putShort(parameterId);
        writer.write(baos.toByteArray());
        writer.finishPacketWithoutRelease(true);
    }

    @Override
    public String toString() {
        if (this.loadedStream != null) {
            return "<Serializable:" + new String(this.loadedStream) + ">";
        }
        return "<Serializable:" + this.object.toString() + ">";
    }

    @Override
    public MariaDbType getMariaDbType() {
        return MariaDbType.BLOB;
    }
}

