/*
 * Decompiled with CFR 0.152.
 */
package org.grails.orm.hibernate.access;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.codehaus.groovy.transform.trait.Traits;
import org.grails.datastore.mapping.reflect.NameUtils;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.property.access.spi.GetterFieldImpl;
import org.hibernate.property.access.spi.GetterMethodImpl;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.property.access.spi.PropertyAccessStrategy;
import org.hibernate.property.access.spi.Setter;
import org.hibernate.property.access.spi.SetterFieldImpl;
import org.hibernate.property.access.spi.SetterMethodImpl;
import org.springframework.util.ReflectionUtils;

public class TraitPropertyAccessStrategy
implements PropertyAccessStrategy {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PropertyAccess buildPropertyAccess(Class containerJavaType, String propertyName) {
        SetterFieldImpl setter;
        GetterMethodImpl getter;
        Field field;
        String traitFieldName;
        Method readMethod = ReflectionUtils.findMethod((Class)containerJavaType, (String)NameUtils.getGetterName((String)propertyName));
        if (readMethod == null) {
            throw new IllegalStateException("TraitPropertyAccessStrategy used on property [" + propertyName + "] of class [" + containerJavaType.getName() + "] that is not provided by a trait!");
        }
        Traits.Implemented traitImplemented = readMethod.getAnnotation(Traits.Implemented.class);
        if (traitImplemented == null) {
            Traits.TraitBridge traitBridge = readMethod.getAnnotation(Traits.TraitBridge.class);
            if (traitBridge == null) throw new IllegalStateException("TraitPropertyAccessStrategy used on property [" + propertyName + "] of class [" + containerJavaType.getName() + "] that is not provided by a trait!");
            traitFieldName = this.getTraitFieldName(traitBridge.traitClass(), propertyName);
        } else {
            traitFieldName = this.getTraitFieldName(readMethod.getDeclaringClass(), propertyName);
        }
        if ((field = ReflectionUtils.findField((Class)containerJavaType, (String)traitFieldName)) == null) {
            getter = new GetterMethodImpl(containerJavaType, propertyName, readMethod);
            Method writeMethod = ReflectionUtils.findMethod((Class)containerJavaType, (String)NameUtils.getSetterName((String)propertyName), (Class[])new Class[]{readMethod.getReturnType()});
            setter = new SetterMethodImpl(containerJavaType, propertyName, writeMethod);
            return new PropertyAccess((Getter)getter, (Setter)setter){
                final /* synthetic */ Getter val$getter;
                final /* synthetic */ Setter val$setter;
                {
                    this.val$getter = getter;
                    this.val$setter = setter;
                }

                public PropertyAccessStrategy getPropertyAccessStrategy() {
                    return TraitPropertyAccessStrategy.this;
                }

                public Getter getGetter() {
                    return this.val$getter;
                }

                public Setter getSetter() {
                    return this.val$setter;
                }
            };
        } else {
            getter = new GetterFieldImpl(containerJavaType, propertyName, field);
            setter = new SetterFieldImpl(containerJavaType, propertyName, field);
        }
        return new /* invalid duplicate definition of identical inner class */;
    }

    private String getTraitFieldName(Class traitClass, String fieldName) {
        return traitClass.getName().replace('.', '_') + "__" + fieldName;
    }
}

