/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.toc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.docx4j.jaxb.Context;
import org.docx4j.toc.TocException;
import org.docx4j.toc.TocSdtUtils;
import org.docx4j.toc.switches.SwitchInterface;
import org.docx4j.toc.switches.SwitchesFactory;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.R;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Toc {
    private static Logger log = LoggerFactory.getLogger(Toc.class);
    private static final String ERROR_BOOKMARK_NOT_DEFINED = "Error! Bookmark not defined.";
    private static final String SPACE = " ";
    private static final String TOC_INSTRUCTION_MASK = "TOC ";
    private static final String DEFAULT_TOC_INSTRUCTION = "TOC \\o \"1-3\" \\h \\z \\u ";
    protected static String DEFAULT_TOC_HEADING = "Contents";
    private String tocInstruction;
    private String errorString = "";
    private static ObjectFactory wmlObjectFactory = Context.getWmlObjectFactory();
    private List<SwitchInterface> switchesList = new ArrayList<SwitchInterface>();

    public static void setTocHeadingText(String tocHeadingText) {
        DEFAULT_TOC_HEADING = tocHeadingText;
    }

    protected static String getTocHeadingText() {
        return DEFAULT_TOC_HEADING;
    }

    private Toc() {
    }

    public Toc(String tocInstruction) throws TocException {
        this.tocInstruction = tocInstruction.trim();
        this.parseInstruction();
    }

    private void parseInstruction() throws TocException {
        if (this.tocInstruction == null || !this.tocInstruction.startsWith(TOC_INSTRUCTION_MASK)) {
            throw new TocException("Invalid TOC instruction " + this.tocInstruction);
        }
        String toParse = this.tocInstruction.substring(TOC_INSTRUCTION_MASK.length());
        if (toParse.isEmpty()) {
            this.switchesList.add(SwitchesFactory.getSwitch("\\o"));
            return;
        }
        log.debug("starting to parse: " + toParse);
        String[] switchesArray = toParse.split(SPACE);
        for (int i = 0; i < switchesArray.length; ++i) {
            String fieldArgument;
            SwitchInterface tocSwitch = SwitchesFactory.getSwitch(switchesArray[i]);
            if (tocSwitch == null) continue;
            if (i + 1 < switchesArray.length) {
                fieldArgument = switchesArray[i + 1];
                if (tocSwitch.hasFieldArgument() && SwitchesFactory.getSwitch(fieldArgument) == null) {
                    ++i;
                } else {
                    fieldArgument = null;
                }
            } else {
                fieldArgument = null;
            }
            this.errorString = tocSwitch.parseFieldArgument(fieldArgument);
            if (!this.errorString.isEmpty()) {
                throw new TocException(this.errorString);
            }
            this.switchesList.add(tocSwitch);
            log.debug("Got switch: " + tocSwitch);
        }
        if (this.switchesList.isEmpty()) {
            this.switchesList.add(SwitchesFactory.getSwitch("\\o"));
        }
        this.sortSwitchesListByPriority();
    }

    private void sortSwitchesListByPriority() {
        Collections.sort(this.switchesList, new Comparator<SwitchInterface>(){

            @Override
            public int compare(SwitchInterface o1, SwitchInterface o2) {
                if (o1.getPriority() > o2.getPriority()) {
                    return -1;
                }
                return 1;
            }
        });
    }

    public boolean hasErrors() {
        return !this.errorString.isEmpty();
    }

    public List<SwitchInterface> getSwitches() {
        return this.switchesList;
    }

    @Deprecated
    public List<R> getTocInstruction() {
        return TocSdtUtils.getTocInstruction(this.tocInstruction);
    }
}

