/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.packet;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.mariadb.jdbc.internal.packet.dao.ColumnInformation;
import org.mariadb.jdbc.internal.packet.read.ReadPacketFetcher;
import org.mariadb.jdbc.internal.packet.result.ErrorPacket;
import org.mariadb.jdbc.internal.protocol.Protocol;
import org.mariadb.jdbc.internal.stream.PacketOutputStream;
import org.mariadb.jdbc.internal.stream.PrepareException;
import org.mariadb.jdbc.internal.util.buffer.Buffer;
import org.mariadb.jdbc.internal.util.dao.QueryException;
import org.mariadb.jdbc.internal.util.dao.ServerPrepareResult;

public class ComStmtPrepare {
    private final Protocol protocol;
    private final String sql;

    public ComStmtPrepare(Protocol protocol, String sql) {
        this.protocol = protocol;
        this.sql = sql;
    }

    public void send(PacketOutputStream writer) throws IOException, QueryException {
        writer.send(this.sql, (byte)22);
    }

    public void sendSubCmd(PacketOutputStream writer) throws IOException, QueryException {
        byte[] sqlBytes = this.sql.getBytes(StandardCharsets.UTF_8);
        writer.assureBufferCapacity(sqlBytes.length + 10);
        writer.writeFieldLength(sqlBytes.length + 1);
        writer.buffer.put((byte)22);
        writer.buffer.put(sqlBytes);
    }

    public ServerPrepareResult read(ReadPacketFetcher packetFetcher) throws IOException, QueryException {
        Buffer buffer = packetFetcher.getReusableBuffer();
        byte firstByte = buffer.getByteAt(0);
        if (firstByte == -1) {
            ErrorPacket ep = new ErrorPacket(buffer);
            String message = ep.getMessage();
            if (1054 == ep.getErrorNumber()) {
                throw new PrepareException("Error preparing query: " + message + "\nIf column exists but type cannot be identified (example 'select ? `field1` from dual'). Use CAST function to solve this problem (example 'select CAST(? as integer) `field1` from dual')", (int)ep.getErrorNumber(), ep.getSqlState());
            }
            throw new PrepareException("Error preparing query: " + message, (int)ep.getErrorNumber(), ep.getSqlState());
        }
        if (firstByte == 0) {
            int i;
            buffer.readByte();
            int statementId = buffer.readInt();
            int numColumns = buffer.readShort() & 0xFFFF;
            int numParams = buffer.readShort() & 0xFFFF;
            ColumnInformation[] params = new ColumnInformation[numParams];
            ColumnInformation[] columns = new ColumnInformation[numColumns];
            if (numParams > 0) {
                for (i = 0; i < numParams; ++i) {
                    params[i] = new ColumnInformation(packetFetcher.getPacket());
                }
                if (numColumns > 0) {
                    this.protocol.skipEofPacket();
                    for (i = 0; i < numColumns; ++i) {
                        columns[i] = new ColumnInformation(packetFetcher.getPacket());
                    }
                }
                this.protocol.readEofPacket();
            } else if (numColumns > 0) {
                for (i = 0; i < numColumns; ++i) {
                    columns[i] = new ColumnInformation(packetFetcher.getPacket());
                }
                this.protocol.readEofPacket();
            } else {
                buffer.readByte();
                this.protocol.setHasWarnings(buffer.readShort() > 0);
            }
            ServerPrepareResult serverPrepareResult = new ServerPrepareResult(this.sql, statementId, columns, params, this.protocol);
            if (this.protocol.getOptions().cachePrepStmts && this.sql != null && this.sql.length() < this.protocol.getOptions().prepStmtCacheSqlLimit) {
                String key = this.protocol.getDatabase() + "-" + this.sql;
                ServerPrepareResult cachedServerPrepareResult = this.protocol.addPrepareInCache(key, serverPrepareResult);
                return cachedServerPrepareResult != null ? cachedServerPrepareResult : serverPrepareResult;
            }
            return serverPrepareResult;
        }
        throw new QueryException("Unexpected packet returned by server, first byte " + firstByte);
    }
}

