/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.poi.xwpf.converter.core.styles.paragraph;

import fr.opensagres.poi.xwpf.converter.core.styles.AbstractValueProvider;
import fr.opensagres.poi.xwpf.converter.core.styles.XWPFStylesDocument;
import fr.opensagres.poi.xwpf.converter.core.utils.StringUtils;
import fr.opensagres.poi.xwpf.converter.core.utils.StylesHelper;
import java.util.List;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDocDefaults;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPPrBase;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPPrDefault;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTStyle;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblStylePr;

public abstract class AbstractParagraphValueProvider<Value>
extends AbstractValueProvider<Value, XWPFParagraph> {
    public CTPPrBase getCTPPr(XWPFParagraph paragraph) {
        return paragraph.getCTP().getPPr();
    }

    public CTPPrBase getCTPPr(CTStyle style) {
        return style.getPPr();
    }

    public CTPPrBase getCTPPr(CTTblStylePr tblStylePr) {
        return tblStylePr.getPPr();
    }

    public CTPPrBase getCTPPr(CTDocDefaults docDefaults) {
        CTPPrDefault prDefault = docDefaults.getPPrDefault();
        if (prDefault == null) {
            return null;
        }
        return prDefault.getPPr();
    }

    @Override
    public Value getValueFromElement(XWPFParagraph paragraph, XWPFStylesDocument stylesDocument) {
        return this.getValue(this.getCTPPr(paragraph));
    }

    @Override
    protected Value getValueFromStyle(CTStyle style, XWPFStylesDocument stylesDocument) {
        return this.getValue(this.getCTPPr(style));
    }

    @Override
    protected Value getValueFromTableStyle(CTTblStylePr tblStylePr, XWPFStylesDocument stylesDocument) {
        return this.getValue(this.getCTPPr(tblStylePr));
    }

    @Override
    protected Value getValueFromDocDefaultsStyle(CTDocDefaults docDefaults, XWPFStylesDocument stylesDocument) {
        return this.getValue(this.getCTPPr(docDefaults));
    }

    public abstract Value getValue(CTPPrBase var1);

    @Override
    protected String[] getStyleID(XWPFParagraph paragraph) {
        List<String> styleIDs = StylesHelper.getStyleIDs(paragraph);
        if (styleIDs != null) {
            return styleIDs.toArray(StringUtils.EMPTY_STRING_ARRAY);
        }
        return null;
    }

    @Override
    protected CTStyle getDefaultStyle(XWPFParagraph element, XWPFStylesDocument styleManager) {
        return styleManager.getDefaultParagraphStyle();
    }

    @Override
    protected XWPFTableCell getParentTableCell(XWPFParagraph paragraph) {
        return StylesHelper.getEmbeddedTableCell(paragraph);
    }
}

